/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;

public class InputStreamResource
implements Resource {
    private final InputStream in;
    private final String name;

    public InputStreamResource(InputStream in) {
        this(in, null);
    }

    public InputStreamResource(InputStream in, String name) {
        this.in = in;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return this.in;
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return IoKit.getReader(this.in, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(Charset charset) throws InstrumentException {
        BufferedReader reader = null;
        try {
            reader = this.getReader(charset);
            String string = IoKit.read(reader);
            return string;
        }
        finally {
            IoKit.close(reader);
        }
    }

    @Override
    public byte[] readBytes() throws InstrumentException {
        InputStream in = null;
        try {
            in = this.getStream();
            byte[] byArray = IoKit.readBytes(in);
            return byArray;
        }
        finally {
            IoKit.close(in);
        }
    }
}

