/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.thread.AtomicNoLock;

public class Range<T>
implements Iterable<T>,
Iterator<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Lock lock = new ReentrantLock();
    private T start;
    private T end;
    private T current;
    private T next;
    private Steper<T> steper;
    private int index = 0;
    private boolean includeStart;
    private boolean includeEnd;

    public Range(T start, Steper<T> steper) {
        this(start, null, (Steper<Object>)steper);
    }

    public Range(T start, T end, Steper<T> steper) {
        this(start, end, steper, true, true);
    }

    public Range(T start, T end, Steper<T> steper, boolean isIncludeStart, boolean isIncludeEnd) {
        this.start = start;
        this.current = start;
        this.end = end;
        this.steper = steper;
        this.next = this.safeStep(this.current);
        this.includeStart = isIncludeStart;
        this.includeEnd = true;
        this.includeEnd = isIncludeEnd;
    }

    public Range<T> disableLock() {
        this.lock = new AtomicNoLock();
        return this;
    }

    @Override
    public boolean hasNext() {
        this.lock.lock();
        try {
            if (0 == this.index && this.includeStart) {
                boolean bl = true;
                return bl;
            }
            if (null == this.next) {
                boolean bl = false;
                return bl;
            }
            if (!this.includeEnd && this.next.equals(this.end)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    @Override
    public T next() {
        this.lock.lock();
        try {
            if (!this.hasNext()) {
                throw new NoSuchElementException("Has no next range!");
            }
            T t = this.nextUncheck();
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    private T nextUncheck() {
        if (0 != this.index || !this.includeStart) {
            this.current = this.next;
            if (null != this.current) {
                this.next = this.safeStep(this.next);
            }
        }
        ++this.index;
        return this.current;
    }

    private T safeStep(T base) {
        T next = null;
        try {
            next = this.steper.step(base, this.end, this.index);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can not remove ranged element!");
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public Range<T> reset() {
        this.lock.lock();
        try {
            this.current = this.start;
            this.index = 0;
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    public static interface Steper<T> {
        public T step(T var1, T var2, int var3);
    }
}

