/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier.provider;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.toolkit.StringKit;

public class MapValueProvider
implements ValueProvider<String> {
    private final Map<?, ?> map;
    private final boolean ignoreError;

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase) {
        this(map, ignoreCase, false);
    }

    public MapValueProvider(Map<?, ?> map, boolean ignoreCase, boolean ignoreError) {
        this.map = false == ignoreCase || map instanceof CaseInsensitiveMap ? map : new CaseInsensitiveMap(map);
        this.ignoreError = ignoreError;
    }

    @Override
    public Object value(String key, Type valueType) {
        Object value = this.map.get(key);
        if (null == value) {
            value = this.map.get(StringKit.toUnderlineCase(key));
        }
        return Convert.convertWithCheck(valueType, value, null, this.ignoreError);
    }

    @Override
    public boolean containsKey(String key) {
        if (this.map.containsKey(key)) {
            return true;
        }
        return this.map.containsKey(StringKit.toUnderlineCase(key));
    }
}

