/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.aoju.bus.core.io.VirtualBuffer;

public class PageBuffer {
    private List<VirtualBuffer> availableBuffers;
    private ConcurrentLinkedQueue<VirtualBuffer> cleanBuffers = new ConcurrentLinkedQueue();
    private ByteBuffer buffer;
    private ReentrantLock lock = new ReentrantLock();
    private long lastAllocateTime;

    PageBuffer(int size, boolean direct) {
        this.availableBuffers = new LinkedList<VirtualBuffer>();
        this.buffer = this.allocate0(size, direct);
        this.availableBuffers.add(new VirtualBuffer(this, null, this.buffer.position(), this.buffer.limit()));
    }

    private ByteBuffer allocate0(int size, boolean direct) {
        return direct ? ByteBuffer.allocateDirect(size) : ByteBuffer.allocate(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualBuffer allocate(int size) {
        this.lastAllocateTime = System.currentTimeMillis();
        VirtualBuffer cleanBuffer = this.cleanBuffers.poll();
        if (cleanBuffer != null && cleanBuffer.getParentLimit() - cleanBuffer.getParentPosition() >= size) {
            cleanBuffer.buffer().clear();
            cleanBuffer.buffer(cleanBuffer.buffer());
            return cleanBuffer;
        }
        this.lock.lock();
        try {
            if (cleanBuffer != null) {
                this.clean0(cleanBuffer);
            }
            while ((cleanBuffer = this.cleanBuffers.poll()) != null) {
                if (cleanBuffer.getParentLimit() - cleanBuffer.getParentPosition() >= size) {
                    cleanBuffer.buffer().clear();
                    cleanBuffer.buffer(cleanBuffer.buffer());
                    VirtualBuffer virtualBuffer = cleanBuffer;
                    return virtualBuffer;
                }
                this.clean0(cleanBuffer);
            }
            Iterator<VirtualBuffer> iterator = this.availableBuffers.iterator();
            while (iterator.hasNext()) {
                VirtualBuffer bufferChunk;
                VirtualBuffer freeChunk = iterator.next();
                int remaining = freeChunk.getParentLimit() - freeChunk.getParentPosition();
                if (remaining < size) continue;
                if (remaining == size) {
                    iterator.remove();
                    this.buffer.limit(freeChunk.getParentLimit());
                    this.buffer.position(freeChunk.getParentPosition());
                    freeChunk.buffer(this.buffer.slice());
                    bufferChunk = freeChunk;
                } else {
                    this.buffer.limit(freeChunk.getParentPosition() + size);
                    this.buffer.position(freeChunk.getParentPosition());
                    bufferChunk = new VirtualBuffer(this, this.buffer.slice(), this.buffer.position(), this.buffer.limit());
                    freeChunk.setParentPosition(this.buffer.limit());
                }
                if (bufferChunk.buffer().remaining() != size) {
                    throw new RuntimeException("allocate " + size + ", buffer:" + bufferChunk);
                }
                VirtualBuffer virtualBuffer = bufferChunk;
                return virtualBuffer;
            }
        }
        finally {
            this.lock.unlock();
        }
        return new VirtualBuffer(null, this.allocate0(size, false), 0, 0);
    }

    void clean(VirtualBuffer cleanBuffer) {
        if (this.cleanBuffers.offer(cleanBuffer)) {
            return;
        }
        this.lock.lock();
        try {
            this.clean0(cleanBuffer);
        }
        finally {
            this.lock.unlock();
        }
    }

    void tryClean() {
        if (System.currentTimeMillis() - this.lastAllocateTime < 1000L || !this.lock.tryLock()) {
            return;
        }
        try {
            VirtualBuffer cleanBuffer;
            while ((cleanBuffer = this.cleanBuffers.poll()) != null) {
                this.clean0(cleanBuffer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void clean0(VirtualBuffer cleanBuffer) {
        int index = 0;
        Iterator<VirtualBuffer> iterator = this.availableBuffers.iterator();
        while (iterator.hasNext()) {
            VirtualBuffer freeBuffer = iterator.next();
            if (freeBuffer.getParentPosition() == cleanBuffer.getParentLimit()) {
                freeBuffer.setParentPosition(cleanBuffer.getParentPosition());
                return;
            }
            if (freeBuffer.getParentLimit() == cleanBuffer.getParentPosition()) {
                freeBuffer.setParentLimit(cleanBuffer.getParentLimit());
                if (iterator.hasNext()) {
                    VirtualBuffer next = iterator.next();
                    if (next.getParentPosition() == freeBuffer.getParentLimit()) {
                        freeBuffer.setParentLimit(next.getParentLimit());
                        iterator.remove();
                    } else if (next.getParentPosition() < freeBuffer.getParentLimit()) {
                        throw new IllegalStateException("");
                    }
                }
                return;
            }
            if (freeBuffer.getParentPosition() > cleanBuffer.getParentLimit()) {
                this.availableBuffers.add(index, cleanBuffer);
                return;
            }
            ++index;
        }
        this.availableBuffers.add(cleanBuffer);
    }
}

