/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.UriKit;

public class UriResource
implements Resource {
    protected URL url;
    protected String name;

    public UriResource(URL url) {
        this(url, null);
    }

    public UriResource(URL url, String name) {
        this.url = url;
        this.name = ObjectKit.defaultIfNull(name, null != url ? FileKit.getName(url.getPath()) : null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        return this.url;
    }

    @Override
    public InputStream getStream() {
        if (null == this.url) {
            throw new InstrumentException("Resource URL is null!");
        }
        return UriKit.getStream(this.url);
    }

    @Override
    public BufferedReader getReader(Charset charset) {
        return UriKit.getReader(this.url, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString(Charset charset) throws InstrumentException {
        BufferedReader reader = null;
        try {
            reader = this.getReader(charset);
            String string = IoKit.read(reader);
            return string;
        }
        finally {
            IoKit.close(reader);
        }
    }

    @Override
    public byte[] readBytes() throws InstrumentException {
        InputStream in = null;
        try {
            in = this.getStream();
            byte[] byArray = IoKit.readBytes(in);
            return byArray;
        }
        finally {
            IoKit.close(in);
        }
    }

    public File getFile() {
        return FileKit.file(this.url);
    }

    public String toString() {
        return null == this.url ? "null" : this.url.toString();
    }
}

