/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class BooleanKit {
    public static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.class || clazz == Boolean.TYPE;
    }

    public static boolean isTrue(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }

    public static boolean isFalse(Boolean bool) {
        return Boolean.FALSE.equals(bool);
    }

    public static boolean toBoolean(String valueStr) {
        if (StringKit.isNotBlank(valueStr)) {
            valueStr = valueStr.trim().toLowerCase();
            return ArrayKit.contains(Normal.TRUE_ARRAY, valueStr);
        }
        return false;
    }

    public static int toInt(boolean value) {
        return value ? 1 : 0;
    }

    public static Integer toInteger(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static char toChar(boolean value) {
        return (char)BooleanKit.toInt(value);
    }

    public static Character toCharacter(boolean value) {
        return Character.valueOf(BooleanKit.toChar(value));
    }

    public static byte toByte(boolean value) {
        return (byte)BooleanKit.toInt(value);
    }

    public static Byte toByteObj(boolean value) {
        return BooleanKit.toByte(value);
    }

    public static long toLong(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Long toLongObj(boolean value) {
        return BooleanKit.toLong(value);
    }

    public static short toShort(boolean value) {
        return (short)BooleanKit.toInt(value);
    }

    public static Short toShortObj(boolean value) {
        return BooleanKit.toShort(value);
    }

    public static float toFloat(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Float toFloatObj(boolean value) {
        return Float.valueOf(BooleanKit.toFloat(value));
    }

    public static double toDouble(boolean value) {
        return BooleanKit.toInt(value);
    }

    public static Double toDoubleObj(boolean value) {
        return BooleanKit.toDouble(value);
    }

    public static String toStringTrueFalse(boolean bool) {
        return BooleanKit.toString(bool, "true", "false");
    }

    public static String toStringOnOff(boolean bool) {
        return BooleanKit.toString(bool, "on", "off");
    }

    public static String toStringYesNo(boolean bool) {
        return BooleanKit.toString(bool, "yes", "no");
    }

    public static String toString(boolean bool, String trueString, String falseString) {
        return bool ? trueString : falseString;
    }

    public static boolean and(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (element) continue;
            return false;
        }
        return true;
    }

    public static Boolean and(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanKit.and(primitive);
    }

    public static boolean or(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        for (boolean element : array) {
            if (!element) continue;
            return true;
        }
        return false;
    }

    public static Boolean or(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanKit.or(primitive);
    }

    public static boolean xor(boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty");
        }
        boolean result = false;
        for (boolean element : array) {
            result ^= element;
        }
        return result;
    }

    public static Boolean xor(Boolean ... array) {
        if (ArrayKit.isEmpty(array)) {
            throw new IllegalArgumentException("The Array must not be empty !");
        }
        boolean[] primitive = Convert.convert(boolean[].class, (Object)array);
        return BooleanKit.xor(primitive);
    }

    public static Boolean negate(Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? Boolean.FALSE : Boolean.TRUE;
    }

    public static boolean negate(boolean bool) {
        return !bool;
    }

    public static int compare(boolean x, boolean y) {
        if (x == y) {
            return 0;
        }
        return x ? 1 : -1;
    }
}

