/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class ImageKit {
    public static void scale(File srcImageFile, File destImageFile, float scale) {
        ImageKit.scale((Image)ImageKit.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        ImageKit.scale((Image)ImageKit.read(srcStream), destStream, scale);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        ImageKit.scale((Image)ImageKit.read(srcStream), destStream, scale);
    }

    public static void scale(Image srcImage, File destFile, float scale) throws InstrumentException {
        org.aoju.bus.core.image.Image.from(srcImage).setTargetImageType(FileKit.extName(destFile)).scale(scale).write(destFile);
    }

    public static void scale(Image srcImage, OutputStream out, float scale) throws InstrumentException {
        ImageKit.scale(srcImage, ImageKit.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, float scale) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.scale(srcImage, scale), destImageStream);
    }

    public static Image scale(Image srcImage, float scale) {
        return org.aoju.bus.core.image.Image.from(srcImage).scale(scale).getImg();
    }

    public static Image scale(Image srcImage, int width, int height) {
        return org.aoju.bus.core.image.Image.from(srcImage).scale(width, height).getImg();
    }

    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws InstrumentException {
        ImageKit.write(ImageKit.scale(ImageKit.read(srcImageFile), width, height, fixedColor), destImageFile);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws InstrumentException {
        ImageKit.scale(ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws InstrumentException {
        ImageKit.scale(ImageKit.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return org.aoju.bus.core.image.Image.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        ImageKit.cut((Image)ImageKit.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        ImageKit.cut((Image)ImageKit.read(srcStream), destStream, rectangle);
    }

    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        ImageKit.cut((Image)ImageKit.read(srcStream), destStream, rectangle);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws InstrumentException {
        ImageKit.write(ImageKit.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws InstrumentException {
        ImageKit.cut(srcImage, ImageKit.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.cut(srcImage, rectangle), destImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return org.aoju.bus.core.image.Image.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return ImageKit.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return org.aoju.bus.core.image.Image.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        ImageKit.slice(ImageKit.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getHeight(null);
        int srcHeight = srcImage.getWidth(null);
        try {
            if (srcWidth > destWidth && srcHeight > destHeight) {
                int cols = 0;
                int rows = 0;
                cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor(srcWidth / destWidth) + 1;
                rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor(srcHeight / destHeight) + 1;
                for (int i = 0; i < rows; ++i) {
                    for (int j = 0; j < cols; ++j) {
                        Image tag = ImageKit.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                        ImageIO.write(ImageKit.toRenderedImage(tag), "jpeg", new File(descDir, "_r" + i + "_c" + j + ".jpg"));
                    }
                }
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        try {
            ImageKit.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, rows, cols);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, int rows, int cols) {
        if (!destDir.exists()) {
            FileKit.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageKit.toBufferedImage(srcImage);
            int srcWidth = ((Image)bi).getWidth(null);
            int srcHeight = ((Image)bi).getHeight(null);
            int destWidth = MathKit.partValue(srcWidth, cols);
            int destHeight = MathKit.partValue(srcHeight, rows);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    Image tag = ImageKit.cut(bi, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                    ImageIO.write(ImageKit.toRenderedImage(tag), "jpeg", new File(destDir, "_r" + i + "_c" + j + ".jpg"));
                }
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcExtName = FileKit.extName(srcImageFile);
        String destExtName = FileKit.extName(destImageFile);
        if (StringKit.equalsIgnoreCase(srcExtName, destExtName)) {
            FileKit.copy(srcImageFile, destImageFile, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageKit.getImageOutputStream(destImageFile);
            ImageKit.convert(ImageKit.read(srcImageFile), destExtName, imageOutputStream, StringKit.equalsIgnoreCase("png", srcExtName));
        }
        finally {
            IoKit.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        ImageKit.write((Image)ImageKit.read(srcStream), formatName, ImageKit.getImageOutputStream(destStream));
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        try {
            ImageIO.write((RenderedImage)(isSrcPng ? ImageKit.copyImage(srcImage, 1) : ImageKit.toBufferedImage(srcImage)), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void gray(File srcImageFile, File destImageFile) {
        ImageKit.gray((Image)ImageKit.read(srcImageFile), destImageFile);
    }

    public static void gray(InputStream srcStream, OutputStream destStream) {
        ImageKit.gray((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream));
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        ImageKit.gray((Image)ImageKit.read(srcStream), destStream);
    }

    public static void gray(Image srcImage, File outFile) {
        ImageKit.write(ImageKit.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImageKit.gray(srcImage, ImageKit.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.gray(srcImage), destImageStream);
    }

    public static Image gray(Image srcImage) {
        return org.aoju.bus.core.image.Image.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) {
        ImageKit.binary(ImageKit.read(srcImageFile), destImageFile);
    }

    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        ImageKit.binary((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), imageType);
    }

    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        ImageKit.binary((Image)ImageKit.read(srcStream), destStream, imageType);
    }

    public static void binary(Image srcImage, File outFile) {
        ImageKit.write(ImageKit.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImageKit.binary(srcImage, ImageKit.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws InstrumentException {
        ImageKit.write(ImageKit.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(Image srcImage) {
        return org.aoju.bus.core.image.Image.from(srcImage).binary().getImg();
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageKit.pressText((Image)ImageKit.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageKit.pressText((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageKit.pressText((Image)ImageKit.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws InstrumentException {
        ImageKit.write(ImageKit.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws InstrumentException {
        ImageKit.pressText(srcImage, ImageKit.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return org.aoju.bus.core.image.Image.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImage, int x, int y, float alpha) {
        ImageKit.pressImage((Image)ImageKit.read(srcImageFile), destImageFile, pressImage, x, y, alpha);
    }

    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImage, int x, int y, float alpha) {
        ImageKit.pressImage((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), pressImage, x, y, alpha);
    }

    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageKit.pressImage((Image)ImageKit.read(srcStream), destStream, pressImage, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageKit.write(ImageKit.pressImage(srcImage, pressImage, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageKit.pressImage(srcImage, ImageKit.getImageOutputStream(out), pressImage, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImage, int x, int y, float alpha) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.pressImage(srcImage, pressImage, x, y, alpha), destImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImage, int x, int y, float alpha) {
        return org.aoju.bus.core.image.Image.from(srcImage).pressImage(pressImage, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImage, Rectangle rectangle, float alpha) {
        return org.aoju.bus.core.image.Image.from(srcImage).pressImage(pressImage, rectangle, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) throws InstrumentException {
        ImageKit.rotate((Image)ImageKit.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws InstrumentException {
        ImageKit.write(ImageKit.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.rotate(image, degree), ImageKit.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return org.aoju.bus.core.image.Image.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws InstrumentException {
        ImageKit.flip((Image)ImageKit.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws InstrumentException {
        ImageKit.write(ImageKit.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws InstrumentException {
        ImageKit.flip(image, ImageKit.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws InstrumentException {
        ImageKit.writeJpg(ImageKit.flip(image), out);
    }

    public static Image flip(Image image) {
        return org.aoju.bus.core.image.Image.from(image).flip().getImg();
    }

    public static void compress(File imageFile, File outFile, float quality) throws InstrumentException {
        org.aoju.bus.core.image.Image.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(Image image) {
        if (image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        return ImageKit.copyImage(image, 1);
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        return ImageKit.copyImage(image, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        BufferedImage bufferedImage;
        if (!imageType.equalsIgnoreCase("png")) {
            if (image instanceof BufferedImage) {
                bufferedImage = (BufferedImage)image;
                if (1 != bufferedImage.getType()) {
                    bufferedImage = ImageKit.copyImage(image, 1);
                }
            } else {
                bufferedImage = ImageKit.copyImage(image, 1);
            }
        } else {
            bufferedImage = ImageKit.toBufferedImage(image);
        }
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image image, int imageType) {
        return ImageKit.copyImage(image, imageType, null);
    }

    public static BufferedImage copyImage(Image image, int imageType, Color backgroundColor) {
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D bGr = org.aoju.bus.core.image.Graphics.createGraphics(bimage, backgroundColor);
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toImage(String base64) throws InstrumentException {
        return ImageKit.toImage(Base64.decode(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws InstrumentException {
        return ImageKit.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(Image image, String imageType) {
        return IoKit.toStream(ImageKit.toBytes(image, imageType));
    }

    public static String toBase64(Image image, String imageType) {
        return Base64.encode(ImageKit.toBytes(image, imageType));
    }

    public static String toBase64Uri(Image image, String imageType) {
        return UriKit.toURL("image/" + imageType, "base64", ImageKit.toBase64(image, imageType));
    }

    public static byte[] toBytes(Image image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageKit.write(image, imageType, out);
        return out.toByteArray();
    }

    public static void createImage(String str, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) {
        ImageKit.writePng((Image)ImageKit.createImage(str, font, backgroundColor, fontColor, 2), out);
    }

    public static BufferedImage createImage(String str, Font font, Color backgroundColor, Color fontColor, int imageType) {
        Rectangle2D r = ImageKit.getRectangle(str, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (null != backgroundColor) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(ObjectKit.defaultIfNull(fontColor, Color.BLACK));
        g.setFont(font);
        g.drawString(str, 0, font.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(String str, Font font) {
        return font.getStringBounds(str, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static Font createFont(File fontFile) {
        try {
            return Font.createFont(0, fontFile);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontFile);
            }
            catch (Exception e1) {
                throw new InstrumentException(e);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static Font createFont(InputStream fontStream) {
        try {
            return Font.createFont(0, fontStream);
        }
        catch (FontFormatException e) {
            try {
                return Font.createFont(1, fontStream);
            }
            catch (Exception e1) {
                throw new InstrumentException(e1);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static Graphics2D createGraphics(BufferedImage image, Color color) {
        return org.aoju.bus.core.image.Graphics.createGraphics(image, color);
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws InstrumentException {
        ImageKit.write(image, "jpg", destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws InstrumentException {
        ImageKit.write(image, "png", destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws InstrumentException {
        ImageKit.write(image, "jpg", out);
    }

    public static void writePng(Image image, OutputStream out) throws InstrumentException {
        ImageKit.write(image, "png", out);
    }

    public static void write(Image image, String imageType, OutputStream out) throws InstrumentException {
        ImageKit.write(image, imageType, ImageKit.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws InstrumentException {
        return ImageKit.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws InstrumentException {
        if (StringKit.isBlank(imageType)) {
            imageType = "jpg";
        }
        ImageWriter writer = ImageKit.getWriter(image, imageType);
        return ImageKit.write((Image)ImageKit.toBufferedImage(image, imageType), writer, destImageStream, quality);
    }

    public static void write(Image image, File targetFile) throws InstrumentException {
        ImageOutputStream out = null;
        try {
            out = ImageKit.getImageOutputStream(targetFile);
            ImageKit.write(image, FileKit.extName(targetFile), out);
        }
        finally {
            IoKit.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (writer == null) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImageKit.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImageKit.read(FileKit.file(imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        try {
            return ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedImage read(Resource resource) {
        return ImageKit.read(resource.getStream());
    }

    public static BufferedImage read(InputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        try {
            return ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static BufferedImage read(URL imageUrl) {
        try {
            return ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws InstrumentException {
        try {
            return ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws InstrumentException {
        try {
            return ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws InstrumentException {
        try {
            return ImageIO.createImageInputStream(in);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static ImageWriter getWriter(Image image, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImageKit.toRenderedImage(image));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        String R = Integer.toHexString(color.getRed());
        R = R.length() < 2 ? '0' + R : R;
        String G = Integer.toHexString(color.getGreen());
        G = G.length() < 2 ? '0' + G : G;
        String B = Integer.toHexString(color.getBlue());
        B = B.length() < 2 ? '0' + B : B;
        return '#' + R + G + B;
    }

    public static Color hexToColor(String hex) {
        return ImageKit.getColor(Integer.parseInt(StringKit.removePrefix("#", hex), 16));
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color getColor(String colorName) {
        if (StringKit.isBlank(colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARK_GRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ImageKit.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ImageKit.hexToColor("#ac9c85");
        }
        if (StringKit.startWith((CharSequence)colorName, '#')) {
            return ImageKit.hexToColor(colorName);
        }
        if (StringKit.startWith((CharSequence)colorName, '$')) {
            return ImageKit.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = StringKit.split(colorName, ',');
        if (3 == rgb.size()) {
            Integer b;
            Integer g;
            Integer r = Convert.toInt(rgb.get(0));
            if (!ArrayKit.hasNull(r, g = Convert.toInt(rgb.get(1)), b = Convert.toInt(rgb.get(2)))) {
                return new Color(r, g, b);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color randomColor() {
        return ImageKit.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomKit.getRandom();
        }
        return new Color(random.nextInt(255), random.nextInt(255), random.nextInt(255));
    }
}

