/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.HttpCookie;
import java.net.IDN;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NetKit {
    public static final int PORT_RANGE_MIN = 1024;
    public static final int PORT_RANGE_MAX = 65535;

    public static String longToIpv4(long longIP) {
        StringBuilder sb = new StringBuilder();
        sb.append(longIP >>> 24);
        sb.append(".");
        sb.append((longIP & 0xFFFFFFL) >>> 16);
        sb.append(".");
        sb.append((longIP & 0xFFFFL) >>> 8);
        sb.append(".");
        sb.append(longIP & 0xFFL);
        return sb.toString();
    }

    public static long ipv4ToLong(String strIP) {
        if (Validator.isIpv4(strIP)) {
            long[] ip = new long[4];
            int position1 = strIP.indexOf(".");
            int position2 = strIP.indexOf(".", position1 + 1);
            int position3 = strIP.indexOf(".", position2 + 1);
            ip[0] = Long.parseLong(strIP.substring(0, position1));
            ip[1] = Long.parseLong(strIP.substring(position1 + 1, position2));
            ip[2] = Long.parseLong(strIP.substring(position2 + 1, position3));
            ip[3] = Long.parseLong(strIP.substring(position3 + 1));
            return (ip[0] << 24) + (ip[1] << 16) + (ip[2] << 8) + ip[3];
        }
        return 0L;
    }

    public static boolean isUsableLocalPort(int port) {
        Throwable throwable;
        if (!NetKit.isValidPort(port)) {
            return false;
        }
        try {
            throwable = null;
            try (ServerSocket ss = new ServerSocket(port);){
                ss.setReuseAddress(true);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        try {
            throwable = null;
            try (DatagramSocket ds = new DatagramSocket(port);){
                ds.setReuseAddress(true);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    public static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public static int getUsableLocalPort() {
        return NetKit.getUsableLocalPort(1024);
    }

    public static int getUsableLocalPort(int minPort) {
        return NetKit.getUsableLocalPort(minPort, 65535);
    }

    public static int getUsableLocalPort(int minPort, int maxPort) {
        int maxPortExclude = maxPort + 1;
        for (int i = minPort; i < maxPortExclude; ++i) {
            int randomPort = RandomKit.randomInt(minPort, maxPortExclude);
            if (!NetKit.isUsableLocalPort(randomPort)) continue;
            return randomPort;
        }
        throw new InstrumentException("Could not find an available port in the range [{}, {}] after {} attempts", minPort, maxPort, maxPort - minPort);
    }

    public static TreeSet<Integer> getUsableLocalPorts(int numRequested, int minPort, int maxPort) {
        TreeSet<Integer> availablePorts = new TreeSet<Integer>();
        int attemptCount = 0;
        while (++attemptCount <= numRequested + 100 && availablePorts.size() < numRequested) {
            availablePorts.add(NetKit.getUsableLocalPort(minPort, maxPort));
        }
        if (availablePorts.size() != numRequested) {
            throw new InstrumentException("Could not find {} available  ports in the range [{}, {}]", numRequested, minPort, maxPort);
        }
        return availablePorts;
    }

    public static boolean isInnerIP(String ipAddress) {
        long ipNum = NetKit.ipv4ToLong(ipAddress);
        long aBegin = NetKit.ipv4ToLong("10.0.0.0");
        long aEnd = NetKit.ipv4ToLong("10.255.255.255");
        long bBegin = NetKit.ipv4ToLong("172.16.0.2");
        long bEnd = NetKit.ipv4ToLong("172.31.255.255");
        long cBegin = NetKit.ipv4ToLong("192.168.0.0");
        long cEnd = NetKit.ipv4ToLong("192.168.255.255");
        boolean isInnerIp = NetKit.isInner(ipNum, aBegin, aEnd) || NetKit.isInner(ipNum, bBegin, bEnd) || NetKit.isInner(ipNum, cBegin, cEnd) || ipAddress.equals("127.0.0.1");
        return isInnerIp;
    }

    public static String toAbsoluteUrl(String absoluteBasePath, String relativePath) {
        try {
            URL absoluteUrl = new URL(absoluteBasePath);
            return new URL(absoluteUrl, relativePath).toString();
        }
        catch (Exception e) {
            throw new InstrumentException("To absolute url [{}] base [{}] error!", relativePath, absoluteBasePath);
        }
    }

    public static String hideIpPart(String ip) {
        return new StringBuffer(ip.length()).append(ip, 0, ip.lastIndexOf(".") + 1).append("*").toString();
    }

    public static String hideIpPart(long ip) {
        return NetKit.hideIpPart(NetKit.longToIpv4(ip));
    }

    public static InetSocketAddress buildInetSocketAddress(String host, int defaultPort) {
        int port;
        String destHost;
        int index;
        if (StringKit.isBlank(host)) {
            host = "127.0.0.1";
        }
        if ((index = host.indexOf(":")) != -1) {
            destHost = host.substring(0, index);
            port = Integer.parseInt(host.substring(index + 1));
        } else {
            destHost = host;
            port = defaultPort;
        }
        return new InetSocketAddress(destHost, port);
    }

    public static String getIpByHost(String hostName) {
        try {
            return InetAddress.getByName(hostName).getHostAddress();
        }
        catch (UnknownHostException e) {
            return hostName;
        }
    }

    public static NetworkInterface getNetworkInterface(String name) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = networkInterfaces.nextElement();
            if (null == netInterface || !name.equals(netInterface.getName())) continue;
            return netInterface;
        }
        return null;
    }

    public static Collection<NetworkInterface> getNetworkInterfaces() {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        return CollKit.addAll(new ArrayList(), networkInterfaces);
    }

    public static LinkedHashSet<String> localIpv4s() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(t -> t instanceof Inet4Address);
        return NetKit.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> localIpv6s() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(t -> t instanceof Inet6Address);
        return NetKit.toIpList(localAddressList);
    }

    public static LinkedHashSet<String> toIpList(Set<InetAddress> addressList) {
        LinkedHashSet<String> ipSet = new LinkedHashSet<String>();
        for (InetAddress address : addressList) {
            ipSet.add(address.getHostAddress());
        }
        return ipSet;
    }

    public static LinkedHashSet<String> localIps() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(null);
        return NetKit.toIpList(localAddressList);
    }

    public static LinkedHashSet<InetAddress> localAddressList(Filter<InetAddress> addressFilter) {
        Enumeration<NetworkInterface> networkInterfaces;
        try {
            networkInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new InstrumentException(e);
        }
        if (networkInterfaces == null) {
            throw new InstrumentException("Get network interface error!");
        }
        LinkedHashSet<InetAddress> ipSet = new LinkedHashSet<InetAddress>();
        while (networkInterfaces.hasMoreElements()) {
            NetworkInterface networkInterface = networkInterfaces.nextElement();
            Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress inetAddress = inetAddresses.nextElement();
                if (inetAddress == null || null != addressFilter && !addressFilter.accept(inetAddress)) continue;
                ipSet.add(inetAddress);
            }
        }
        return ipSet;
    }

    public static String getLocalhostStr() {
        InetAddress localhost = NetKit.getLocalhost();
        if (null != localhost) {
            return localhost.getHostAddress();
        }
        return null;
    }

    public static InetAddress getLocalhost() {
        LinkedHashSet<InetAddress> localAddressList = NetKit.localAddressList(address -> false == address.isLoopbackAddress() && false == address.isSiteLocalAddress() && address instanceof Inet4Address);
        if (CollKit.isNotEmpty(localAddressList)) {
            return CollKit.get(localAddressList, 0);
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    public static String getLocalMacAddress() {
        return NetKit.getMacAddress(NetKit.getLocalhost());
    }

    public static String getMacAddress(InetAddress inetAddress) {
        return NetKit.getMacAddress(inetAddress, "-");
    }

    public static String getMacAddress(InetAddress inetAddress, String separator) {
        byte[] mac;
        if (null == inetAddress) {
            return null;
        }
        try {
            mac = NetworkInterface.getByInetAddress(inetAddress).getHardwareAddress();
        }
        catch (SocketException e) {
            throw new InstrumentException(e);
        }
        if (null != mac) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                String s;
                if (i != 0) {
                    sb.append(separator);
                }
                sb.append((s = Integer.toHexString(mac[i] & 0xFF)).length() == 1 ? 0 + s : s);
            }
            return sb.toString();
        }
        return null;
    }

    public static InetSocketAddress createAddress(String host, int port) {
        if (StringKit.isBlank(host)) {
            return new InetSocketAddress(port);
        }
        return new InetSocketAddress(host, port);
    }

    public static void netCat(String host, int port, boolean isBlock, ByteBuffer data) throws InstrumentException {
        try (SocketChannel channel = SocketChannel.open(NetKit.createAddress(host, port));){
            channel.configureBlocking(isBlock);
            channel.write(data);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static void netCat(String host, int port, byte[] data) throws InstrumentException {
        OutputStream out = null;
        try (Socket socket = new Socket(host, port);){
            out = socket.getOutputStream();
            out.write(data);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(out);
                throw throwable;
            }
        }
        IoKit.close(out);
    }

    public static boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = StringKit.splitToArray(ip, 46);
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    public static String idnToASCII(String unicode) {
        return IDN.toASCII(unicode);
    }

    public static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            for (String subIp : ips = ip.trim().split(",")) {
                if (NetKit.isUnknown(subIp)) continue;
                ip = subIp;
                break;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return StringKit.isBlank(checkString) || "unknown".equalsIgnoreCase(checkString);
    }

    public static boolean ping(String ip) {
        return NetKit.ping(ip, 200);
    }

    public static boolean ping(String ip, int timeout) {
        try {
            return InetAddress.getByName(ip).isReachable(timeout);
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static List<HttpCookie> parseCookies(String cookieStr) {
        if (StringKit.isBlank(cookieStr)) {
            return Collections.emptyList();
        }
        return HttpCookie.parse(cookieStr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isOpen(InetSocketAddress address, int timeout) {
        try (Socket sc = new Socket();){
            sc.connect(address, timeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isInner(long userIp, long begin, long end) {
        return userIp >= begin && userIp <= end;
    }
}

