/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date.format;

import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.StringKit;

public class DatePeriod {
    private long betweenMs;
    private Fields.Level level;
    private int levelMaxCount;

    public DatePeriod(long betweenMs, Fields.Level level) {
        this(betweenMs, level, 0);
    }

    public DatePeriod(long betweenMs, Fields.Level level, int levelMaxCount) {
        this.betweenMs = betweenMs;
        this.level = level;
        this.levelMaxCount = levelMaxCount;
    }

    public String format() {
        StringBuilder sb = new StringBuilder();
        if (this.betweenMs > 0L) {
            long day = this.betweenMs / Fields.Time.DAY.getMillis();
            long hour = this.betweenMs / Fields.Time.HOUR.getMillis() - day * 24L;
            long minute = this.betweenMs / Fields.Time.MINUTE.getMillis() - day * 24L * 60L - hour * 60L;
            long second = this.betweenMs / Fields.Time.SECOND.getMillis() - ((day * 24L + hour) * 60L + minute) * 60L;
            long millisecond = this.betweenMs - (((day * 24L + hour) * 60L + minute) * 60L + second) * 1000L;
            int level = this.level.ordinal();
            int levelCount = 0;
            if (this.isLevelCountValid(levelCount) && 0L != day && level >= Fields.Level.DAY.ordinal()) {
                sb.append(day).append(Fields.Level.DAY.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != hour && level >= Fields.Level.HOUR.ordinal()) {
                sb.append(hour).append(Fields.Level.HOUR.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != minute && level >= Fields.Level.MINUTE.ordinal()) {
                sb.append(minute).append(Fields.Level.MINUTE.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != second && level >= Fields.Level.SECOND.ordinal()) {
                sb.append(second).append(Fields.Level.SECOND.name);
                ++levelCount;
            }
            if (this.isLevelCountValid(levelCount) && 0L != millisecond && level >= Fields.Level.MILLISECOND.ordinal()) {
                sb.append(millisecond).append(Fields.Level.MILLISECOND.name);
                ++levelCount;
            }
        }
        if (StringKit.isEmpty(sb)) {
            sb.append(0).append(this.level.name);
        }
        return sb.toString();
    }

    public long getBetweenMs() {
        return this.betweenMs;
    }

    public void setBetweenMs(long betweenMs) {
        this.betweenMs = betweenMs;
    }

    public Fields.Level getLevel() {
        return this.level;
    }

    public void setLevel(Fields.Level level) {
        this.level = level;
    }

    public String toString() {
        return this.format();
    }

    private boolean isLevelCountValid(int levelCount) {
        return this.levelMaxCount <= 0 || levelCount < this.levelMaxCount;
    }
}

