/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class CitizenIdKit {
    private static final int CHINA_ID_MIN_LENGTH = 15;
    private static final int CHINA_ID_MAX_LENGTH = 18;
    private static final int[] WEIGHTING = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    private static Map<String, String> CITY_CODE = new HashMap<String, String>();
    private static Map<String, Integer> TW_FIRST_CODE = new HashMap<String, Integer>();
    private static Map<String, Integer> HK_FIRST_CODE = new HashMap<String, Integer>();

    public static String convert15To18(String idCard) {
        int sYear;
        if (idCard.length() != 15) {
            return null;
        }
        if (Validator.isNumber(idCard)) {
            String birthday = idCard.substring(6, 12);
            DateTime birthDate = DateKit.parse(birthday, "yyMMdd");
            sYear = DateKit.year(birthDate);
            if (sYear > 2000) {
                sYear -= 100;
            }
        } else {
            return null;
        }
        StringBuilder idCard18 = new StringBuilder().append(idCard, 0, 6).append(sYear).append(idCard.substring(8));
        char sVal = CitizenIdKit.getCheckCode18(idCard18.toString());
        idCard18.append(sVal);
        return idCard18.toString();
    }

    public static boolean isValidCard(String idCard) {
        idCard = idCard.trim();
        int length = idCard.length();
        switch (length) {
            case 18: {
                return CitizenIdKit.isValidCard18(idCard);
            }
            case 15: {
                return CitizenIdKit.isValidCard15(idCard);
            }
            case 10: {
                String[] cardVal = CitizenIdKit.isValidCard10(idCard);
                return null != cardVal && "true".equals(cardVal[2]);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idCard) {
        if (18 != idCard.length()) {
            return false;
        }
        String proCode = idCard.substring(0, 2);
        if (null == CITY_CODE.get(proCode)) {
            return false;
        }
        if (!Validator.isBirthday(idCard.substring(6, 14))) {
            return false;
        }
        String code17 = idCard.substring(0, 17);
        char code18 = Character.toLowerCase(idCard.charAt(17));
        if (PatternKit.isMatch(RegEx.NUMBERS, (CharSequence)code17)) {
            char val = CitizenIdKit.getCheckCode18(code17);
            return val == code18;
        }
        return false;
    }

    public static boolean isValidCard15(String idCard) {
        if (15 != idCard.length()) {
            return false;
        }
        if (PatternKit.isMatch(RegEx.NUMBERS, (CharSequence)idCard)) {
            String proCode = idCard.substring(0, 2);
            if (null == CITY_CODE.get(proCode)) {
                return false;
            }
            return false != Validator.isBirthday("19" + idCard.substring(6, 12));
        }
        return false;
    }

    public static String[] isValidCard10(String idCard) {
        if (StringKit.isBlank(idCard)) {
            return null;
        }
        String[] info = new String[3];
        String card = idCard.replaceAll("[\\(|\\)]", "");
        if (card.length() != 8 && card.length() != 9 && idCard.length() != 10) {
            return null;
        }
        if (idCard.matches("^[a-zA-Z][0-9]{9}$")) {
            info[0] = "\u53f0\u6e7e";
            char char2 = idCard.charAt(1);
            if ('1' == char2) {
                info[1] = "M";
            } else if ('2' == char2) {
                info[1] = "F";
            } else {
                info[1] = "N";
                info[2] = "false";
                return info;
            }
            info[2] = CitizenIdKit.isValidTWCard(idCard) ? "true" : "false";
        } else if (idCard.matches("^[1|5|7][0-9]{6}\\(?[0-9A-Z]\\)?$")) {
            info[0] = "\u6fb3\u95e8";
            info[1] = "N";
        } else if (idCard.matches("^[A-Z]{1,2}[0-9]{6}\\(?[0-9A]\\)?$")) {
            info[0] = "\u9999\u6e2f";
            info[1] = "N";
            info[2] = CitizenIdKit.isValidHKCard(idCard) ? "true" : "false";
        } else {
            return null;
        }
        return info;
    }

    public static boolean isValidTWCard(String idCard) {
        if (StringKit.isEmpty(idCard)) {
            return false;
        }
        String start = idCard.substring(0, 1);
        String mid = idCard.substring(1, 9);
        String end = idCard.substring(9, 10);
        Integer iStart = TW_FIRST_CODE.get(start);
        if (null == iStart) {
            return false;
        }
        int sum = iStart / 10 + iStart % 10 * 9;
        char[] chars = mid.toCharArray();
        Integer iflag = 8;
        for (char c : chars) {
            sum += Integer.valueOf(String.valueOf(c)) * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        return (sum % 10 == 0 ? 0 : 10 - sum % 10) == Integer.valueOf(end);
    }

    public static boolean isValidHKCard(String idCard) {
        String card = idCard.replaceAll("[\\(|\\)]", "");
        Integer sum = 0;
        if (card.length() == 9) {
            sum = (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 9 + (Integer.valueOf(card.substring(1, 2).toUpperCase().toCharArray()[0]) - 55) * 8;
            card = card.substring(1, 9);
        } else {
            sum = 522 + (Integer.valueOf(card.substring(0, 1).toUpperCase().toCharArray()[0]) - 55) * 8;
        }
        String mid = card.substring(1, 7);
        String end = card.substring(7, 8);
        char[] chars = mid.toCharArray();
        Integer iflag = 7;
        for (char c : chars) {
            sum = sum + Integer.valueOf(String.valueOf(c)) * iflag;
            Integer n = iflag;
            Integer n2 = iflag = Integer.valueOf(iflag - 1);
        }
        sum = "A".equals(end.toUpperCase()) ? Integer.valueOf(sum + 10) : Integer.valueOf(sum + Integer.valueOf(end));
        return sum % 11 == 0;
    }

    public static String getBirthByIdCard(String idCard) {
        return CitizenIdKit.getBirth(idCard);
    }

    public static String getBirth(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = CitizenIdKit.convert15To18(idCard);
        }
        return idCard.substring(6, 14);
    }

    public static DateTime getBirthDate(String idCard) {
        String birthByIdCard = CitizenIdKit.getBirthByIdCard(idCard);
        return null == birthByIdCard ? null : DateKit.parse(birthByIdCard, Fields.PURE_DATE_FORMAT);
    }

    public static int getAgeByIdCard(String idCard) {
        return CitizenIdKit.getAgeByIdCard(idCard, DateKit.date());
    }

    public static int getAgeByIdCard(String idCard, Date dateToCompare) {
        String birth = CitizenIdKit.getBirthByIdCard(idCard);
        return DateKit.getAge(DateKit.parse(birth, "yyyyMMdd"), dateToCompare);
    }

    public static Short getYearByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = CitizenIdKit.convert15To18(idCard);
        }
        return Short.valueOf(idCard.substring(6, 10));
    }

    public static Short getMonthByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = CitizenIdKit.convert15To18(idCard);
        }
        return Short.valueOf(idCard.substring(10, 12));
    }

    public static Short getDayByIdCard(String idCard) {
        Integer len = idCard.length();
        if (len < 15) {
            return null;
        }
        if (len == 15) {
            idCard = CitizenIdKit.convert15To18(idCard);
        }
        return Short.valueOf(idCard.substring(12, 14));
    }

    public static int getGenderByIdCard(String idCard) {
        Assert.notBlank(idCard);
        int len = idCard.length();
        if (len < 15) {
            throw new IllegalArgumentException("ID Card length must be 15 or 18");
        }
        if (len == 15) {
            idCard = CitizenIdKit.convert15To18(idCard);
        }
        char sCardChar = idCard.charAt(16);
        int gender = -1;
        gender = Integer.parseInt(String.valueOf(sCardChar)) % 2 != 0 ? 1 : 0;
        return gender;
    }

    public static String getProvinceByIdCard(String idCard) {
        int len = idCard.length();
        if (len == 15 || len == 18) {
            String sProvinNum = idCard.substring(0, 2);
            return CITY_CODE.get(sProvinNum);
        }
        return null;
    }

    public static String hide(String idCard, int startInclude, int endExclude) {
        return StringKit.hide(idCard, startInclude, endExclude);
    }

    private static char getCheckCode18(String code17) {
        int sum = CitizenIdKit.getPowerSum(code17.toCharArray());
        return CitizenIdKit.getCheckCode18(sum);
    }

    private static char getCheckCode18(int iSum) {
        switch (iSum % 11) {
            case 10: {
                return '2';
            }
            case 9: {
                return '3';
            }
            case 8: {
                return '4';
            }
            case 7: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 5: {
                return '7';
            }
            case 4: {
                return '8';
            }
            case 3: {
                return '9';
            }
            case 2: {
                return 'x';
            }
            case 1: {
                return '0';
            }
            case 0: {
                return '1';
            }
        }
        return ' ';
    }

    private static int getPowerSum(char[] iArr) {
        int iSum = 0;
        if (WEIGHTING.length == iArr.length) {
            for (int i = 0; i < iArr.length; ++i) {
                iSum += Integer.valueOf(String.valueOf(iArr[i])) * WEIGHTING[i];
            }
        }
        return iSum;
    }

    private String getZodiac(int month, int day) {
        return day < Fields.ZODIAC_SLICED[month - 1] ? Fields.ZODIAC[month - 1] : Fields.ZODIAC[month];
    }

    private String getCNZodiac(Calendar calendar) {
        return Fields.CN_ZODIAC[calendar.get(1) % 12];
    }

    public CitizenInfo getCitizenInfo(String idCard) {
        CitizenInfo citizenInfo = new CitizenInfo();
        if (CitizenIdKit.isValidCard(idCard)) {
            short year = CitizenIdKit.getYearByIdCard(idCard);
            short month = CitizenIdKit.getMonthByIdCard(idCard);
            short day = CitizenIdKit.getDayByIdCard(idCard);
            citizenInfo.setVerify(CitizenIdKit.isValidCard(idCard));
            citizenInfo.setBirthDate(CitizenIdKit.getBirthByIdCard(idCard));
            citizenInfo.setAge(CitizenIdKit.getAgeByIdCard(idCard));
            citizenInfo.setProvince(CitizenIdKit.getProvinceByIdCard(idCard));
            citizenInfo.setBirthYear(year);
            citizenInfo.setBirthMonth(month);
            citizenInfo.setBirthDay(day);
            citizenInfo.setGender(Normal.Gender.getGender("" + CitizenIdKit.getGenderByIdCard(idCard)).getDesc());
            citizenInfo.setZodiac(this.getZodiac(month, day));
            Calendar c = Calendar.getInstance();
            c.set(year, month, day);
            citizenInfo.setCn_zodiac(this.getCNZodiac(c));
        } else {
            citizenInfo.setVerify(false);
        }
        return citizenInfo;
    }

    static {
        CITY_CODE.put("11", "\u5317\u4eac");
        CITY_CODE.put("12", "\u5929\u6d25");
        CITY_CODE.put("13", "\u6cb3\u5317");
        CITY_CODE.put("14", "\u5c71\u897f");
        CITY_CODE.put("15", "\u5185\u8499\u53e4");
        CITY_CODE.put("21", "\u8fbd\u5b81");
        CITY_CODE.put("22", "\u5409\u6797");
        CITY_CODE.put("23", "\u9ed1\u9f99\u6c5f");
        CITY_CODE.put("31", "\u4e0a\u6d77");
        CITY_CODE.put("32", "\u6c5f\u82cf");
        CITY_CODE.put("33", "\u6d59\u6c5f");
        CITY_CODE.put("34", "\u5b89\u5fbd");
        CITY_CODE.put("35", "\u798f\u5efa");
        CITY_CODE.put("36", "\u6c5f\u897f");
        CITY_CODE.put("37", "\u5c71\u4e1c");
        CITY_CODE.put("41", "\u6cb3\u5357");
        CITY_CODE.put("42", "\u6e56\u5317");
        CITY_CODE.put("43", "\u6e56\u5357");
        CITY_CODE.put("44", "\u5e7f\u4e1c");
        CITY_CODE.put("45", "\u5e7f\u897f");
        CITY_CODE.put("46", "\u6d77\u5357");
        CITY_CODE.put("50", "\u91cd\u5e86");
        CITY_CODE.put("51", "\u56db\u5ddd");
        CITY_CODE.put("52", "\u8d35\u5dde");
        CITY_CODE.put("53", "\u4e91\u5357");
        CITY_CODE.put("54", "\u897f\u85cf");
        CITY_CODE.put("61", "\u9655\u897f");
        CITY_CODE.put("62", "\u7518\u8083");
        CITY_CODE.put("63", "\u9752\u6d77");
        CITY_CODE.put("64", "\u5b81\u590f");
        CITY_CODE.put("65", "\u65b0\u7586");
        CITY_CODE.put("71", "\u53f0\u6e7e");
        CITY_CODE.put("81", "\u9999\u6e2f");
        CITY_CODE.put("82", "\u6fb3\u95e8");
        CITY_CODE.put("91", "\u56fd\u5916");
        TW_FIRST_CODE.put("A", 10);
        TW_FIRST_CODE.put("B", 11);
        TW_FIRST_CODE.put("C", 12);
        TW_FIRST_CODE.put("D", 13);
        TW_FIRST_CODE.put("E", 14);
        TW_FIRST_CODE.put("F", 15);
        TW_FIRST_CODE.put("G", 16);
        TW_FIRST_CODE.put("H", 17);
        TW_FIRST_CODE.put("J", 18);
        TW_FIRST_CODE.put("K", 19);
        TW_FIRST_CODE.put("L", 20);
        TW_FIRST_CODE.put("M", 21);
        TW_FIRST_CODE.put("N", 22);
        TW_FIRST_CODE.put("P", 23);
        TW_FIRST_CODE.put("Q", 24);
        TW_FIRST_CODE.put("R", 25);
        TW_FIRST_CODE.put("S", 26);
        TW_FIRST_CODE.put("T", 27);
        TW_FIRST_CODE.put("U", 28);
        TW_FIRST_CODE.put("V", 29);
        TW_FIRST_CODE.put("X", 30);
        TW_FIRST_CODE.put("Y", 31);
        TW_FIRST_CODE.put("W", 32);
        TW_FIRST_CODE.put("Z", 33);
        TW_FIRST_CODE.put("I", 34);
        TW_FIRST_CODE.put("O", 35);
        HK_FIRST_CODE.put("A", 1);
        HK_FIRST_CODE.put("B", 2);
        HK_FIRST_CODE.put("C", 3);
        HK_FIRST_CODE.put("N", 14);
        HK_FIRST_CODE.put("O", 15);
        HK_FIRST_CODE.put("R", 18);
        HK_FIRST_CODE.put("U", 21);
        HK_FIRST_CODE.put("W", 23);
        HK_FIRST_CODE.put("X", 24);
        HK_FIRST_CODE.put("Z", 26);
    }

    class CitizenInfo {
        private boolean verify;
        private String birthDate;
        private String province;
        private Short birthYear;
        private Short birthMonth;
        private Short birthDay;
        private Integer age;
        private String gender;
        private String zodiac;
        private String cn_zodiac;

        CitizenInfo() {
        }

        public boolean isVerify() {
            return this.verify;
        }

        public void setVerify(boolean verify) {
            this.verify = verify;
        }

        public String getBirthDate() {
            return this.birthDate;
        }

        public void setBirthDate(String birthDate) {
            this.birthDate = birthDate;
        }

        public String getProvince() {
            return this.province;
        }

        public void setProvince(String province) {
            this.province = province;
        }

        public Short getBirthYear() {
            return this.birthYear;
        }

        public void setBirthYear(Short birthYear) {
            this.birthYear = birthYear;
        }

        public Short getBirthMonth() {
            return this.birthMonth;
        }

        public void setBirthMonth(Short birthMonth) {
            this.birthMonth = birthMonth;
        }

        public Short getBirthDay() {
            return this.birthDay;
        }

        public void setBirthDay(Short birthDay) {
            this.birthDay = birthDay;
        }

        public Integer getAge() {
            return this.age;
        }

        public void setAge(Integer age) {
            this.age = age;
        }

        public String getGender() {
            return this.gender;
        }

        public void setGender(String gender) {
            this.gender = gender;
        }

        public String getZodiac() {
            return this.zodiac;
        }

        public void setZodiac(String zodiac) {
            this.zodiac = zodiac;
        }

        public String getCn_zodiac() {
            return this.cn_zodiac;
        }

        public void setCn_zodiac(String cn_zodiac) {
            this.cn_zodiac = cn_zodiac;
        }
    }
}

