/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.aoju.bus.core.io.file.FileWriter;
import org.aoju.bus.core.lang.Charset;

public class FileAppender
implements Serializable {
    private final FileWriter writer;
    private final int capacity;
    private final boolean isNewLineMode;
    private final List<String> list = new ArrayList<String>(100);

    public FileAppender(File destFile, int capacity, boolean isNewLineMode) {
        this(destFile, Charset.UTF_8, capacity, isNewLineMode);
    }

    public FileAppender(File destFile, java.nio.charset.Charset charset, int capacity, boolean isNewLineMode) {
        this.capacity = capacity;
        this.isNewLineMode = isNewLineMode;
        this.writer = FileWriter.create(destFile, charset);
    }

    public FileAppender append(String line) {
        if (this.list.size() >= this.capacity) {
            this.flush();
        }
        this.list.add(line);
        return this;
    }

    public FileAppender flush() {
        try (PrintWriter pw = this.writer.getPrintWriter(true);){
            for (String str : this.list) {
                pw.print(str);
                if (!this.isNewLineMode) continue;
                pw.println();
            }
        }
        this.list.clear();
        return this;
    }
}

