/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import org.aoju.bus.core.builder.HashCodeBuilder;
import org.aoju.bus.core.builder.ToStringBuilder;
import org.aoju.bus.core.builder.ToStringStyle;
import org.aoju.bus.core.lang.Editor;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.Matcher;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.mutable.MutableInt;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.CharKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.IterKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class ArrayKit {
    private static final int INDEX_NOT_FOUND = -1;

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static boolean isEmpty(Object array) {
        if (array != null) {
            if (ArrayKit.isArray(array)) {
                return 0 == Array.getLength(array);
            }
            return false;
        }
        return true;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static boolean isEmpty(int[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static boolean isEmpty(short[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static boolean isEmpty(char[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static boolean isEmpty(double[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static boolean isEmpty(float[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return ArrayKit.getLength(array) == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(long[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(int[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(short[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(char[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(byte[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(double[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(float[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isNotEmpty(boolean[] array) {
        return !ArrayKit.isEmpty(array);
    }

    public static boolean isAllEmpty(Object ... args) {
        int count = 0;
        if (ArrayKit.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectKit.isEmpty(element)) continue;
                ++count;
            }
        }
        return count == args.length;
    }

    public static boolean isAllNotEmpty(Object ... args) {
        return false == ArrayKit.hasEmpty(args);
    }

    public static <T> T[] nullToEmpty(T[] array, Class<T[]> type) {
        if (type == null) {
            throw new IllegalArgumentException("The type must not be null");
        }
        if (array == null) {
            return type.cast(Array.newInstance(type.getComponentType(), 0));
        }
        return array;
    }

    public static Object[] nullToEmpty(Object[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_OBJECT_ARRAY;
        }
        return array;
    }

    public static Class<?>[] nullToEmpty(Class<?>[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_CLASS_ARRAY;
        }
        return array;
    }

    public static String[] nullToEmpty(String[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        return array;
    }

    public static long[] nullToEmpty(long[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        return array;
    }

    public static int[] nullToEmpty(int[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_INT_ARRAY;
        }
        return array;
    }

    public static short[] nullToEmpty(short[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        return array;
    }

    public static char[] nullToEmpty(char[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        return array;
    }

    public static byte[] nullToEmpty(byte[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        return array;
    }

    public static double[] nullToEmpty(double[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        return array;
    }

    public static float[] nullToEmpty(float[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        return array;
    }

    public static boolean[] nullToEmpty(boolean[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        return array;
    }

    public static Long[] nullToEmpty(Long[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_LONG_OBJECT_ARRAY;
        }
        return array;
    }

    public static Integer[] nullToEmpty(Integer[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_INTEGER_OBJECT_ARRAY;
        }
        return array;
    }

    public static Short[] nullToEmpty(Short[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_SHORT_OBJECT_ARRAY;
        }
        return array;
    }

    public static Character[] nullToEmpty(Character[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        return array;
    }

    public static Byte[] nullToEmpty(Byte[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_BYTE_OBJECT_ARRAY;
        }
        return array;
    }

    public static Double[] nullToEmpty(Double[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        return array;
    }

    public static Float[] nullToEmpty(Float[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        return array;
    }

    public static Boolean[] nullToEmpty(Boolean[] array) {
        if (ArrayKit.isEmpty(array)) {
            return Normal.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        return array;
    }

    public static boolean hasEmpty(Object ... args) {
        if (ArrayKit.isNotEmpty(args)) {
            for (Object element : args) {
                if (!ObjectKit.isEmpty(element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean hasNull(T ... array) {
        if (ArrayKit.isNotEmpty(array)) {
            for (T element : array) {
                if (null != element) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> boolean isAllNull(T ... array) {
        return null == ArrayKit.firstNonNull(array);
    }

    public static <T> boolean isAllNotNull(T ... array) {
        return false == ArrayKit.hasNull(array);
    }

    public static <T> T firstNonNull(T ... array) {
        return (T)ArrayKit.firstNonNull(Objects::nonNull, array);
    }

    public static <T> T firstNonNull(Matcher<T> matcher, T ... array) {
        if (ArrayKit.isNotEmpty(array)) {
            for (T val : array) {
                if (!matcher.match(val)) continue;
                return val;
            }
        }
        return null;
    }

    public static Optional<Object> firstNotNull(Object[] objects) {
        if (ArrayKit.isEmpty(objects)) {
            return Optional.empty();
        }
        for (Object elem : objects) {
            if (!ObjectKit.isNotNull(elem)) continue;
            return Optional.of(elem);
        }
        return Optional.empty();
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (ArrayKit.isArray(obj)) {
            return Arrays.deepToString((Object[])obj);
        }
        return obj.toString();
    }

    public static String toString(Object array, String stringIfNull) {
        if (array == null) {
            return stringIfNull;
        }
        return new ToStringBuilder(array, ToStringStyle.SIMPLE_STYLE).append(array).toString();
    }

    public static String[] toArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static byte[] toArray(ByteBuffer bytebuffer) {
        if (!bytebuffer.hasArray()) {
            int oldPosition = bytebuffer.position();
            bytebuffer.position(0);
            int size = bytebuffer.limit();
            byte[] buffers = new byte[size];
            bytebuffer.get(buffers);
            bytebuffer.position(oldPosition);
            return buffers;
        }
        return Arrays.copyOfRange(bytebuffer.array(), bytebuffer.position(), bytebuffer.limit());
    }

    public static <T> T[] toArray(Iterator<T> iterator, Class<T> componentType) {
        return ArrayKit.toArray(CollKit.newArrayList(iterator), componentType);
    }

    public static <T> T[] toArray(Iterable<T> iterable, Class<T> componentType) {
        return ArrayKit.toArray(CollKit.toCollection(iterable), componentType);
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> componentType) {
        return collection.toArray(ArrayKit.newArray(componentType, 0));
    }

    private static Object clone(Object array, Class<?> newArrayComponentType) {
        if (array != null) {
            int arrayLength = Array.getLength(array);
            Object newArray = Array.newInstance(array.getClass().getComponentType(), arrayLength + 1);
            System.arraycopy(array, 0, newArray, 0, arrayLength);
            return newArray;
        }
        return Array.newInstance(newArrayComponentType, 1);
    }

    public static <T> T[] clone(T[] array) {
        if (array == null) {
            return null;
        }
        return (Object[])array.clone();
    }

    public static <T> T clone(T obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayKit.isArray(obj)) {
            Object result;
            Class<?> componentType = obj.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                int length = Array.getLength(obj);
                result = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(result, length, Array.get(obj, length));
                }
            } else {
                result = ((Object[])obj).clone();
            }
            return (T)result;
        }
        return null;
    }

    public static long[] clone(long[] array) {
        if (array == null) {
            return null;
        }
        return (long[])array.clone();
    }

    public static int[] clone(int[] array) {
        if (array == null) {
            return null;
        }
        return (int[])array.clone();
    }

    public static short[] clone(short[] array) {
        if (array == null) {
            return null;
        }
        return (short[])array.clone();
    }

    public static char[] clone(char[] array) {
        if (array == null) {
            return null;
        }
        return (char[])array.clone();
    }

    public static byte[] clone(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    public static double[] clone(double[] array) {
        if (array == null) {
            return null;
        }
        return (double[])array.clone();
    }

    public static float[] clone(float[] array) {
        if (array == null) {
            return null;
        }
        return (float[])array.clone();
    }

    public static boolean[] clone(boolean[] array) {
        if (array == null) {
            return null;
        }
        return (boolean[])array.clone();
    }

    public static <T> T[] subarray(T[] array, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        int newSize = endIndex - startIndex;
        Class<?> type = array.getClass().getComponentType();
        if (newSize <= 0) {
            Object[] emptyArray = (Object[])Array.newInstance(type, 0);
            return emptyArray;
        }
        Object[] subarray = (Object[])Array.newInstance(type, newSize);
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static long[] subarray(long[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] subarray = new long[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static int[] subarray(int[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] subarray = new int[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static short[] subarray(short[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] subarray = new short[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static char[] subarray(char[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] subarray = new char[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static byte[] subarray(byte[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] subarray = new byte[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static double[] subarray(double[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] subarray = new double[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static float[] subarray(float[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] subarray = new float[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static boolean[] subarray(boolean[] array, int startIndex, int endIndex) {
        int newSize;
        if (array == null) {
            return null;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex > array.length) {
            endIndex = array.length;
        }
        if ((newSize = endIndex - startIndex) <= 0) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] subarray = new boolean[newSize];
        System.arraycopy(array, startIndex, subarray, 0, newSize);
        return subarray;
    }

    public static boolean isSameLength(Object[] array1, Object[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(long[] array1, long[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(int[] array1, int[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(short[] array1, short[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(char[] array1, char[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(byte[] array1, byte[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(double[] array1, double[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(float[] array1, float[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static boolean isSameLength(boolean[] array1, boolean[] array2) {
        return ArrayKit.getLength(array1) == ArrayKit.getLength(array2);
    }

    public static void reverse(Object[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(long[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(int[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(short[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(char[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(byte[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(double[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(float[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array) {
        if (array == null) {
            return;
        }
        ArrayKit.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            boolean tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(byte[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            byte tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(char[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            char tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(double[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            double tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(float[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            float tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(int[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            int tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(long[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            long tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(Object[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            Object tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void reverse(short[] array, int startIndex, int endIndex) {
        if (array == null) {
            return;
        }
        int i = startIndex < 0 ? 0 : startIndex;
        for (int j = Math.min(array.length, endIndex) - 1; j > i; --j, ++i) {
            short tmp = array[j];
            array[j] = array[i];
            array[i] = tmp;
        }
    }

    public static void swap(Object[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(long[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(int[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(short[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(char[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(byte[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(double[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(float[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2) {
        if (array == null || array.length == 0) {
            return;
        }
        ArrayKit.swap(array, offset1, offset2, 1);
    }

    public static void swap(boolean[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            boolean aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(byte[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            byte aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(char[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            char aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(double[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            double aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(float[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            float aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(int[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            int aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(long[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            long aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(Object[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            Object aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void swap(short[] array, int offset1, int offset2, int len) {
        if (array == null || array.length == 0 || offset1 >= array.length || offset2 >= array.length) {
            return;
        }
        if (offset1 < 0) {
            offset1 = 0;
        }
        if (offset2 < 0) {
            offset2 = 0;
        }
        if (offset1 == offset2) {
            return;
        }
        len = Math.min(Math.min(len, array.length - offset1), array.length - offset2);
        int i = 0;
        while (i < len) {
            short aux = array[offset1];
            array[offset1] = array[offset2];
            array[offset2] = aux;
            ++i;
            ++offset1;
            ++offset2;
        }
    }

    public static void shift(Object[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(long[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(int[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(short[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(char[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(byte[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(double[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(float[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(boolean[] array, int offset) {
        if (array == null) {
            return;
        }
        ArrayKit.shift(array, 0, array.length, offset);
    }

    public static void shift(boolean[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(byte[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(char[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(double[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(float[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(int[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(long[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(Object[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static void shift(short[] array, int startIndex, int endIndex, int offset) {
        int n;
        if (array == null) {
            return;
        }
        if (startIndex >= array.length - 1 || endIndex <= 0) {
            return;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        if (endIndex >= array.length) {
            endIndex = array.length;
        }
        if ((n = endIndex - startIndex) <= 1) {
            return;
        }
        if ((offset %= n) < 0) {
            offset += n;
        }
        while (n > 1 && offset > 0) {
            int n_offset = n - offset;
            if (offset > n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n - n_offset, n_offset);
                n = offset;
                offset -= n_offset;
                continue;
            }
            if (offset < n_offset) {
                ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
                startIndex += offset;
                n = n_offset;
                continue;
            }
            ArrayKit.swap(array, startIndex, startIndex + n_offset, offset);
            break;
        }
    }

    public static int indexOf(Object[] array, Object value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(Object[] array, Object value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        if (value == null) {
            for (int i = index; i < array.length; ++i) {
                if (array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index; i < array.length; ++i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(Object[] array, Object value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(Object[] array, Object value, int index) {
        block6: {
            block5: {
                if (array == null) {
                    return -1;
                }
                if (index < 0) {
                    return -1;
                }
                if (index >= array.length) {
                    index = array.length - 1;
                }
                if (value != null) break block5;
                for (int i = index; i >= 0; --i) {
                    if (array[i] != null) continue;
                    return i;
                }
                break block6;
            }
            if (!array.getClass().getComponentType().isInstance(value)) break block6;
            for (int i = index; i >= 0; --i) {
                if (!value.equals(array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean contains(Object[] array, Object value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static int indexOf(long[] array, long value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(long[] array, long value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(long[] array, long value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(long[] array, long value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(long[] array, long value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static int indexOf(int[] array, int value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(int[] array, int value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(int[] array, int value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(int[] array, int value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(int[] array, int value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static int indexOf(short[] array, short value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(short[] array, short value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(short[] array, short value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(short[] array, short value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static int indexOf(char[] array, char value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(char[] array, char value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(char[] array, char value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(char[] array, char value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(char[] array, char value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static int indexOf(byte[] array, byte value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(byte[] array, byte value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(byte[] array, byte value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(byte[] array, byte value, int index) {
        if (array == null) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static int indexOf(double[] array, double value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(double[] array, double value, double tolerance) {
        return ArrayKit.indexOf(array, value, 0, tolerance);
    }

    public static int indexOf(double[] array, double value, int index) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(double[] array, double value, int index, double tolerance) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        double min = value - tolerance;
        double max = value + tolerance;
        for (int i = index; i < array.length; ++i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(double[] array, double value, double tolerance) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE, tolerance);
    }

    public static int lastIndexOf(double[] array, double value, int index) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(double[] array, double value, int index, double tolerance) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        double min = value - tolerance;
        double max = value + tolerance;
        for (int i = index; i >= 0; --i) {
            if (!(array[i] >= min) || !(array[i] <= max)) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(double[] array, double value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static boolean contains(double[] array, double value, double tolerance) {
        return ArrayKit.indexOf(array, value, 0, tolerance) != -1;
    }

    public static int indexOf(float[] array, float value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(float[] array, float value, int index) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array, float value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(float[] array, float value, int index) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(float[] array, float value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static int indexOf(boolean[] array, boolean value) {
        return ArrayKit.indexOf(array, value, 0);
    }

    public static int indexOf(boolean[] array, boolean value, int index) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            index = 0;
        }
        for (int i = index; i < array.length; ++i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(boolean[] array, boolean value) {
        return ArrayKit.lastIndexOf(array, value, Integer.MAX_VALUE);
    }

    public static int lastIndexOf(boolean[] array, boolean value, int index) {
        if (ArrayKit.isEmpty(array)) {
            return -1;
        }
        if (index < 0) {
            return -1;
        }
        if (index >= array.length) {
            index = array.length - 1;
        }
        for (int i = index; i >= 0; --i) {
            if (value != array[i]) continue;
            return i;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean value) {
        return ArrayKit.indexOf(array, value) != -1;
    }

    public static char[] toPrimitive(Character[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].charValue();
        }
        return result;
    }

    public static char[] toPrimitive(Character[] array, char valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            Character b = array[i];
            result[i] = b == null ? valueForNull : b.charValue();
        }
        return result;
    }

    public static Character[] toObject(char[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] result = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Character.valueOf(array[i]);
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static long[] toPrimitive(Long[] array, long valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] result = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            Long b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Long[] toObject(long[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] result = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static int[] toPrimitive(Integer[] array, int valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] result = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            Integer b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Integer[] toObject(int[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] result = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static short[] toPrimitive(Short[] array, short valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] result = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            Short b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Short[] toObject(short[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] result = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static byte[] toPrimitive(Byte[] array, byte valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] result = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            Byte b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Byte[] toObject(byte[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] result = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array, double valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            Double b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Double[] toObject(double[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].floatValue();
        }
        return result;
    }

    public static float[] toPrimitive(Float[] array, float valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] result = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            Float b = array[i];
            result[i] = b == null ? valueForNull : b.floatValue();
        }
        return result;
    }

    public static Float[] toObject(float[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] result = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = Float.valueOf(array[i]);
        }
        return result;
    }

    public static Object toPrimitive(Object array) {
        if (array == null) {
            return null;
        }
        Class<?> ct = array.getClass().getComponentType();
        Class<?> pt = ClassKit.wrapperToPrimitive(ct);
        if (Integer.TYPE.equals(pt)) {
            return ArrayKit.toPrimitive((Integer[])array);
        }
        if (Long.TYPE.equals(pt)) {
            return ArrayKit.toPrimitive((Long[])array);
        }
        if (Short.TYPE.equals(pt)) {
            return ArrayKit.toPrimitive((Short[])array);
        }
        if (Double.TYPE.equals(pt)) {
            return ArrayKit.toPrimitive((Double[])array);
        }
        if (Float.TYPE.equals(pt)) {
            return ArrayKit.toPrimitive((Float[])array);
        }
        return array;
    }

    public static boolean[] toPrimitive(Boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static boolean[] toPrimitive(Boolean[] array, boolean valueForNull) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] result = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            Boolean b = array[i];
            result[i] = b == null ? valueForNull : b;
        }
        return result;
    }

    public static Boolean[] toObject(boolean[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] result = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] ? Boolean.TRUE : Boolean.FALSE;
        }
        return result;
    }

    public static <T> T[] addAll(T[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        T[] result = ArrayKit.newArray(arrays.getClass().getComponentType().getComponentType(), length);
        length = 0;
        for (T[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static byte[] addAll(byte[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (byte[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        byte[] result = new byte[length];
        length = 0;
        for (byte[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static boolean[] addAll(boolean[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (boolean[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        boolean[] result = new boolean[length];
        length = 0;
        for (boolean[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static char[] addAll(char[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (char[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        char[] result = new char[length];
        length = 0;
        for (char[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static short[] addAll(short[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (short[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        short[] result = new short[length];
        length = 0;
        for (short[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static int[] addAll(int[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (int[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        int[] result = new int[length];
        length = 0;
        for (int[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static long[] addAll(long[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (long[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        long[] result = new long[length];
        length = 0;
        for (long[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static float[] addAll(float[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (float[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        float[] result = new float[length];
        length = 0;
        for (float[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static double[] addAll(double[] ... arrays) {
        if (arrays.length == 1) {
            return arrays[0];
        }
        int length = 0;
        for (double[] array : arrays) {
            if (null == array) continue;
            length += array.length;
        }
        double[] result = new double[length];
        length = 0;
        for (double[] array : arrays) {
            if (null == array) continue;
            System.arraycopy(array, 0, result, length, array.length);
            length += array.length;
        }
        return result;
    }

    public static <T> T[] add(T[] array, T element) {
        Class<?> type;
        if (array != null) {
            type = array.getClass().getComponentType();
        } else if (element != null) {
            type = element.getClass();
        } else {
            throw new IllegalArgumentException("Arguments cannot both be null");
        }
        Object[] newArray = (Object[])ArrayKit.clone(array, type);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static boolean[] add(boolean[] array, boolean element) {
        boolean[] newArray = (boolean[])ArrayKit.clone(array, Boolean.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static byte[] add(byte[] array, byte element) {
        byte[] newArray = (byte[])ArrayKit.clone(array, Byte.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static char[] add(char[] array, char element) {
        char[] newArray = (char[])ArrayKit.clone(array, Character.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static double[] add(double[] array, double element) {
        double[] newArray = (double[])ArrayKit.clone(array, Double.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static float[] add(float[] array, float element) {
        float[] newArray = (float[])ArrayKit.clone(array, Float.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static int[] add(int[] array, int element) {
        int[] newArray = (int[])ArrayKit.clone(array, Integer.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static long[] add(long[] array, long element) {
        long[] newArray = (long[])ArrayKit.clone(array, Long.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static short[] add(short[] array, short element) {
        short[] newArray = (short[])ArrayKit.clone(array, Short.TYPE);
        newArray[newArray.length - 1] = element;
        return newArray;
    }

    public static <T> T[] add(T[] array, int index, T element) {
        Class<?> clss;
        if (array != null) {
            clss = array.getClass().getComponentType();
        } else if (element != null) {
            clss = element.getClass();
        } else {
            throw new IllegalArgumentException("Array and element cannot both be null");
        }
        return (Object[])ArrayKit.add(array, index, element, clss);
    }

    public static boolean[] add(boolean[] array, int index, boolean element) {
        return (boolean[])ArrayKit.add(array, index, element, Boolean.TYPE);
    }

    public static char[] add(char[] array, int index, char element) {
        return (char[])ArrayKit.add(array, index, Character.valueOf(element), Character.TYPE);
    }

    public static byte[] add(byte[] array, int index, byte element) {
        return (byte[])ArrayKit.add(array, index, element, Byte.TYPE);
    }

    public static short[] add(short[] array, int index, short element) {
        return (short[])ArrayKit.add(array, index, element, Short.TYPE);
    }

    public static int[] add(int[] array, int index, int element) {
        return (int[])ArrayKit.add(array, index, element, Integer.TYPE);
    }

    public static long[] add(long[] array, int index, long element) {
        return (long[])ArrayKit.add(array, index, element, Long.TYPE);
    }

    public static float[] add(float[] array, int index, float element) {
        return (float[])ArrayKit.add(array, index, Float.valueOf(element), Float.TYPE);
    }

    public static double[] add(double[] array, int index, double element) {
        return (double[])ArrayKit.add(array, index, element, Double.TYPE);
    }

    private static Object add(Object array, int index, Object element, Class<?> clss) {
        if (array == null) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Length: 0");
            }
            Object joinedArray = Array.newInstance(clss, 1);
            Array.set(joinedArray, 0, element);
            return joinedArray;
        }
        int length = Array.getLength(array);
        if (index > length || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(clss, length + 1);
        System.arraycopy(array, 0, result, 0, index);
        Array.set(result, index, element);
        if (index < length) {
            System.arraycopy(array, index, result, index + 1, length - index);
        }
        return result;
    }

    public static <T> T[] remove(T[] array) {
        if (ArrayKit.isEmpty(array)) {
            return array;
        }
        LinkedHashSet set = new LinkedHashSet(array.length, 1.0f);
        Collections.addAll(set, array);
        return ArrayKit.toArray(set, ArrayKit.getComponentType(array));
    }

    public static <T> T[] remove(T[] array, int index) {
        return (Object[])ArrayKit.remove(array, index);
    }

    public static <T> T[] removeElement(T[] array, Object element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static boolean[] remove(boolean[] array, int index) {
        return (boolean[])ArrayKit.remove((Object)array, index);
    }

    public static boolean[] removeElement(boolean[] array, boolean element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static byte[] remove(byte[] array, int index) {
        return (byte[])ArrayKit.remove((Object)array, index);
    }

    public static byte[] removeElement(byte[] array, byte element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static char[] remove(char[] array, int index) {
        return (char[])ArrayKit.remove((Object)array, index);
    }

    public static char[] removeElement(char[] array, char element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static double[] remove(double[] array, int index) {
        return (double[])ArrayKit.remove((Object)array, index);
    }

    public static double[] removeElement(double[] array, double element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static float[] remove(float[] array, int index) {
        return (float[])ArrayKit.remove((Object)array, index);
    }

    public static float[] removeElement(float[] array, float element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static int[] remove(int[] array, int index) {
        return (int[])ArrayKit.remove((Object)array, index);
    }

    public static int[] removeElement(int[] array, int element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static long[] remove(long[] array, int index) {
        return (long[])ArrayKit.remove((Object)array, index);
    }

    public static long[] removeElement(long[] array, long element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    public static short[] remove(short[] array, int index) {
        return (short[])ArrayKit.remove((Object)array, index);
    }

    public static short[] removeElement(short[] array, short element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        return ArrayKit.remove(array, index);
    }

    private static Object remove(Object array, int index) {
        int length = ArrayKit.getLength(array);
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - 1);
        System.arraycopy(array, 0, result, 0, index);
        if (index < length - 1) {
            System.arraycopy(array, index + 1, result, index, length - index - 1);
        }
        return result;
    }

    public static <T> T[] removeAll(T[] array, int ... indices) {
        return (Object[])ArrayKit.removeAll(array, indices);
    }

    public static <T> T[] removeElements(T[] array, T ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<T, MutableInt> occurrences = new HashMap<T, MutableInt>(values.length);
        for (T v : values) {
            MutableInt count = (MutableInt)occurrences.get(v);
            if (count == null) {
                occurrences.put(v, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            T key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (Object[])ArrayKit.removeAll(array, toRemove);
    }

    public static byte[] removeAll(byte[] array, int ... indices) {
        return (byte[])ArrayKit.removeAll((Object)array, indices);
    }

    public static byte[] removeElements(byte[] array, byte ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Byte, MutableInt> occurrences = new HashMap<Byte, MutableInt>(values.length);
        for (byte v : values) {
            Byte boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            byte key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (byte[])ArrayKit.removeAll((Object)array, toRemove);
    }

    public static short[] removeAll(short[] array, int ... indices) {
        return (short[])ArrayKit.removeAll((Object)array, indices);
    }

    public static short[] removeElements(short[] array, short ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Short, MutableInt> occurrences = new HashMap<Short, MutableInt>(values.length);
        for (short v : values) {
            Short boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            short key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (short[])ArrayKit.removeAll((Object)array, toRemove);
    }

    public static int[] removeAll(int[] array, int ... indices) {
        return (int[])ArrayKit.removeAll((Object)array, indices);
    }

    public static int[] removeElements(int[] array, int ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Integer, MutableInt> occurrences = new HashMap<Integer, MutableInt>(values.length);
        for (int v : values) {
            Integer boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            int key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (int[])ArrayKit.removeAll((Object)array, toRemove);
    }

    public static char[] removeAll(char[] array, int ... indices) {
        return (char[])ArrayKit.removeAll((Object)array, indices);
    }

    public static char[] removeElements(char[] array, char ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Character, MutableInt> occurrences = new HashMap<Character, MutableInt>(values.length);
        for (char v : values) {
            Character boxed = Character.valueOf(v);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            char key = array[i];
            MutableInt count = (MutableInt)occurrences.get(Character.valueOf(key));
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(Character.valueOf(key));
            }
            toRemove.set(i);
        }
        return (char[])ArrayKit.removeAll((Object)array, toRemove);
    }

    public static long[] removeAll(long[] array, int ... indices) {
        return (long[])ArrayKit.removeAll((Object)array, indices);
    }

    public static long[] removeElements(long[] array, long ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Long, MutableInt> occurrences = new HashMap<Long, MutableInt>(values.length);
        for (long v : values) {
            Long boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            long key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (long[])ArrayKit.removeAll((Object)array, toRemove);
    }

    public static float[] removeAll(float[] array, int ... indices) {
        return (float[])ArrayKit.removeAll((Object)array, indices);
    }

    public static float[] removeElements(float[] array, float ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Float, MutableInt> occurrences = new HashMap<Float, MutableInt>(values.length);
        for (float v : values) {
            Float boxed = Float.valueOf(v);
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            float key = array[i];
            MutableInt count = (MutableInt)occurrences.get(Float.valueOf(key));
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(Float.valueOf(key));
            }
            toRemove.set(i);
        }
        return (float[])ArrayKit.removeAll((Object)array, toRemove);
    }

    public static double[] removeAll(double[] array, int ... indices) {
        return (double[])ArrayKit.removeAll((Object)array, indices);
    }

    public static double[] removeElements(double[] array, double ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Double, MutableInt> occurrences = new HashMap<Double, MutableInt>(values.length);
        for (double v : values) {
            Double boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            double key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (double[])ArrayKit.removeAll((Object)array, toRemove);
    }

    public static boolean[] removeAll(boolean[] array, int ... indices) {
        return (boolean[])ArrayKit.removeAll((Object)array, indices);
    }

    public static boolean[] removeElements(boolean[] array, boolean ... values) {
        if (ArrayKit.isEmpty(array) || ArrayKit.isEmpty(values)) {
            return ArrayKit.clone(array);
        }
        HashMap<Boolean, MutableInt> occurrences = new HashMap<Boolean, MutableInt>(2);
        for (boolean v : values) {
            Boolean boxed = v;
            MutableInt count = (MutableInt)occurrences.get(boxed);
            if (count == null) {
                occurrences.put(boxed, new MutableInt(1));
                continue;
            }
            count.increment();
        }
        BitSet toRemove = new BitSet();
        for (int i = 0; i < array.length; ++i) {
            boolean key = array[i];
            MutableInt count = (MutableInt)occurrences.get(key);
            if (count == null) continue;
            if (count.get() == 0) {
                occurrences.remove(key);
            }
            toRemove.set(i);
        }
        return (boolean[])ArrayKit.removeAll((Object)array, toRemove);
    }

    static Object removeAll(Object array, int ... indices) {
        int length = ArrayKit.getLength(array);
        int diff = 0;
        int[] clonedIndices = ArrayKit.clone(indices);
        Arrays.sort(clonedIndices);
        if (ArrayKit.isNotEmpty(clonedIndices)) {
            int i = clonedIndices.length;
            int prevIndex = length;
            while (--i >= 0) {
                int index = clonedIndices[i];
                if (index < 0 || index >= length) {
                    throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + length);
                }
                if (index >= prevIndex) continue;
                ++diff;
                prevIndex = index;
            }
        }
        Object result = Array.newInstance(array.getClass().getComponentType(), length - diff);
        if (diff < length) {
            int end = length;
            int dest = length - diff;
            for (int i = clonedIndices.length - 1; i >= 0; --i) {
                int index = clonedIndices[i];
                if (end - index > 1) {
                    int cp = end - index - 1;
                    System.arraycopy(array, index + 1, result, dest -= cp, cp);
                }
                end = index;
            }
            if (end > 0) {
                System.arraycopy(array, 0, result, 0, end);
            }
        }
        return result;
    }

    static Object removeAll(Object array, BitSet indices) {
        int count;
        int set;
        int srcLength = ArrayKit.getLength(array);
        int removals = indices.cardinality();
        Object result = Array.newInstance(array.getClass().getComponentType(), srcLength - removals);
        int srcIndex = 0;
        int destIndex = 0;
        while ((set = indices.nextSetBit(srcIndex)) != -1) {
            count = set - srcIndex;
            if (count > 0) {
                System.arraycopy(array, srcIndex, result, destIndex, count);
                destIndex += count;
            }
            srcIndex = indices.nextClearBit(set);
        }
        count = srcLength - srcIndex;
        if (count > 0) {
            System.arraycopy(array, srcIndex, result, destIndex, count);
        }
        return result;
    }

    public static <T extends Comparable<? super T>> boolean isSorted(T[] array) {
        return ArrayKit.isSorted(array, (o1, o2) -> o1.compareTo(o2));
    }

    public static <T> boolean isSorted(T[] array, Comparator<T> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator should not be null.");
        }
        if (array == null || array.length < 2) {
            return true;
        }
        T previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            T current = array[i];
            if (comparator.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(int[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        int previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            int current = array[i];
            if (MathKit.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(long[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        long previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            long current = array[i];
            if (MathKit.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(short[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        short previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            short current = array[i];
            if (MathKit.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(double[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        double previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            double current = array[i];
            if (Double.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(float[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        float previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            float current = array[i];
            if (Float.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(byte[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        byte previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            byte current = array[i];
            if (MathKit.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(char[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        char previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            char current = array[i];
            if (CharKit.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean isSorted(boolean[] array) {
        if (array == null || array.length < 2) {
            return true;
        }
        boolean previous = array[0];
        int n = array.length;
        for (int i = 1; i < n; ++i) {
            boolean current = array[i];
            if (BooleanKit.compare(previous, current) > 0) {
                return false;
            }
            previous = current;
        }
        return true;
    }

    public static boolean[] removeAllOccurences(boolean[] array, boolean element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static char[] removeAllOccurences(char[] array, char element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static byte[] removeAllOccurences(byte[] array, byte element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static short[] removeAllOccurences(short[] array, short element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static int[] removeAllOccurences(int[] array, int element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static long[] removeAllOccurences(long[] array, long element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static float[] removeAllOccurences(float[] array, float element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static double[] removeAllOccurences(double[] array, double element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static <T> T[] removeAllOccurences(T[] array, T element) {
        int index = ArrayKit.indexOf(array, element);
        if (index == -1) {
            return ArrayKit.clone(array);
        }
        int[] indices = new int[array.length - index];
        indices[0] = index;
        int count = 1;
        while ((index = ArrayKit.indexOf(array, element, indices[count - 1] + 1)) != -1) {
            indices[count++] = index;
        }
        return ArrayKit.removeAll(array, Arrays.copyOf(indices, count));
    }

    public static String[] toStringArray(Object[] array) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i].toString();
        }
        return result;
    }

    public static String[] toStringArray(Object[] array, String valueForNullElements) {
        if (null == array) {
            return null;
        }
        if (array.length == 0) {
            return Normal.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            Object object = array[i];
            result[i] = object == null ? valueForNullElements : object.toString();
        }
        return result;
    }

    public static <T> T[] insert(T[] buffer, int index, T ... newElements) {
        return (Object[])ArrayKit.insert(buffer, index, newElements);
    }

    public static <T> Object insert(Object array, int index, T ... newElements) {
        if (ArrayKit.isEmpty(newElements)) {
            return array;
        }
        if (ArrayKit.isEmpty(array)) {
            return newElements;
        }
        int len = ArrayKit.getLength(array);
        if (index < 0) {
            index = index % len + len;
        }
        T[] result = ArrayKit.newArray(array.getClass().getComponentType(), Math.max(len, index) + newElements.length);
        System.arraycopy(array, 0, result, 0, Math.min(len, index));
        System.arraycopy(newElements, 0, result, index, newElements.length);
        if (index < len) {
            System.arraycopy(array, index, result, index + newElements.length, len - index);
        }
        return result;
    }

    public static boolean[] insert(int index, boolean[] array, boolean ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        boolean[] result = new boolean[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static byte[] insert(int index, byte[] array, byte ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        byte[] result = new byte[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static char[] insert(int index, char[] array, char ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        char[] result = new char[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static double[] insert(int index, double[] array, double ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        double[] result = new double[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static float[] insert(int index, float[] array, float ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        float[] result = new float[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static int[] insert(int index, int[] array, int ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        int[] result = new int[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static long[] insert(int index, long[] array, long ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        long[] result = new long[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static short[] insert(int index, short[] array, short ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        short[] result = new short[array.length + values.length];
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static <T> T[] insert(int index, T[] array, T ... values) {
        if (array == null) {
            return null;
        }
        if (values == null || values.length == 0) {
            return ArrayKit.clone(array);
        }
        if (index < 0 || index > array.length) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Length: " + array.length);
        }
        Class<?> type = array.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(type, array.length + values.length);
        System.arraycopy(values, 0, result, index, values.length);
        if (index > 0) {
            System.arraycopy(array, 0, result, 0, index);
        }
        if (index < array.length) {
            System.arraycopy(array, index, result, index + values.length, array.length - index);
        }
        return result;
    }

    public static void shuffle(Object[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(Object[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(boolean[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(boolean[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(byte[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(byte[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(char[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(char[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(short[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(short[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(int[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(int[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(long[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(long[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(float[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(float[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static void shuffle(double[] array) {
        ArrayKit.shuffle(array, new Random());
    }

    public static void shuffle(double[] array, Random random) {
        for (int i = array.length; i > 1; --i) {
            ArrayKit.swap(array, i - 1, random.nextInt(i), 1);
        }
    }

    public static <T> T[] newArray(Class<?> componentType, int newSize) {
        return (Object[])Array.newInstance(componentType, newSize);
    }

    public static <T> T[] newArray(int newSize) {
        return new Object[newSize];
    }

    public static Object[] newArray(Class<?> type, Object arrayObj) {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayKit.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public static Class<?> getComponentType(Object array) {
        return null == array ? null : array.getClass().getComponentType();
    }

    public static Class<?> getComponentType(Class<?> arrayClass) {
        return null == arrayClass ? null : arrayClass.getComponentType();
    }

    public static Class<?> getArrayType(Class<?> componentType) {
        return Array.newInstance(componentType, 0).getClass();
    }

    public static <T> T[] append(T[] buffer, T ... newElements) {
        if (ArrayKit.isEmpty(buffer)) {
            return newElements;
        }
        return ArrayKit.insert(buffer, buffer.length, newElements);
    }

    public static <T> Object append(Object array, T ... newElements) {
        if (ArrayKit.isEmpty(array)) {
            return newElements;
        }
        return ArrayKit.insert(array, ArrayKit.getLength(array), newElements);
    }

    public static <T> T[] setOrAppend(T[] buffer, int index, T value) {
        if (index < buffer.length) {
            Array.set(buffer, index, value);
            return buffer;
        }
        return ArrayKit.append(buffer, value);
    }

    public static Object setOrAppend(Object array, int index, Object value) {
        if (index < ArrayKit.getLength(array)) {
            Array.set(array, index, value);
            return array;
        }
        return ArrayKit.append(array, value);
    }

    public static <T> T[] resize(T[] buffer, int newSize, Class<?> componentType) {
        T[] newArray = ArrayKit.newArray(componentType, newSize);
        if (ArrayKit.isNotEmpty(buffer)) {
            System.arraycopy(buffer, 0, newArray, 0, Math.min(buffer.length, newSize));
        }
        return newArray;
    }

    public static <T> T[] resize(T[] buffer, int newSize) {
        return ArrayKit.resize(buffer, newSize, buffer.getClass().getComponentType());
    }

    public static byte[] resize(byte[] bytes, int newSize) {
        if (newSize < 0) {
            return bytes;
        }
        byte[] newArray = new byte[newSize];
        if (newSize > 0 && ArrayKit.isNotEmpty(bytes)) {
            System.arraycopy(bytes, 0, newArray, 0, Math.min(bytes.length, newSize));
        }
        return newArray;
    }

    public static Object copy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
        return dest;
    }

    public static Object copy(Object src, Object dest, int length) {
        System.arraycopy(src, 0, dest, 0, length);
        return dest;
    }

    public static int[] range(int excludedEnd) {
        return ArrayKit.range(0, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd) {
        return ArrayKit.range(includedStart, excludedEnd, 1);
    }

    public static int[] range(int includedStart, int excludedEnd, int step) {
        if (includedStart > excludedEnd) {
            int tmp = includedStart;
            includedStart = excludedEnd;
            excludedEnd = tmp;
        }
        if (step <= 0) {
            step = 1;
        }
        int deviation = excludedEnd - includedStart;
        int length = deviation / step;
        if (deviation % step != 0) {
            ++length;
        }
        int[] range = new int[length];
        for (int i = 0; i < length; ++i) {
            range[i] = includedStart;
            includedStart += step;
        }
        return range;
    }

    public static int[] unWrap(Integer ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_INT_ARRAY;
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Long[] wrap(long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] array = new Long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static long[] unWrap(Long ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_LONG_ARRAY;
        }
        long[] array = new long[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Character[] wrap(char ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] array = new Character[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Character.valueOf(values[i]);
        }
        return array;
    }

    public static char[] unWrap(Character ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_CHAR_ARRAY;
        }
        char[] array = new char[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].charValue();
        }
        return array;
    }

    public static Byte[] wrap(byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] array = new Byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static byte[] unWrap(Byte ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        byte[] array = new byte[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Short[] wrap(short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] array = new Short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static short[] unWrap(Short ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_SHORT_ARRAY;
        }
        short[] array = new short[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Float[] wrap(float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] array = new Float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = Float.valueOf(values[i]);
        }
        return array;
    }

    public static float[] unWrap(Float ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_FLOAT_ARRAY;
        }
        float[] array = new float[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i].floatValue();
        }
        return array;
    }

    public static Double[] wrap(double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] array = new Double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static double[] unWrap(Double ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_DOUBLE_ARRAY;
        }
        double[] array = new double[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Boolean[] wrap(boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] array = new Boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static boolean[] unWrap(Boolean ... values) {
        if (null == values) {
            return null;
        }
        int length = values.length;
        if (0 == length) {
            return Normal.EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] array = new boolean[length];
        for (int i = 0; i < length; ++i) {
            array[i] = values[i];
        }
        return array;
    }

    public static Object[] wrap(Object obj) {
        if (null == obj) {
            return null;
        }
        if (ArrayKit.isArray(obj)) {
            try {
                return (Object[])obj;
            }
            catch (Exception e) {
                String className;
                switch (className = obj.getClass().getComponentType().getName()) {
                    case "long": {
                        return ArrayKit.wrap((long[])obj);
                    }
                    case "int": {
                        return ArrayKit.wrap(obj);
                    }
                    case "short": {
                        return ArrayKit.wrap((short[])obj);
                    }
                    case "char": {
                        return ArrayKit.wrap((char[])obj);
                    }
                    case "byte": {
                        return ArrayKit.wrap((byte[])obj);
                    }
                    case "boolean": {
                        return ArrayKit.wrap((boolean[])obj);
                    }
                    case "float": {
                        return ArrayKit.wrap((float[])obj);
                    }
                    case "double": {
                        return ArrayKit.wrap((double[])obj);
                    }
                }
                throw new InstrumentException(e);
            }
        }
        throw new InstrumentException("is not Array!");
    }

    public static <T> T get(Object array, int index) {
        if (index < 0) {
            index += Array.getLength(array);
        }
        return (T)Array.get(array, index);
    }

    public static <T> T[] get(Object array, int ... indexes) {
        T[] result = ArrayKit.newArray(indexes.length);
        for (int i : indexes) {
            result[i] = ArrayKit.get(array, i);
        }
        return result;
    }

    public static <T> T[] sub(T[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return ArrayKit.newArray(array.getClass().getComponentType(), 0);
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return ArrayKit.newArray(array.getClass().getComponentType(), 0);
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static byte[] sub(byte[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new byte[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new byte[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static int[] sub(int[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new int[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new int[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static long[] sub(long[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new long[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new long[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static short[] sub(short[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new short[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new short[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static char[] sub(char[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new char[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new char[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static double[] sub(double[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new double[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new double[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static float[] sub(float[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new float[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new float[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static boolean[] sub(boolean[] array, int start, int end) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return new boolean[0];
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return new boolean[0];
            }
            end = length;
        }
        return Arrays.copyOfRange(array, start, end);
    }

    public static Object[] sub(Object array, int start, int end) {
        return ArrayKit.sub(array, start, end, 1);
    }

    public static Object[] sub(Object array, int start, int end, int step) {
        int length = ArrayKit.getLength(array);
        if (start < 0) {
            start += length;
        }
        if (end < 0) {
            end += length;
        }
        if (start == length) {
            return Normal.EMPTY_OBJECT_ARRAY;
        }
        if (start > end) {
            int tmp = start;
            start = end;
            end = tmp;
        }
        if (end > length) {
            if (start >= length) {
                return Normal.EMPTY_OBJECT_ARRAY;
            }
            end = length;
        }
        if (step <= 1) {
            step = 1;
        }
        ArrayList list = new ArrayList();
        for (int i = start; i < end; i += step) {
            list.add(ArrayKit.get(array, i));
        }
        return list.toArray();
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return ArrayKit.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence conjunction, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            if (ArrayKit.isArray(item)) {
                sb.append(ArrayKit.join(ArrayKit.wrap(item), conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterable) {
                sb.append(CollKit.join((Iterable)item, conjunction, prefix, suffix));
                continue;
            }
            if (item instanceof Iterator) {
                sb.append(IterKit.join((Iterator)item, conjunction, prefix, suffix));
                continue;
            }
            sb.append(StringKit.wrap(StringKit.toString(item), prefix, suffix));
        }
        return sb.toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction, Editor<T> editor) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (T item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            if (null != editor) {
                item = editor.edit(item);
            }
            if (null == item) continue;
            sb.append(StringKit.toString(item));
        }
        return sb.toString();
    }

    public static String join(long[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (long item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(int[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (int item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(short[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (short item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(char[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (char item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(byte[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (byte item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(boolean[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (boolean item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(float[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (float item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(double[] array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (double item : array) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (ArrayKit.isArray(array)) {
            Class<?> componentType = array.getClass().getComponentType();
            if (componentType.isPrimitive()) {
                String componentTypeName;
                switch (componentTypeName = componentType.getName()) {
                    case "long": {
                        return ArrayKit.join((long[])array, conjunction);
                    }
                    case "int": {
                        return ArrayKit.join((int[])array, conjunction);
                    }
                    case "short": {
                        return ArrayKit.join((short[])array, conjunction);
                    }
                    case "char": {
                        return ArrayKit.join((char[])array, conjunction);
                    }
                    case "byte": {
                        return ArrayKit.join((byte[])array, conjunction);
                    }
                    case "boolean": {
                        return ArrayKit.join((boolean[])array, conjunction);
                    }
                    case "float": {
                        return ArrayKit.join((float[])array, conjunction);
                    }
                    case "double": {
                        return ArrayKit.join((double[])array, conjunction);
                    }
                }
                throw new InstrumentException("Unknown primitive type: [{}]", componentTypeName);
            }
            return ArrayKit.join((Object[])array, conjunction);
        }
        throw new InstrumentException(StringKit.format("[{}] is not a Array!", array.getClass()));
    }

    public static <T extends Comparable<? super T>> T min(T[] numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (ObjectKit.compare(min, numberArray[i]) <= 0) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static long min(long ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static int min(int ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static short min(short ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static char min(char ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static byte min(byte ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (min <= numberArray[i]) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static double min(double ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static float min(float ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float min = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(min > numberArray[i])) continue;
            min = numberArray[i];
        }
        return min;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (ObjectKit.compare(max, numberArray[i]) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static long max(long ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        long max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static int max(int ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        int max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static short max(short ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        short max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static char max(char ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        char max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static byte max(byte ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        byte max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (max >= numberArray[i]) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static double max(double ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        double max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static float max(float ... numberArray) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        float max = numberArray[0];
        for (int i = 0; i < numberArray.length; ++i) {
            if (!(max < numberArray[i])) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <T extends Comparable<? super T>> T max(T[] numberArray, Comparator<T> comparator) {
        if (ArrayKit.isEmpty(numberArray)) {
            throw new IllegalArgumentException("Number array must not empty !");
        }
        T max = numberArray[0];
        for (int i = 1; i < numberArray.length; ++i) {
            if (ObjectKit.compare(max, numberArray[i], comparator) >= 0) continue;
            max = numberArray[i];
        }
        return max;
    }

    public static <T> T[] filter(T[] array, Editor<T> editor) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            T modified = editor.edit(t);
            if (null == modified) continue;
            list.add(modified);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <T> T[] filter(T[] array, Filter<T> filter) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        for (T t : array) {
            boolean isAccept = filter.accept(t);
            if (!isAccept) continue;
            list.add(t);
        }
        return list.toArray(Arrays.copyOf(array, list.size()));
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values) {
        return ArrayKit.zip(keys, values, false);
    }

    public static <K, V> Map<K, V> zip(K[] keys, V[] values, boolean isOrder) {
        if (ArrayKit.isEmpty(keys) || ArrayKit.isEmpty(values)) {
            return null;
        }
        int size = Math.min(keys.length, values.length);
        HashMap<K, V> map = CollKit.newHashMap(size, isOrder);
        for (int i = 0; i < size; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    public static boolean isSameType(Object array1, Object array2) {
        if (array1 == null || array2 == null) {
            throw new IllegalArgumentException("The Array must not be null");
        }
        return array1.getClass().getName().equals(array2.getClass().getName());
    }

    public static int indexOfIgnoreCase(CharSequence[] array, CharSequence value) {
        if (null != array) {
            for (int i = 0; i < array.length; ++i) {
                if (!StringKit.equalsIgnoreCase(array[i], value)) continue;
                return i;
            }
        }
        return -1;
    }

    public static <T> boolean isArrayIndexValid(T[] array, int index) {
        if (ArrayKit.getLength(array) == 0 || array.length <= index) {
            return false;
        }
        return index >= 0;
    }

    public static boolean containsIgnoreCase(CharSequence[] array, CharSequence value) {
        return ArrayKit.indexOfIgnoreCase(array, value) > -1;
    }

    public static int getLength(Object array) {
        if (array == null) {
            return 0;
        }
        return Array.getLength(array);
    }

    public static int hashCode(Object array) {
        return new HashCodeBuilder().append(array).toHashCode();
    }

    public static Object[] cast(Class<?> type, Object arrayObj) throws NullPointerException, IllegalArgumentException {
        if (null == arrayObj) {
            throw new NullPointerException("Argument [arrayObj] is null !");
        }
        if (!arrayObj.getClass().isArray()) {
            throw new IllegalArgumentException("Argument [arrayObj] is not array !");
        }
        if (null == type) {
            return (Object[])arrayObj;
        }
        Class<?> componentType = type.isArray() ? type.getComponentType() : type;
        Object[] array = (Object[])arrayObj;
        Object[] result = ArrayKit.newArray(componentType, array.length);
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }
}

