/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDesc;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.map.CaseInsensitiveMap;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.BooleanKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class BeanDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Class<?> beanClass;
    private final Map<String, PropertyDesc> propMap = new LinkedHashMap<String, PropertyDesc>();

    public BeanDesc(Class<?> beanClass) {
        Assert.notNull(beanClass);
        this.beanClass = beanClass;
        this.init();
    }

    public String getName() {
        return this.beanClass.getName();
    }

    public String getSimpleName() {
        return this.beanClass.getSimpleName();
    }

    public Map<String, PropertyDesc> getPropMap(boolean ignoreCase) {
        return ignoreCase ? new CaseInsensitiveMap<String, PropertyDesc>(1.0f, this.propMap) : this.propMap;
    }

    public Collection<PropertyDesc> getProps() {
        return this.propMap.values();
    }

    public PropertyDesc getProp(String fieldName) {
        return this.propMap.get(fieldName);
    }

    public Field getField(String fieldName) {
        PropertyDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getField();
    }

    public Method getGetter(String fieldName) {
        PropertyDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getGetter();
    }

    public Method getSetter(String fieldName) {
        PropertyDesc desc = this.propMap.get(fieldName);
        return null == desc ? null : desc.getSetter();
    }

    private BeanDesc init() {
        Method[] methods = ReflectKit.getMethods(this.beanClass);
        for (Field field : ReflectKit.getFields(this.beanClass)) {
            if (BeanKit.isStatic(field)) continue;
            PropertyDesc prop = this.createProp(field, methods);
            this.propMap.putIfAbsent(prop.getFieldName(), prop);
        }
        return this;
    }

    private PropertyDesc createProp(Field field, Method[] methods) {
        PropertyDesc prop = this.findProp(field, methods, false);
        if (null == prop.getter || null == prop.setter) {
            PropertyDesc propIgnoreCase = this.findProp(field, methods, true);
            if (null == prop.getter) {
                prop.getter = propIgnoreCase.getter;
            }
            if (null == prop.setter) {
                prop.setter = propIgnoreCase.setter;
            }
        }
        return prop;
    }

    private PropertyDesc findProp(Field field, Method[] methods, boolean ignoreCase) {
        String fieldName = field.getName();
        Class<?> fieldType = field.getType();
        boolean isBooleanField = BooleanKit.isBoolean(fieldType);
        Method getter = null;
        Method setter = null;
        for (Method method : methods) {
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (parameterTypes.length > 1) continue;
            String methodName = method.getName();
            if (parameterTypes.length == 0) {
                if (this.isMatchGetter(methodName, fieldName, isBooleanField, ignoreCase)) {
                    getter = method;
                }
            } else if (this.isMatchSetter(methodName, fieldName, isBooleanField, ignoreCase)) {
                setter = method;
            }
            if (null != getter && null != setter) break;
        }
        return new PropertyDesc(field, getter, setter);
    }

    private boolean isMatchGetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        String handledFieldName;
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = handledFieldName = fieldName.toLowerCase();
        } else {
            handledFieldName = StringKit.upperFirst(fieldName);
        }
        if (!methodName.startsWith("get") && !methodName.startsWith("is")) {
            return false;
        }
        if ("getclass".equals(methodName)) {
            return false;
        }
        if (isBooleanField && (fieldName.startsWith("is") ? methodName.equals(fieldName) || methodName.equals("get" + handledFieldName) || methodName.equals("is" + handledFieldName) : methodName.equals("is" + handledFieldName))) {
            return true;
        }
        return methodName.equals("get" + handledFieldName);
    }

    private boolean isMatchSetter(String methodName, String fieldName, boolean isBooleanField, boolean ignoreCase) {
        String handledFieldName;
        if (ignoreCase) {
            methodName = methodName.toLowerCase();
            fieldName = handledFieldName = fieldName.toLowerCase();
        } else {
            handledFieldName = StringKit.upperFirst(fieldName);
        }
        if (!methodName.startsWith("set")) {
            return false;
        }
        if (isBooleanField && fieldName.startsWith("is") && (methodName.equals("set" + StringKit.removePrefix(fieldName, "is")) || methodName.equals("set" + handledFieldName))) {
            return true;
        }
        return methodName.equals("set" + fieldName);
    }
}

