/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.convert;

import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class NumberChinese {
    private static final char[] CHINESE_DIGITS_VALUE = new char[]{'\u96f6', '\u4e00', '\u58f9', '\u4e8c', '\u8d30', '\u4e09', '\u53c1', '\u56db', '\u8086', '\u4e94', '\u4f0d', '\u516d', '\u9646', '\u4e03', '\u67d2', '\u516b', '\u634c', '\u4e5d', '\u7396'};
    private static final NameValue[] CHINESE_NAME_VALUE = new NameValue[]{new NameValue(' ', 1, false), new NameValue('\u5341', 10, false), new NameValue('\u62fe', 10, false), new NameValue('\u767e', 100, false), new NameValue('\u4f70', 100, false), new NameValue('\u5343', 1000, false), new NameValue('\u4edf', 1000, false), new NameValue('\u4e07', 10000, true), new NameValue('\u4ebf', 100000000, true)};

    public static String format(double amount, boolean isUseTraditional) {
        return NumberChinese.format(amount, isUseTraditional, false);
    }

    public static String format(double amount, boolean isUseTraditional, boolean isMoneyMode) {
        if (amount > 9.999999999999998E13 || amount < -9.999999999999998E13) {
            throw new IllegalArgumentException("Number support only: (-99999999999999.99 \uff5e 99999999999999.99)\uff01");
        }
        boolean negative = false;
        if (amount < 0.0) {
            negative = true;
            amount = -amount;
        }
        long temp = Math.round(amount * 100.0);
        int numFen = (int)(temp % 10L);
        int numJiao = (int)((temp /= 10L) % 10L);
        StringBuilder chineseStr = new StringBuilder(NumberChinese.toChinese(temp /= 10L, isUseTraditional));
        if (negative) {
            chineseStr.insert(0, "\u8d1f");
        }
        if (numFen != 0 || numJiao != 0) {
            if (numFen == 0) {
                chineseStr.append(isMoneyMode ? "\u5143" : "\u70b9").append(NumberChinese.numberToChinese(numJiao, isUseTraditional)).append(isMoneyMode ? "\u89d2" : "");
            } else if (numJiao == 0) {
                chineseStr.append(isMoneyMode ? "\u5143\u96f6" : "\u70b9\u96f6").append(NumberChinese.numberToChinese(numFen, isUseTraditional)).append(isMoneyMode ? "\u5206" : "");
            } else {
                chineseStr.append(isMoneyMode ? "\u5143" : "\u70b9").append(NumberChinese.numberToChinese(numJiao, isUseTraditional)).append(isMoneyMode ? "\u89d2" : "").append(NumberChinese.numberToChinese(numFen, isUseTraditional)).append(isMoneyMode ? "\u5206" : "");
            }
        } else if (isMoneyMode) {
            chineseStr.append("\u5143\u6574");
        }
        return chineseStr.toString();
    }

    public static String toChinese(char c, boolean isUseTraditional) {
        if (c < '0' || c > '9') {
            return String.valueOf(c);
        }
        return String.valueOf(NumberChinese.numberToChinese(c - 48, isUseTraditional));
    }

    private static String toChinese(long amount, boolean isUseTraditional) {
        String partChinese;
        if (0L == amount) {
            return "\u96f6";
        }
        int[] parts = new int[4];
        int i = 0;
        while (amount != 0L) {
            parts[i] = (int)(amount % 10000L);
            amount /= 10000L;
            ++i;
        }
        StringBuilder chineseStr = new StringBuilder();
        int partValue = parts[0];
        if (partValue > 0) {
            partChinese = NumberChinese.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese);
            if (partValue < 1000) {
                NumberChinese.addPreZero(chineseStr);
            }
        }
        if ((partValue = parts[1]) > 0) {
            if (partValue % 10 == 0 && parts[0] > 0) {
                NumberChinese.addPreZero(chineseStr);
            }
            partChinese = NumberChinese.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
            if (partValue < 1000) {
                NumberChinese.addPreZero(chineseStr);
            }
        } else {
            NumberChinese.addPreZero(chineseStr);
        }
        if ((partValue = parts[2]) > 0) {
            if (partValue % 10 == 0 && parts[1] > 0) {
                NumberChinese.addPreZero(chineseStr);
            }
            partChinese = NumberChinese.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4ebf");
            if (partValue < 1000) {
                NumberChinese.addPreZero(chineseStr);
            }
        } else {
            NumberChinese.addPreZero(chineseStr);
        }
        if ((partValue = parts[3]) > 0) {
            if (parts[2] == 0) {
                chineseStr.insert(0, "\u4ebf");
            }
            partChinese = NumberChinese.toChinese(partValue, isUseTraditional);
            chineseStr.insert(0, partChinese + "\u4e07");
        }
        if (StringKit.isNotEmpty(chineseStr) && '\u96f6' == chineseStr.charAt(0)) {
            return chineseStr.substring(1);
        }
        return chineseStr.toString();
    }

    private static String toChinese(int amountPart, boolean isUseTraditional) {
        int temp = amountPart;
        StringBuilder chineseStr = new StringBuilder();
        boolean lastIsZero = true;
        int i = 0;
        while (temp > 0) {
            int digit = temp % 10;
            if (digit == 0) {
                if (!lastIsZero) {
                    chineseStr.insert(0, "\u96f6");
                }
                lastIsZero = true;
            } else {
                chineseStr.insert(0, NumberChinese.numberToChinese(digit, isUseTraditional) + NumberChinese.getUnitName(i, isUseTraditional));
                lastIsZero = false;
            }
            temp /= 10;
            ++i;
        }
        return chineseStr.toString();
    }

    public static int chineseToNumber(String chinese) {
        int length = chinese.length();
        int result = 0;
        int section = 0;
        int number = 0;
        NameValue unit = null;
        for (int i = 0; i < length; ++i) {
            char c = chinese.charAt(i);
            int num = NumberChinese.chineseToNumber(c);
            if (num >= 0) {
                if (num == 0) {
                    if (number > 0 && null != unit) {
                        section += number * (unit.value / 10);
                    }
                    unit = null;
                } else if (number > 0) {
                    throw new IllegalArgumentException(StringKit.format("Bad number '{}{}' at: {}", Character.valueOf(chinese.charAt(i - 1)), Character.valueOf(c), i));
                }
                number = num;
                continue;
            }
            unit = NumberChinese.chineseToUnit(c);
            if (null == unit) {
                throw new IllegalArgumentException(StringKit.format("Unknown unit '{}' at: {}", Character.valueOf(c), i));
            }
            if (unit.unit) {
                section = (section + number) * unit.value;
                result += section;
                section = 0;
            } else {
                int unitNumber = number;
                if (0 == number && 0 == i) {
                    unitNumber = 1;
                }
                section += unitNumber * unit.value;
            }
            number = 0;
        }
        if (number > 0 && null != unit) {
            number *= unit.value / 10;
        }
        return result + section + number;
    }

    private static NameValue chineseToUnit(char chinese) {
        for (NameValue chineseNameValue : CHINESE_NAME_VALUE) {
            if (chineseNameValue.name != chinese) continue;
            return chineseNameValue;
        }
        return null;
    }

    private static int chineseToNumber(char chinese) {
        int i;
        if ('\u4e24' == chinese) {
            chinese = (char)20108;
        }
        if ((i = ArrayKit.indexOf(CHINESE_DIGITS_VALUE, chinese)) > 0) {
            return (i + 1) / 2;
        }
        return i;
    }

    private static char numberToChinese(int number, boolean isUseTraditional) {
        if (0 == number) {
            return CHINESE_DIGITS_VALUE[0];
        }
        return CHINESE_DIGITS_VALUE[number * 2 - (isUseTraditional ? 0 : 1)];
    }

    private static String getUnitName(int index, boolean isUseTraditional) {
        if (0 == index) {
            return "";
        }
        return String.valueOf(CHINESE_NAME_VALUE[index * 2 - (isUseTraditional ? 0 : 1)].name);
    }

    private static void addPreZero(StringBuilder chineseStr) {
        if (StringKit.isEmpty(chineseStr)) {
            return;
        }
        char c = chineseStr.charAt(0);
        if ('\u96f6' != c) {
            chineseStr.insert(0, '\u96f6');
        }
    }

    private static class NameValue {
        private final char name;
        private final int value;
        private final boolean unit;

        public NameValue(char name, int value, boolean unit) {
            this.name = name;
            this.value = value;
            this.unit = unit;
        }
    }
}

