/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.util.Calendar;
import java.util.Date;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.DateKit;

public class Between {
    private final Date begin;
    private final Date end;

    public Between(Date begin, Date end) {
        this(begin, end, true);
    }

    public Between(Date begin, Date end, boolean isAbs) {
        Assert.notNull(begin, "Begin date is null !", new Object[0]);
        Assert.notNull(end, "End date is null !", new Object[0]);
        if (isAbs && begin.after(end)) {
            this.begin = end;
            this.end = begin;
        } else {
            this.begin = begin;
            this.end = end;
        }
    }

    public static Between create(Date begin, Date end) {
        return new Between(begin, end);
    }

    public static Between create(Date begin, Date end, boolean isAbs) {
        return new Between(begin, end, isAbs);
    }

    public long between(Fields.Units units) {
        long diff = this.end.getTime() - this.begin.getTime();
        return diff / units.getUnit();
    }

    public long betweenMonth(boolean isReset) {
        Calendar beginCal = DateKit.toCalendar(this.begin);
        Calendar endCal = DateKit.toCalendar(this.end);
        int betweenYear = endCal.get(1) - beginCal.get(1);
        int betweenMonthOfYear = endCal.get(2) - beginCal.get(2);
        int result = betweenYear * 12 + betweenMonthOfYear;
        if (!isReset) {
            endCal.set(1, beginCal.get(1));
            endCal.set(2, beginCal.get(2));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public long betweenYear(boolean isReset) {
        Calendar beginCal = DateKit.toCalendar(this.begin);
        Calendar endCal = DateKit.toCalendar(this.end);
        int result = endCal.get(1) - beginCal.get(1);
        if (!isReset) {
            if (1 == beginCal.get(2) && 1 == endCal.get(2) && beginCal.get(5) == beginCal.getActualMaximum(5) && endCal.get(5) == endCal.getActualMaximum(5)) {
                beginCal.set(5, 1);
                endCal.set(5, 1);
            }
            endCal.set(1, beginCal.get(1));
            long between = endCal.getTimeInMillis() - beginCal.getTimeInMillis();
            if (between < 0L) {
                return result - 1;
            }
        }
        return result;
    }

    public String toString(Fields.Units unit) {
        return DateKit.formatBetween(this.between(Fields.Units.MILLISECOND), unit);
    }

    public String toString() {
        return this.toString(Fields.Units.MILLISECOND);
    }
}

