/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.time.LocalDateTime;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.date.Almanac;
import org.aoju.bus.core.date.Formatter;
import org.aoju.bus.core.date.calendar.DayWrapper;
import org.aoju.bus.core.date.calendar.MonthWrapper;
import org.aoju.bus.core.date.calendar.NonWrapper;
import org.aoju.bus.core.date.calendar.YearWrapper;
import org.aoju.bus.core.toolkit.CollKit;

public class Kalendar {
    public static NonWrapper calendar(int year, int month) {
        return Kalendar.calendar(year, month, true, true, null);
    }

    public static NonWrapper calendar(int year, int month, Map<String, Integer> dateTypeMap) {
        return Kalendar.calendar(year, month, false, true, dateTypeMap);
    }

    private static NonWrapper calendar(int year, int month, boolean includeLunarDate, boolean includeHoliday, Map<String, Integer> dateTypeMap) {
        YearMonth yearMonth = YearMonth.of(year, month);
        NonWrapper nonWrapper = new NonWrapper();
        ConcurrentHashMap<String, DayWrapper> dayMap = new ConcurrentHashMap<String, DayWrapper>(64);
        ArrayList<DayWrapper> dayList = new ArrayList<DayWrapper>();
        List<LocalDateTime> localDateTimeList = Almanac.getLocalDateTimeList(YearMonth.of(year, month));
        if (CollKit.isEmpty(localDateTimeList)) {
            return nonWrapper;
        }
        ArrayList<DayWrapper> dayWrapperList = new ArrayList<DayWrapper>();
        localDateTimeList.stream().forEach(localDateTime -> {
            DayWrapper dayWrapper = new DayWrapper((LocalDateTime)localDateTime, includeLunarDate, includeHoliday);
            dayWrapperList.add(dayWrapper);
            dayMap.put(Formatter.format(localDateTime), dayWrapper);
            dayList.add(dayWrapper);
        });
        if (CollKit.isNotEmpty(dateTypeMap) && CollKit.isNotEmpty(dayMap)) {
            dateTypeMap.forEach((k, v) -> {
                if (dayMap.containsKey(k)) {
                    ((DayWrapper)dayMap.get(k)).setDateType((int)v);
                }
            });
        }
        return new NonWrapper(CollKit.newArrayList(new YearWrapper(year, CollKit.newArrayList(new MonthWrapper(month, dayWrapperList, yearMonth.lengthOfMonth())))), dayMap, dayList);
    }

    public static NonWrapper calendar(int year, Map<String, Integer> dateTypeMap) {
        return Kalendar.calendar(year, false, true, dateTypeMap);
    }

    public static NonWrapper calendar(int year) {
        return Kalendar.calendar(year, true, true, null);
    }

    private static NonWrapper calendar(int year, boolean includeLunar, boolean includeHoliday, Map<String, Integer> dateTypeMap) {
        ConcurrentHashMap<String, DayWrapper> dayMap = new ConcurrentHashMap<String, DayWrapper>(512);
        ArrayList<DayWrapper> dayList = new ArrayList<DayWrapper>();
        ArrayList<MonthWrapper> monthWrapperList = new ArrayList<MonthWrapper>();
        for (int i = 1; i <= 12; ++i) {
            YearMonth yearMonth = YearMonth.of(year, i);
            List<LocalDateTime> localDateTimeList = Almanac.getLocalDateTimeList(YearMonth.of(year, i));
            if (CollKit.isEmpty(localDateTimeList)) continue;
            ArrayList<DayWrapper> dayWrapperList = new ArrayList<DayWrapper>();
            localDateTimeList.stream().forEach(localDateTime -> {
                DayWrapper dayWrapper = new DayWrapper((LocalDateTime)localDateTime, includeLunar, includeHoliday);
                dayWrapperList.add(dayWrapper);
                dayMap.put(Formatter.format(localDateTime), dayWrapper);
                dayList.add(dayWrapper);
            });
            MonthWrapper monthWrapper = new MonthWrapper(i, dayWrapperList, yearMonth.lengthOfMonth());
            monthWrapperList.add(monthWrapper);
        }
        if (CollKit.isNotEmpty(dateTypeMap) && CollKit.isNotEmpty(dayMap)) {
            dateTypeMap.forEach((k, v) -> {
                if (dayMap.containsKey(k)) {
                    ((DayWrapper)dayMap.get(k)).setDateType((int)v);
                }
            });
        }
        return new NonWrapper(CollKit.newArrayList(new YearWrapper(year, monthWrapperList)), dayMap, dayList);
    }

    public static Calendar calendar(int year, int month, int day, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(year, month - 1, day, hour, minute, second);
        c.set(14, 0);
        return c;
    }

    public static Calendar calendar(int year, int month, int day) {
        return Kalendar.calendar(year, month, day, 0, 0, 0);
    }

    public static Calendar calendar(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(14, 0);
        return c;
    }
}

