/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.painter;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.image.element.RectangleElement;
import org.aoju.bus.core.image.painter.Painter;

public class RectanglePainter
implements Painter {
    @Override
    public void draw(Graphics2D g, AbstractElement element, int canvasWidth) {
        RectangleElement rectangleElement = (RectangleElement)element;
        g.setColor(rectangleElement.getColor());
        if (rectangleElement.isCenter()) {
            int centerX = (canvasWidth - rectangleElement.getWidth()) / 2;
            rectangleElement.setX(centerX);
        }
        g.setComposite(AlphaComposite.getInstance(3, rectangleElement.getAlpha()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(rectangleElement.getX(), rectangleElement.getY(), rectangleElement.getWidth(), rectangleElement.getHeight(), rectangleElement.getRoundCorner(), rectangleElement.getRoundCorner());
    }
}

