/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Console {
    private final List<List<String>> headers = new ArrayList<List<String>>();
    private final List<List<String>> bodys = new ArrayList<List<String>>();
    private List<Integer> maxChar;

    public static void log() {
        System.out.println();
    }

    public static void log(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.log(e, e.getMessage(), new Object[0]);
        } else {
            Console.log("{}", obj);
        }
    }

    public static void log(Object object, Object ... args) {
        if (ArrayKit.isEmpty(args)) {
            Console.log(object);
        } else {
            Console.log(Console.build(args.length + 1), ArrayKit.insert(args, 0, object));
        }
    }

    public static void log(String template, Object ... values) {
        if (ArrayKit.isEmpty(values) || StringKit.contains((CharSequence)template, "{}")) {
            Console.logInternal(template, values);
        } else {
            Console.logInternal(Console.build(values.length + 1), ArrayKit.insert(values, 0, new Object[]{template}));
        }
    }

    public static void log(Throwable t, String template, Object ... values) {
        System.out.println(StringKit.format(template, values));
        if (null != t) {
            t.printStackTrace();
            System.out.flush();
        }
    }

    public static void print(Object obj) {
        Console.print("{}", obj);
    }

    public static void print(Object object, Object ... args) {
        if (ArrayKit.isEmpty(args)) {
            Console.print(object);
        } else {
            Console.print(Console.build(args.length + 1), ArrayKit.insert(args, 0, object));
        }
    }

    public static void print(String template, Object ... values) {
        if (ArrayKit.isEmpty(values) || StringKit.contains((CharSequence)template, "{}")) {
            Console.printInternal(template, values);
        } else {
            Console.printInternal(Console.build(values.length + 1), ArrayKit.insert(values, 0, new Object[]{template}));
        }
    }

    public static void printProgress(char showChar, int len) {
        Console.print("{}{}", "\r", StringKit.repeat(showChar, len));
    }

    public static void printProgress(char showChar, int totalLen, double rate) {
        Assert.isTrue(rate >= 0.0 && rate <= 1.0, "Rate must between 0 and 1 (both include)", new Object[0]);
        Console.printProgress(showChar, (int)((double)totalLen * rate));
    }

    public static void error() {
        System.err.println();
    }

    public static void error(Object obj) {
        if (obj instanceof Throwable) {
            Throwable e = (Throwable)obj;
            Console.error(e, e.getMessage(), new Object[0]);
        } else {
            Console.error("{}", obj);
        }
    }

    public static void error(Object object, Object ... args) {
        if (ArrayKit.isEmpty(args)) {
            Console.error(args);
        } else {
            Console.error(Console.build(args.length + 1), ArrayKit.insert(args, 0, object));
        }
    }

    public static void error(String template, Object ... values) {
        if (ArrayKit.isEmpty(values) || StringKit.contains((CharSequence)template, "{}")) {
            Console.errorInternal(template, values);
        } else {
            Console.errorInternal(Console.build(values.length + 1), ArrayKit.insert(values, 0, new Object[]{template}));
        }
    }

    public static void error(Throwable t, String template, Object ... values) {
        System.err.println(StringKit.format(template, values));
        if (null != t) {
            t.printStackTrace(System.err);
            System.err.flush();
        }
    }

    public static Scanner scanner() {
        return new Scanner(System.in);
    }

    public static String input() {
        return Console.scanner().nextLine();
    }

    public static String where() {
        StackTraceElement stackTraceElement = new Throwable().getStackTrace()[1];
        String className = stackTraceElement.getClassName();
        String methodName = stackTraceElement.getMethodName();
        String fileName = stackTraceElement.getFileName();
        Integer lineNumber = stackTraceElement.getLineNumber();
        return String.format("%s.%s(%s:%s)", className, methodName, fileName, lineNumber);
    }

    public static Integer lineNumber() {
        return new Throwable().getStackTrace()[1].getLineNumber();
    }

    private static String build(int count) {
        return StringKit.repeatAndJoin("{}", count, " ");
    }

    private static void logInternal(String template, Object ... values) {
        Console.log(null, template, values);
    }

    private static void printInternal(String template, Object ... values) {
        System.out.print(StringKit.format(template, values));
    }

    private static void errorInternal(String template, Object ... values) {
        Console.error(null, template, values);
    }

    public Console addHeader(String ... columns) {
        this.maxChar = new ArrayList<Integer>(Collections.nCopies(columns.length, 0));
        ArrayList<String> l = new ArrayList<String>();
        this.headers.add(l);
        for (int i = 0; i < columns.length; ++i) {
            String column = columns[i];
            String col = Convert.toSBC(column);
            l.add(col);
            int width = col.length();
            this.maxChar.set(i, width);
        }
        return this;
    }

    public Console addBody(String ... values) {
        ArrayList<String> l = new ArrayList<String>();
        this.bodys.add(l);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            String val = Convert.toSBC(value);
            l.add(val);
            int width = val.length();
            if (width <= this.maxChar.get(i)) continue;
            this.maxChar.set(i, width);
        }
        return this;
    }

    public String toString() {
        int j;
        int lw;
        int l;
        int i;
        StringBuilder sb = new StringBuilder();
        this.border(sb);
        for (List<String> headers : this.headers) {
            for (i = 0; i < headers.size(); ++i) {
                if (i == 0) {
                    sb.append('|');
                }
                String header = headers.get(i);
                sb.append(Convert.toSBC(" "));
                sb.append(header);
                sb.append(Convert.toSBC(" "));
                l = header.length();
                lw = this.maxChar.get(i);
                if (lw > l) {
                    for (j = 0; j < lw - l; ++j) {
                        sb.append(Convert.toSBC(" "));
                    }
                }
                sb.append('|');
            }
            sb.append('\n');
        }
        this.border(sb);
        for (List<String> bodys : this.bodys) {
            for (i = 0; i < bodys.size(); ++i) {
                if (i == 0) {
                    sb.append('|');
                }
                String body = bodys.get(i);
                sb.append(Convert.toSBC(" "));
                sb.append(body);
                sb.append(Convert.toSBC(" "));
                l = body.length();
                lw = this.maxChar.get(i);
                if (lw > l) {
                    for (j = 0; j < lw - l; ++j) {
                        sb.append(Convert.toSBC(" "));
                    }
                }
                sb.append('|');
            }
            sb.append('\n');
        }
        this.border(sb);
        return sb.toString();
    }

    private void border(StringBuilder sb) {
        sb.append("*");
        for (Integer width : this.maxChar) {
            sb.append(Convert.toSBC(StringKit.fillAfter("", '-', width + 2)));
            sb.append("*");
        }
        sb.append('\n');
    }

    public static class Table {
        private static final char ROW_LINE = '-';
        private static final char COLUMN_LINE = '|';
        private static final char CORNER = '+';
        private static final char SPACE = '\u3000';
        private static final char LF = '\n';
        private final List<List<String>> HEADER_LIST = new ArrayList<List<String>>();
        private final List<List<String>> BODY_LIST = new ArrayList<List<String>>();
        private List<Integer> columnCharNumber;

        public static Table create() {
            return new Table();
        }

        public Table addHeader(String ... titles) {
            if (null == this.columnCharNumber) {
                this.columnCharNumber = new ArrayList<Integer>(Collections.nCopies(titles.length, 0));
            }
            ArrayList<String> l = new ArrayList<String>();
            this.fillColumns(l, titles);
            this.HEADER_LIST.add(l);
            return this;
        }

        public Table addBody(String ... values) {
            ArrayList<String> l = new ArrayList<String>();
            this.BODY_LIST.add(l);
            this.fillColumns(l, values);
            return this;
        }

        private void fillColumns(List<String> l, String[] columns) {
            for (int i = 0; i < columns.length; ++i) {
                String column = columns[i];
                String col = Convert.toSBC(column);
                l.add(col);
                int width = col.length();
                if (width <= this.columnCharNumber.get(i)) continue;
                this.columnCharNumber.set(i, width);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.fillBorder(sb);
            this.fillRow(sb, this.HEADER_LIST);
            this.fillBorder(sb);
            this.fillRow(sb, this.BODY_LIST);
            this.fillBorder(sb);
            return sb.toString();
        }

        private void fillRow(StringBuilder sb, List<List<String>> list) {
            for (List<String> r : list) {
                for (int i = 0; i < r.size(); ++i) {
                    if (i == 0) {
                        sb.append('|');
                    }
                    String header = r.get(i);
                    sb.append('\u3000');
                    sb.append(header);
                    sb.append('\u3000');
                    int l = header.length();
                    int lw = this.columnCharNumber.get(i);
                    if (lw > l) {
                        for (int j = 0; j < lw - l; ++j) {
                            sb.append('\u3000');
                        }
                    }
                    sb.append('|');
                }
                sb.append('\n');
            }
        }

        private void fillBorder(StringBuilder sb) {
            sb.append('+');
            for (Integer width : this.columnCharNumber) {
                sb.append(Convert.toSBC(StringKit.fillAfter("", '-', width + 2)));
                sb.append('+');
            }
            sb.append('\n');
        }

        public void print() {
            Console.print(this.toString());
        }
    }
}

