/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lock;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lock.ObjWithLock;

public class ListWithLock<T>
extends ObjWithLock<List<T>> {
    private static final long serialVersionUID = 1L;

    public ListWithLock(List<T> list) {
        super(list);
    }

    public ListWithLock(List<T> list, ReentrantReadWriteLock lock) {
        super(list, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            List list = (List)this.getObj();
            boolean bl = list.add(t);
            return bl;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            ((List)this.getObj()).clear();
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T t) {
        ReentrantReadWriteLock.WriteLock writeLock = this.writeLock();
        writeLock.lock();
        try {
            List list = (List)this.getObj();
            boolean bl = list.remove(t);
            return bl;
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantReadWriteLock.ReadLock readLock = this.readLock();
        readLock.lock();
        try {
            List list = (List)this.getObj();
            int n = list.size();
            return n;
        }
        finally {
            readLock.unlock();
        }
    }
}

