/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.finder;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.text.finder.TextFinder;

public class PatternFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final Pattern pattern;
    private Matcher matcher;

    public PatternFinder(String regex, boolean caseInsensitive) {
        this(Pattern.compile(regex, caseInsensitive ? 2 : 0));
    }

    public PatternFinder(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public TextFinder setText(CharSequence text) {
        this.matcher = this.pattern.matcher(text);
        return super.setText(text);
    }

    @Override
    public int start(int from) {
        if (this.matcher.find(from)) {
            return this.matcher.start();
        }
        return -1;
    }

    @Override
    public int end(int start) {
        return this.matcher.end();
    }

    @Override
    public PatternFinder reset() {
        this.matcher.reset();
        return this;
    }
}

