/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class EnumKit {
    public static boolean isEnum(Class<?> clazz) {
        Assert.notNull(clazz);
        return clazz.isEnum();
    }

    public static boolean isEnum(Object obj) {
        Assert.notNull(obj);
        return obj.getClass().isEnum();
    }

    public static String toString(Enum<?> e) {
        return null != e ? e.name() : null;
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value) {
        return Enum.valueOf(enumClass, value);
    }

    public static <E extends Enum<E>> E fromString(Class<E> enumClass, String value, E defaultValue) {
        return (E)((Enum)ObjectKit.defaultIfNull(EnumKit.fromStringQuietly(enumClass, value), defaultValue));
    }

    public static <E extends Enum<E>> E fromStringQuietly(Class<E> enumClass, String value) {
        if (null == enumClass || StringKit.isBlank(value)) {
            return null;
        }
        try {
            return EnumKit.fromString(enumClass, value);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static <E extends Enum<E>> E likeValueOf(Class<E> enumClass, Object value) {
        if (value instanceof CharSequence) {
            value = value.toString().trim();
        }
        Field[] fields = ReflectKit.getFields(enumClass);
        Enum[] enums = (Enum[])enumClass.getEnumConstants();
        for (Field field : fields) {
            String fieldName = field.getName();
            if (field.getType().isEnum() || "ENUM$VALUES".equals(fieldName) || "ordinal".equals(fieldName)) continue;
            for (Enum enumObj : enums) {
                if (!ObjectKit.equal(value, ReflectKit.getFieldValue((Object)enumObj, field))) continue;
                return (E)enumObj;
            }
        }
        return null;
    }

    public static <E extends Enum<E>> E getEnumAt(Class<E> enumClass, int index) {
        Enum[] enumConstants = (Enum[])enumClass.getEnumConstants();
        return (E)(index >= 0 && index < enumConstants.length ? enumConstants[index] : null);
    }

    public static List<String> getNames(Class<? extends Enum<?>> clazz) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>(enums.length);
        for (Enum<?> e : enums) {
            list.add(e.name());
        }
        return list;
    }

    public static List<Object> getFieldValues(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(enums.length);
        for (Enum<?> e : enums) {
            list.add(ReflectKit.getFieldValue(e, fieldName));
        }
        return list;
    }

    public static List<String> getFieldNames(Class<? extends Enum<?>> clazz) {
        Field[] fields;
        ArrayList<String> names = new ArrayList<String>();
        for (Field field : fields = ReflectKit.getFields(clazz)) {
            String name = field.getName();
            if (field.getType().isEnum() || name.contains("$VALUES") || "ordinal".equals(name) || names.contains(name)) continue;
            names.add(name);
        }
        return names;
    }

    public static Map<String, Object> getFieldNames(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        HashMap<String, Object> map = MapKit.newHashMap(enums.length);
        for (Enum<?> e : enums) {
            map.put(e.name(), ReflectKit.getFieldValue(e, fieldName));
        }
        return map;
    }

    public static <E extends Enum<E>> LinkedHashMap<String, E> getEnumMap(Class<E> enumClass) {
        LinkedHashMap<String, Enum> map = new LinkedHashMap<String, Enum>();
        for (Enum e : (Enum[])enumClass.getEnumConstants()) {
            map.put(e.name(), e);
        }
        return map;
    }

    public static Map<String, Object> getNameFieldMap(Class<? extends Enum<?>> clazz, String fieldName) {
        Enum<?>[] enums = clazz.getEnumConstants();
        if (null == enums) {
            return null;
        }
        HashMap<String, Object> map = MapKit.newHashMap(enums.length, true);
        for (Enum<?> e : enums) {
            map.put(e.name(), ReflectKit.getFieldValue(e, fieldName));
        }
        return map;
    }

    public static <E extends Enum<E>> boolean contains(Class<E> enumClass, String val) {
        return EnumKit.getEnumMap(enumClass).containsKey(val);
    }

    public static <E extends Enum<E>> boolean notContains(Class<E> enumClass, String val) {
        return false == EnumKit.contains(enumClass, val);
    }

    public static boolean equalsIgnoreCase(Enum<?> e, String val) {
        return StringKit.equalsIgnoreCase(EnumKit.toString(e), val);
    }

    public static boolean equals(Enum<?> e, String val) {
        return StringKit.equals(EnumKit.toString(e), val);
    }

    public static <E extends Enum<E>> List<E> getEnumList(Class<E> enumClass) {
        return new ArrayList<E>(Arrays.asList(enumClass.getEnumConstants()));
    }

    public static <E extends Enum<E>> boolean isValidEnum(Class<E> enumClass, String enumName) {
        return null != EnumKit.getEnum(enumClass, enumName);
    }

    public static <E extends Enum<E>> boolean isValidEnumIgnoreCase(Class<E> enumClass, String enumName) {
        return null != EnumKit.getEnumIgnoreCase(enumClass, enumName);
    }

    public static <E extends Enum<E>> E getEnum(Class<E> enumClass, String enumName) {
        if (null == enumName) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static <E extends Enum<E>> E getEnumIgnoreCase(Class<E> enumClass, String enumName) {
        if (null == enumName || !enumClass.isEnum()) {
            return null;
        }
        for (Enum each : (Enum[])enumClass.getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(enumName)) continue;
            return (E)each;
        }
        return null;
    }
}

