/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.lang.Holder;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.lang.function.Func1;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class PatternKit {
    private static final Map<RegexWithFlag, Pattern> CACHE = new WeakHashMap<RegexWithFlag, Pattern>();
    private static final ReentrantReadWriteLock CACHE_LOCK = new ReentrantReadWriteLock();
    private static final ReentrantReadWriteLock.ReadLock READ_LOCK = CACHE_LOCK.readLock();
    private static final ReentrantReadWriteLock.WriteLock WRITE_LOCK = CACHE_LOCK.writeLock();

    public static Pattern get(String regex) {
        return PatternKit.get(regex, 0);
    }

    public static Pattern get(String regex, int flags) {
        RegexWithFlag regexWithFlag = new RegexWithFlag(regex, flags);
        Pattern pattern = PatternKit.isGet(regexWithFlag);
        if (null == pattern) {
            pattern = Pattern.compile(regex, flags);
            PatternKit.isPut(regexWithFlag, pattern);
        }
        return pattern;
    }

    public static String get(String regex, String content, int groupIndex) {
        if (null == content || null == regex) {
            return null;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.get(pattern, content, groupIndex);
    }

    public static String get(Pattern pattern, String content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String get(Pattern pattern, CharSequence content, int groupIndex) {
        if (null == content || null == pattern) {
            return null;
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return matcher.group(groupIndex);
        }
        return null;
    }

    public static String getGroup0(String regex, String content) {
        return PatternKit.get(regex, content, 0);
    }

    public static String getGroup1(String regex, String content) {
        return PatternKit.get(regex, content, 1);
    }

    public static String getGroup0(Pattern pattern, String content) {
        return PatternKit.get(pattern, content, 0);
    }

    public static String getGroup1(Pattern pattern, String content) {
        return PatternKit.get(pattern, content, 1);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content) {
        return PatternKit.getAllGroups(pattern, content, true);
    }

    public static List<String> getAllGroups(Pattern pattern, CharSequence content, boolean withGroup0) {
        if (null == content || null == pattern) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            int startGroup = withGroup0 ? 0 : 1;
            int groupCount = matcher.groupCount();
            for (int i = startGroup; i <= groupCount; ++i) {
                result.add(matcher.group(i));
            }
        }
        return result;
    }

    public static String extractMulti(Pattern pattern, CharSequence content, String template) {
        if (null == content || null == pattern || null == template) {
            return null;
        }
        TreeSet<Integer> varNums = new TreeSet<Integer>((o1, o2) -> ObjectKit.compare(o2, o1));
        Matcher matcherForTemplate = RegEx.GROUP_VAR.matcher(template);
        while (matcherForTemplate.find()) {
            varNums.add(Integer.parseInt(matcherForTemplate.group(1)));
        }
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (Integer group : varNums) {
                template = template.replace("$" + group, matcher.group(group));
            }
            return template;
        }
        return null;
    }

    public static String extractMulti(String regex, CharSequence content, String template) {
        if (null == content || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.extractMulti(pattern, content, template);
    }

    public static String extractMultiAndDelPre(Pattern pattern, Holder<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == pattern || null == template) {
            return null;
        }
        HashSet<String> varNums = PatternKit.findAll(RegEx.GROUP_VAR, template, 1, new HashSet());
        CharSequence content = (CharSequence)contentHolder.get();
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            for (String var : varNums) {
                int group = Integer.parseInt(var);
                template = template.replace("$" + var, matcher.group(group));
            }
            contentHolder.set(StringKit.sub(content, matcher.end(), content.length()));
            return template;
        }
        return null;
    }

    public static String extractMultiAndDelPre(String regex, Holder<CharSequence> contentHolder, String template) {
        if (null == contentHolder || null == regex || null == template) {
            return null;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.extractMultiAndDelPre(pattern, contentHolder, template);
    }

    public static String delFirst(Pattern pattern, String content) {
        if (null == pattern || StringKit.isBlank(content)) {
            return content;
        }
        return pattern.matcher(content).replaceFirst("");
    }

    public static String delLast(String regex, CharSequence text) {
        if (StringKit.hasBlank(regex, text)) {
            return StringKit.toString(text);
        }
        return PatternKit.delLast(PatternKit.get(regex, 32), text);
    }

    public static String delLast(Pattern pattern, CharSequence text) {
        if (null != pattern && StringKit.isNotBlank(text)) {
            String last = "";
            Matcher matcher = pattern.matcher(text);
            while (matcher.find()) {
                last = matcher.group();
            }
            if (StringKit.isNotBlank(last)) {
                return StringKit.subBefore(text, last, (boolean)Boolean.TRUE) + StringKit.subAfter(text, last, (boolean)Boolean.TRUE);
            }
        }
        return StringKit.toString(text);
    }

    public static String delAll(Pattern pattern, String content) {
        if (null == pattern || StringKit.isBlank(content)) {
            return content;
        }
        return pattern.matcher(content).replaceAll("");
    }

    public static String delAll(String regex, String content) {
        if (StringKit.hasBlank(regex, content)) {
            return content;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.delAll(pattern, content);
    }

    public static String delPre(String regex, String content) {
        if (null == content || null == regex) {
            return content;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            return StringKit.sub(content, matcher.end(), content.length());
        }
        return content;
    }

    public static List<String> findAllGroup0(String regex, String content) {
        return PatternKit.findAll(regex, content, 0);
    }

    public static List<String> findAllGroup1(String regex, String content) {
        return PatternKit.findAll(regex, content, 1);
    }

    public static List<String> findAll(String regex, String content, int group) {
        return PatternKit.findAll(regex, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(String regex, String content, int group, T collection) {
        if (null == regex) {
            return null;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.findAll(pattern, content, group, collection);
    }

    public static List<String> findAll(Pattern pattern, String content, int group) {
        return PatternKit.findAll(pattern, content, group, new ArrayList());
    }

    public static <T extends Collection<String>> T findAll(Pattern pattern, String content, int group, T collection) {
        if (null == pattern || null == content) {
            return null;
        }
        if (null == collection) {
            throw new NullPointerException("Null collection param provided!");
        }
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            collection.add((String)matcher.group(group));
        }
        return collection;
    }

    public static int count(String regex, String content) {
        if (null == regex || null == content) {
            return 0;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.count(pattern, content);
    }

    public static int count(Pattern pattern, String content) {
        if (null == pattern || null == content) {
            return 0;
        }
        int count = 0;
        Matcher matcher = pattern.matcher(content);
        while (matcher.find()) {
            ++count;
        }
        return count;
    }

    public static boolean contains(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return false;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.contains(pattern, content);
    }

    public static boolean contains(Pattern pattern, CharSequence content) {
        if (null == pattern || null == content) {
            return false;
        }
        return pattern.matcher(content).find();
    }

    public static boolean isMatch(String regex, CharSequence content) {
        if (null == content) {
            return false;
        }
        if (StringKit.isEmpty(regex)) {
            return true;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.isMatch(pattern, content);
    }

    public static boolean isMatch(Pattern pattern, CharSequence content) {
        if (null == content || null == pattern) {
            return false;
        }
        return pattern.matcher(content).matches();
    }

    public static String replaceAll(CharSequence content, String regex, String replacementTemplate) {
        Pattern pattern = Pattern.compile(regex, 32);
        return PatternKit.replaceAll(content, pattern, replacementTemplate);
    }

    public static String replaceAll(CharSequence content, Pattern pattern, String replacementTemplate) {
        if (StringKit.isEmpty(content)) {
            return StringKit.toString(content);
        }
        Matcher matcher = pattern.matcher(content);
        boolean result = matcher.find();
        if (result) {
            Set varNums = PatternKit.findAll(RegEx.GROUP_VAR, replacementTemplate, 1, new HashSet());
            StringBuffer sb = new StringBuffer();
            do {
                String replacement = replacementTemplate;
                for (String var : varNums) {
                    int group = Integer.parseInt(var);
                    replacement = replacement.replace("$" + var, matcher.group(group));
                }
                matcher.appendReplacement(sb, PatternKit.escape(replacement));
            } while (result = matcher.find());
            matcher.appendTail(sb);
            return sb.toString();
        }
        return StringKit.toString(content);
    }

    public static String replaceAll(CharSequence text, String regex, Func1<Matcher, String> replaceFun) {
        return PatternKit.replaceAll(text, Pattern.compile(regex), replaceFun);
    }

    public static String replaceAll(CharSequence text, Pattern pattern, Func1<Matcher, String> replaceFun) {
        if (StringKit.isEmpty(text)) {
            return StringKit.toString(text);
        }
        Matcher matcher = pattern.matcher(text);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            try {
                matcher.appendReplacement(buffer, replaceFun.call(matcher));
            }
            catch (Exception e) {
                throw new InstrumentException(e);
            }
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static String escape(char c) {
        StringBuilder builder = new StringBuilder();
        if (RegEx.RE_KEYS.contains(Character.valueOf(c))) {
            builder.append('\\');
        }
        builder.append(c);
        return builder.toString();
    }

    public static String escape(String content) {
        if (StringKit.isBlank(content)) {
            return content;
        }
        StringBuilder builder = new StringBuilder();
        int len = content.length();
        for (int i = 0; i < len; ++i) {
            char current = content.charAt(i);
            if (RegEx.RE_KEYS.contains(Character.valueOf(current))) {
                builder.append('\\');
            }
            builder.append(current);
        }
        return builder.toString();
    }

    private static Pattern isGet(RegexWithFlag key) {
        Pattern value;
        READ_LOCK.lock();
        try {
            value = CACHE.get(key);
        }
        finally {
            READ_LOCK.unlock();
        }
        return value;
    }

    private static Object isPut(RegexWithFlag key, Pattern value) {
        WRITE_LOCK.lock();
        try {
            CACHE.put(key, value);
        }
        finally {
            WRITE_LOCK.unlock();
        }
        return value;
    }

    private static Object isRemove(Object key) {
        WRITE_LOCK.lock();
        try {
            Pattern pattern = CACHE.remove(key);
            return pattern;
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    public static Integer getFirstNumber(CharSequence StringWithNumber) {
        return Convert.toInt(PatternKit.get(RegEx.NUMBERS, StringWithNumber, 0), null);
    }

    public static MatchResult indexOf(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return null;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.indexOf(pattern, content);
    }

    public static MatchResult indexOf(Pattern pattern, CharSequence content) {
        Matcher matcher;
        if (null != pattern && null != content && (matcher = pattern.matcher(content)).find()) {
            return matcher.toMatchResult();
        }
        return null;
    }

    public static MatchResult lastIndexOf(String regex, CharSequence content) {
        if (null == regex || null == content) {
            return null;
        }
        Pattern pattern = PatternKit.get(regex, 32);
        return PatternKit.lastIndexOf(pattern, content);
    }

    public static MatchResult lastIndexOf(Pattern pattern, CharSequence content) {
        MatchResult result = null;
        if (null != pattern && null != content) {
            Matcher matcher = pattern.matcher(content);
            while (matcher.find()) {
                result = matcher.toMatchResult();
            }
        }
        return result;
    }

    public void clear() {
        WRITE_LOCK.lock();
        try {
            CACHE.clear();
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    private static class RegexWithFlag {
        private final String regex;
        private final int flag;

        public RegexWithFlag(String regex, int flag) {
            this.regex = regex;
            this.flag = flag;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.flag;
            result = 31 * result + (null == this.regex ? 0 : this.regex.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RegexWithFlag other = (RegexWithFlag)obj;
            if (this.flag != other.flag) {
                return false;
            }
            if (null == this.regex) {
                return null == other.regex;
            }
            return this.regex.equals(other.regex);
        }
    }
}

