/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Base64Encoder {
    public static byte[] encode(byte[] arr, boolean lineSep) {
        return Base64Encoder.encode(arr, lineSep, false);
    }

    public static byte[] encodeUrlSafe(byte[] arr, boolean lineSep) {
        return Base64Encoder.encode(arr, lineSep, true);
    }

    public static String encode(CharSequence source) {
        return Base64Encoder.encode(source, Charset.UTF_8);
    }

    public static String encodeUrlSafe(CharSequence source) {
        return Base64Encoder.encodeUrlSafe(source, Charset.UTF_8);
    }

    public static String encode(CharSequence source, java.nio.charset.Charset charset) {
        return Base64Encoder.encode(StringKit.bytes(source, charset));
    }

    public static String encodeUrlSafe(CharSequence source, java.nio.charset.Charset charset) {
        return Base64Encoder.encodeUrlSafe(StringKit.bytes(source, charset));
    }

    public static String encode(byte[] source) {
        return StringKit.toString(Base64Encoder.encode(source, false), Charset.UTF_8);
    }

    public static String encodeUrlSafe(byte[] source) {
        return StringKit.toString(Base64Encoder.encodeUrlSafe(source, false), Charset.UTF_8);
    }

    public static byte[] encode(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        if (null == arr) {
            return null;
        }
        int len = arr.length;
        if (len == 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destlen = cnt + (isMultiLine ? (cnt - 1) / 76 << 1 : 0);
        byte[] dest = new byte[destlen];
        byte[] encodeTable = isUrlSafe ? Normal.ENCODE_URL_TABLE : Normal.ENCODE_64_TABLE;
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < evenlen) {
            int i = (arr[s++] & 0xFF) << 16 | (arr[s++] & 0xFF) << 8 | arr[s++] & 0xFF;
            dest[d++] = encodeTable[i >>> 18 & 0x3F];
            dest[d++] = encodeTable[i >>> 12 & 0x3F];
            dest[d++] = encodeTable[i >>> 6 & 0x3F];
            dest[d++] = encodeTable[i & 0x3F];
            if (!isMultiLine || ++cc != 19 || d >= destlen - 2) continue;
            dest[d++] = 13;
            dest[d++] = 10;
            cc = 0;
        }
        int left = len - evenlen;
        if (left > 0) {
            int i = (arr[evenlen] & 0xFF) << 10 | (left == 2 ? (arr[len - 1] & 0xFF) << 2 : 0);
            dest[destlen - 4] = encodeTable[i >> 12];
            dest[destlen - 3] = encodeTable[i >>> 6 & 0x3F];
            if (isUrlSafe) {
                int urlSafeLen = destlen - 2;
                if (2 == left) {
                    dest[destlen - 2] = encodeTable[i & 0x3F];
                    ++urlSafeLen;
                }
                byte[] urlSafeDest = new byte[urlSafeLen];
                System.arraycopy(dest, 0, urlSafeDest, 0, urlSafeLen);
                return urlSafeDest;
            }
            dest[destlen - 2] = left == 2 ? encodeTable[i & 0x3F] : 61;
            dest[destlen - 1] = 61;
        }
        return dest;
    }

    public static void encode(byte[] src, int srcPos, int srcLen, char[] dest, int destPos) {
        byte b2;
        byte b1;
        if (srcPos < 0 || srcLen < 0 || srcLen > src.length - srcPos) {
            throw new IndexOutOfBoundsException();
        }
        int destLen = srcLen * 4 / 3 + 3 & 0xFFFFFFFC;
        if (destPos < 0 || destLen > dest.length - destPos) {
            throw new IndexOutOfBoundsException();
        }
        int n = srcLen / 3;
        int r = srcLen - 3 * n;
        while (n-- > 0) {
            int n2 = destPos++;
            b1 = src[srcPos++];
            dest[n2] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
            int n3 = destPos++;
            b2 = src[srcPos++];
            dest[n3] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
            int n4 = destPos++;
            byte b3 = src[srcPos++];
            dest[n4] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b2 & 0xF) << 2 | b3 >>> 6 & 3];
            dest[destPos++] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b3 & 0x3F];
        }
        if (r > 0) {
            if (r == 1) {
                int n5 = destPos++;
                b1 = src[srcPos];
                dest[n5] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
                dest[destPos++] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4];
                dest[destPos++] = 61;
                dest[destPos++] = 61;
            } else {
                int n6 = destPos++;
                b1 = src[srcPos++];
                dest[n6] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
                int n7 = destPos++;
                b2 = src[srcPos];
                dest[n7] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
                dest[destPos++] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b2 & 0xF) << 2];
                dest[destPos++] = 61;
            }
        }
    }
}

