/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.compress;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.IoKit;

public class Gzip
implements Closeable {
    private InputStream source;
    private OutputStream target;

    public Gzip(InputStream source, OutputStream target) {
        this.source = source;
        this.target = target;
    }

    public static Gzip of(InputStream source, OutputStream target) {
        return new Gzip(source, target);
    }

    public OutputStream getTarget() {
        return this.target;
    }

    public Gzip gzip() {
        try {
            this.target = this.target instanceof GZIPOutputStream ? (GZIPOutputStream)this.target : new GZIPOutputStream(this.target);
            IoKit.copy(this.source, this.target);
            ((GZIPOutputStream)this.target).finish();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    public Gzip unGzip() {
        try {
            this.source = this.source instanceof GZIPInputStream ? (GZIPInputStream)this.source : new GZIPInputStream(this.source);
            IoKit.copy(this.source, this.target);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    @Override
    public void close() {
        IoKit.close(this.target);
        IoKit.close(this.source);
    }
}

