/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.convert.NumberFormatter;
import org.aoju.bus.core.date.Almanac;
import org.aoju.bus.core.date.Converter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.formatter.DateParser;
import org.aoju.bus.core.date.formatter.DatePeriod;
import org.aoju.bus.core.date.formatter.DatePrinter;
import org.aoju.bus.core.date.formatter.FastDateParser;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Formatter {
    public static String format(Date date) {
        if (null != date) {
            return Fields.NORM_DATETIME_FORMAT.format(date);
        }
        return "";
    }

    public static String format(Date date, String format) {
        TimeZone timeZone;
        if (null == date || StringKit.isBlank(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date instanceof DateTime && null != (timeZone = ((DateTime)date).getTimeZone())) {
            sdf.setTimeZone(timeZone);
        }
        return Formatter.format(date, sdf);
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return Formatter.format((TemporalAccessor)date.toInstant(), format);
    }

    public static String format(String srcDate, String srcPattern, String destPattern) {
        try {
            SimpleDateFormat srcSdf = new SimpleDateFormat(srcPattern);
            SimpleDateFormat dstSdf = new SimpleDateFormat(destPattern);
            return dstSdf.format(srcSdf.parse(srcDate));
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static long format(String date) {
        try {
            return Fields.NORM_DATETIME_FORMAT.parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static String format(long timestamp) {
        return Fields.NORM_DATETIME_FORMAT.format(new Date(timestamp));
    }

    public static String format(long timestamp, String format) {
        return new SimpleDateFormat(format).format(new Date(timestamp));
    }

    public static long format(String date, String format) {
        try {
            return new SimpleDateFormat(format).parse(date).getTime();
        }
        catch (ParseException e) {
            throw new InstrumentException(e);
        }
    }

    public static String format(LocalDateTime localDateTime) {
        return Formatter.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(LocalDateTime localDateTime, String format) {
        if (null == localDateTime || StringKit.isBlank(format)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return localDateTime.format(df);
    }

    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (null == time) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        if (null == formatter) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter.format(time);
        }
        catch (UnsupportedTemporalTypeException e) {
            if (time instanceof LocalDate && e.getMessage().contains("HourOfDay")) {
                return formatter.format(((LocalDate)time).atStartOfDay());
            }
            if (time instanceof LocalTime && e.getMessage().contains("YearOfEra")) {
                return formatter.format(((LocalTime)time).atDate(LocalDate.now()));
            }
            if (time instanceof Instant) {
                return formatter.format(((Instant)time).atZone(ZoneId.systemDefault()));
            }
            throw e;
        }
    }

    public static String format(TemporalAccessor time, String format) {
        if (null == time) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        DateTimeFormatter formatter = StringKit.isBlank(format) ? null : DateTimeFormatter.ofPattern(format);
        return Formatter.format(time, formatter);
    }

    public static String format(Date date, boolean isUppercase, boolean withTime) {
        if (null == date) {
            return null;
        }
        if (!isUppercase) {
            return (withTime ? Fields.NORM_CN_DATE_TIME_FORMAT : Fields.NORM_DATE_CN_FORMAT).format(date);
        }
        return Formatter.parse(Converter.toCalendar(date), withTime);
    }

    public static String format(Calendar calendar, boolean withTime) {
        StringBuilder result = StringKit.builder(new CharSequence[0]);
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(NumberFormatter.toChinese(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(NumberFormatter.format(month, false));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(NumberFormatter.format(day, false));
        result.append('\u65e5');
        if (withTime) {
            int hour = calendar.get(11);
            result.append(NumberFormatter.format(hour, false));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(NumberFormatter.format(minute, false));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(NumberFormatter.format(second, false));
            result.append('\u79d2');
        }
        return result.toString().replace('\u96f6', '\u3007');
    }

    public static String formatDate(Date date) {
        return Formatter.formatDate(date, false);
    }

    public static String formatDate(Date date, boolean isHttp) {
        if (null == date) {
            return null;
        }
        if (isHttp) {
            return Fields.HTTP_DATETIME_FORMAT.format(date);
        }
        return Fields.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_TIME_FORMAT.format(date);
    }

    public static String formatBetween(Date beginDate, Date endDate, Fields.Units units) {
        return Formatter.formatBetween(Almanac.between(beginDate, endDate, Fields.Units.MILLISECOND), units);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return Formatter.formatBetween(Almanac.between(beginDate, endDate, Fields.Units.MILLISECOND));
    }

    public static String formatBetween(long betweenMs, Fields.Units units) {
        return new DatePeriod(betweenMs, units).format();
    }

    public static String formatBetween(long betweenMs) {
        return new DatePeriod(betweenMs, Fields.Units.MILLISECOND).format();
    }

    public static String parse(Calendar calendar, boolean withTime) {
        StringBuilder result = StringKit.builder(new CharSequence[0]);
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(NumberFormatter.toChinese(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(NumberFormatter.format(month, false));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(NumberFormatter.format(day, false));
        result.append('\u65e5');
        String temp = result.toString().replace('\u96f6', '\u3007');
        result.delete(0, result.length());
        result.append(temp);
        if (withTime) {
            int hour = calendar.get(11);
            result.append(NumberFormatter.format(hour, false));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(NumberFormatter.format(minute, false));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(NumberFormatter.format(second, false));
            result.append('\u79d2');
        }
        return result.toString();
    }

    public static DateTime parse(CharSequence text) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        String dateStr = text.toString();
        dateStr = StringKit.removeAll((CharSequence)dateStr.trim(), '\u65e5', '\u79d2');
        int length = dateStr.length();
        if (MathKit.isNumber(dateStr)) {
            if (length == "yyyyMMddHHmmss".length()) {
                return Formatter.parse(dateStr, Fields.PURE_DATETIME_FORMAT);
            }
            if (length == "yyyyMMddHHmmssSSS".length()) {
                return Formatter.parse(dateStr, Fields.PURE_DATETIME_MS_FORMAT);
            }
            if (length == "yyyyMMdd".length()) {
                return Formatter.parse(dateStr, Fields.PURE_DATE_FORMAT);
            }
            if (length == "HHmmss".length()) {
                return Formatter.parse(dateStr, Fields.PURE_TIME_FORMAT);
            }
        } else {
            if (PatternKit.isMatch(RegEx.TIME, (CharSequence)dateStr)) {
                return Formatter.parseTimeToday(dateStr);
            }
            if (StringKit.containsAnyIgnoreCase(dateStr, Fields.WTB)) {
                return Formatter.parseCST(dateStr);
            }
            if (StringKit.contains((CharSequence)dateStr, 'T')) {
                return Formatter.parseUTC(dateStr);
            }
        }
        if (PatternKit.isMatch(Fields.REGEX_NORM, (CharSequence)(dateStr = Formatter.normalize(dateStr)))) {
            int colonCount = CharsKit.count((CharSequence)dateStr, ":");
            switch (colonCount) {
                case 0: {
                    return Formatter.parse(dateStr, Fields.NORM_DATE_FORMAT);
                }
                case 1: {
                    return Formatter.parse(dateStr, Fields.NORM_DATETIME_MINUTE_FORMAT);
                }
                case 2: {
                    int indexOfDot = StringKit.indexOf(dateStr, '.');
                    if (indexOfDot > 0) {
                        int length1 = dateStr.length();
                        if (length1 - indexOfDot > 4) {
                            dateStr = StringKit.subPre(dateStr, indexOfDot + 4);
                        }
                        return Formatter.parse(dateStr, Fields.NORM_DATETIME_MS_FORMAT);
                    }
                    return Formatter.parse(dateStr, Fields.NORM_DATETIME_FORMAT);
                }
            }
        }
        throw new InstrumentException("No format fit for date String [{}] !", dateStr);
    }

    public static LocalDateTime parse(CharSequence text, String pattern) {
        text = Formatter.normalize(text);
        DateTimeFormatter df = DateTimeFormatter.ofPattern(pattern);
        try {
            return LocalDateTime.parse(text, df);
        }
        catch (DateTimeParseException e) {
            return LocalDate.parse(text, df).atStartOfDay();
        }
    }

    public static DateTime parse(String text, DateFormat format) {
        return new DateTime((CharSequence)text, format);
    }

    public static DateTime parse(String text, DateParser parser) {
        return new DateTime((CharSequence)text, parser);
    }

    public static DateTime parse(String text, String pattern) {
        return new DateTime((CharSequence)text, pattern);
    }

    public static Calendar parse(String text, String ... format) {
        return Formatter.parseByPatterns(text, null, format);
    }

    public static Calendar parse(String text, Locale locale, String ... pattern) {
        return Formatter.parseByPatterns(text, locale, true, pattern);
    }

    public static DateTime parse(CharSequence text, DateParser parser, boolean lenient) {
        return new DateTime(text, parser, lenient);
    }

    public static Calendar parse(String text, Locale locale, boolean lenient, String ... pattern) {
        if (null == text || null == pattern) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectKit.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : pattern) {
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(text, pos, calendar) && pos.getIndex() == text.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new InstrumentException("Unable to parse the date: {}", text);
    }

    public static DateTime parseDate(String text) {
        return Formatter.parse(Formatter.normalize(text), Fields.NORM_DATE_FORMAT);
    }

    public static DateTime parseTime(String text) {
        return Formatter.parse(Formatter.normalize(text), Fields.NORM_TIME_FORMAT);
    }

    public static DateTime parseDateTime(String text) {
        return Formatter.parse(Formatter.normalize(text), Fields.NORM_DATETIME_FORMAT);
    }

    public static DateTime parseTimeToday(String text) {
        text = StringKit.format((CharSequence)"{} {}", Formatter.formatDate(new DateTime()), text);
        if (1 == StringKit.count((CharSequence)text, ':')) {
            return Formatter.parse(text, "yyyy-MM-dd HH:mm");
        }
        return Formatter.parse(text, Fields.NORM_DATETIME_FORMAT);
    }

    public static Calendar parse(CharSequence text, boolean lenient, DateParser parser) {
        Calendar calendar = Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        return parser.parse(StringKit.toString(text), new ParsePosition(0), calendar) ? calendar : null;
    }

    public static DateTime parseCST(CharSequence text) {
        if (null == text) {
            return null;
        }
        return Formatter.parse((String)text, Fields.JDK_DATETIME_FORMAT);
    }

    public static DateTime parseUTC(String text) {
        if (null == text) {
            return null;
        }
        int length = text.length();
        if (StringKit.contains((CharSequence)text, 'Z')) {
            if (length == "yyyy-MM-dd'T'HH:mm:ss'Z'".length() - 4) {
                return Formatter.parse(text, Fields.UTC_FORMAT);
            }
            int patternLength = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'".length();
            if (length <= patternLength - 4 && length >= patternLength - 6) {
                return Formatter.parse(text, Fields.OUTPUT_MSEC_FORMAT);
            }
        } else {
            if (StringKit.contains((CharSequence)text, '+')) {
                String zoneOffset = StringKit.subAfter((CharSequence)(text = text.replace(" +", "+")), '+', true);
                if (StringKit.isBlank(zoneOffset)) {
                    throw new InstrumentException("Invalid format: [{}]", text);
                }
                if (!StringKit.contains((CharSequence)zoneOffset, ':')) {
                    String pre = StringKit.subBefore((CharSequence)text, '+', true);
                    text = pre + "+" + zoneOffset.substring(0, 2) + ':' + "0" + "0";
                }
                if (StringKit.contains((CharSequence)text, ".")) {
                    return Formatter.parse(text, Fields.WITH_XXX_OFFSET_FORMAT);
                }
                return Formatter.parse(text, Fields.WITH_XXX_OFFSET_FORMAT);
            }
            if (length == "yyyy-MM-dd'T'HH:mm:ss".length() - 2) {
                return Formatter.parse(text, Fields.SIMPLE_FORMAT);
            }
            if (StringKit.contains((CharSequence)text, ".")) {
                return Formatter.parse(text, Fields.SIMPLE_MS_FORMAT);
            }
        }
        throw new InstrumentException("No format fit for date String [{}] !", text);
    }

    public static Calendar parseByPatterns(String text, String ... pattern) {
        return Formatter.parseByPatterns(text, null, pattern);
    }

    public static Calendar parseByPatterns(String text, Locale locale, String ... pattern) {
        return Formatter.parseByPatterns(text, locale, true, pattern);
    }

    public static Calendar parseByPatterns(String text, Locale locale, boolean lenient, String ... pattern) {
        if (null == text || null == pattern) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectKit.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : pattern) {
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(text, pos, calendar) && pos.getIndex() == text.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new InstrumentException("Unable to parse the date: {}", text);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return Formatter.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    public static String getShotName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return unit.name().toLowerCase();
    }

    private static String normalize(CharSequence dateStr) {
        if (StringKit.isBlank(dateStr)) {
            return StringKit.toString(dateStr);
        }
        List<String> dateAndTime = StringKit.splitTrim(dateStr, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringKit.toString(dateStr);
        }
        StringBuilder builder = StringKit.builder(new CharSequence[0]);
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringKit.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringKit.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

