/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.painter;

import java.awt.AlphaComposite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.image.element.RectangleElement;
import org.aoju.bus.core.image.painter.Painter;

public class RectanglePainter
implements Painter {
    @Override
    public void draw(Graphics2D g, AbstractElement element, int canvasWidth) {
        RectangleElement rectangleElement = (RectangleElement)element;
        g.setColor(rectangleElement.getColor());
        if (rectangleElement.isCenter()) {
            int centerX = (canvasWidth - rectangleElement.getWidth()) / 2;
            rectangleElement.setX(centerX);
        }
        if (rectangleElement.getFromColor() != null) {
            float fromX = 0.0f;
            float fromY = 0.0f;
            float toX = 0.0f;
            float toY = 0.0f;
            switch (rectangleElement.getGradient()) {
                case TOP_BOTTOM: {
                    fromX = rectangleElement.getX() + rectangleElement.getWidth() / 2;
                    fromY = rectangleElement.getY() - rectangleElement.getFromExtend();
                    toX = fromX;
                    toY = rectangleElement.getY() + rectangleElement.getHeight() + rectangleElement.getToExtend();
                    break;
                }
                case LEFT_RIGHT: {
                    fromX = rectangleElement.getX() - rectangleElement.getFromExtend();
                    fromY = rectangleElement.getY() + rectangleElement.getHeight() / 2;
                    toX = rectangleElement.getX() + rectangleElement.getWidth() + rectangleElement.getToExtend();
                    toY = fromY;
                    break;
                }
                case LEFT_TOP_TO_RIGHT_BOTTOM: {
                    fromX = (float)rectangleElement.getX() - (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    fromY = (float)rectangleElement.getY() - (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    toX = (float)(rectangleElement.getX() + rectangleElement.getWidth()) + (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                    toY = (float)(rectangleElement.getY() + rectangleElement.getHeight()) + (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                    break;
                }
                case RIGHT_TOP_TO_LEFT_BOTTOM: {
                    fromX = (float)(rectangleElement.getX() + rectangleElement.getWidth()) + (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    fromY = (float)rectangleElement.getY() - (float)Math.sqrt(rectangleElement.getFromExtend().intValue());
                    toX = (float)rectangleElement.getX() - (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                    toY = (float)(rectangleElement.getY() + rectangleElement.getHeight()) + (float)Math.sqrt(rectangleElement.getToExtend().intValue());
                }
            }
            g.setPaint(new GradientPaint(fromX, fromY, rectangleElement.getFromColor(), toX, toY, rectangleElement.getToColor()));
        } else {
            g.setPaint(null);
        }
        g.setComposite(AlphaComposite.getInstance(3, rectangleElement.getAlpha()));
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(rectangleElement.getX(), rectangleElement.getY(), rectangleElement.getWidth(), rectangleElement.getHeight(), rectangleElement.getRoundCorner(), rectangleElement.getRoundCorner());
    }
}

