/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.aoju.bus.core.io.Buffer;
import org.aoju.bus.core.io.ByteString;
import org.aoju.bus.core.io.DelegateSink;
import org.aoju.bus.core.io.Segment;
import org.aoju.bus.core.io.Sink;
import org.aoju.bus.core.lang.Algorithm;
import org.aoju.bus.core.toolkit.IoKit;

public final class HashSink
extends DelegateSink {
    private final MessageDigest messageDigest;
    private final Mac mac;

    private HashSink(Sink sink, String algorithm) {
        super(sink);
        try {
            this.messageDigest = MessageDigest.getInstance(algorithm);
            this.mac = null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
    }

    private HashSink(Sink sink, ByteString key, String algorithm) {
        super(sink);
        try {
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(new SecretKeySpec(key.toByteArray(), algorithm));
            this.messageDigest = null;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static HashSink md5(Sink sink) {
        return new HashSink(sink, Algorithm.MD5.getValue());
    }

    public static HashSink sha1(Sink sink) {
        return new HashSink(sink, Algorithm.SHA1.getValue());
    }

    public static HashSink sha256(Sink sink) {
        return new HashSink(sink, Algorithm.SHA256.getValue());
    }

    public static HashSink sha512(Sink sink) {
        return new HashSink(sink, Algorithm.SHA512.getValue());
    }

    public static HashSink hmacSha1(Sink sink, ByteString key) {
        return new HashSink(sink, key, Algorithm.HMACSHA1.getValue());
    }

    public static HashSink hmacSha256(Sink sink, ByteString key) {
        return new HashSink(sink, key, Algorithm.HMACSHA256.getValue());
    }

    public static HashSink hmacSha512(Sink sink, ByteString key) {
        return new HashSink(sink, key, Algorithm.HMACSHA512.getValue());
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        int toHash;
        IoKit.checkOffsetAndCount(source.size, 0L, byteCount);
        Segment s = source.head;
        for (long hashedCount = 0L; hashedCount < byteCount; hashedCount += (long)toHash) {
            toHash = (int)Math.min(byteCount - hashedCount, (long)(s.limit - s.pos));
            if (null != this.messageDigest) {
                this.messageDigest.update(s.data, s.pos, toHash);
            } else {
                this.mac.update(s.data, s.pos, toHash);
            }
            s = s.next;
        }
        super.write(source, byteCount);
    }

    public final ByteString hash() {
        byte[] result = null != this.messageDigest ? this.messageDigest.digest() : this.mac.doFinal();
        return ByteString.of(result);
    }
}

