/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.Serializable;
import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.MapKit;
import org.aoju.bus.core.toolkit.RandomKit;

public class Weighing<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TreeMap<Double, T> weightMap = new TreeMap();

    public Weighing() {
    }

    public Weighing(WeightObj<T> weightObj) {
        this();
        if (null != weightObj) {
            this.add(weightObj);
        }
    }

    public Weighing(Iterable<WeightObj<T>> weightObjs) {
        this();
        if (CollKit.isNotEmpty(weightObjs)) {
            for (WeightObj<T> weightObj : weightObjs) {
                this.add(weightObj);
            }
        }
    }

    public Weighing(WeightObj<T>[] weightObjs) {
        this();
        for (WeightObj<T> weightObj : weightObjs) {
            this.add(weightObj);
        }
    }

    public static <T> Weighing<T> create() {
        return new Weighing<T>();
    }

    public Weighing<T> add(T obj, double weight) {
        return this.add(new WeightObj<T>(obj, weight));
    }

    public Weighing<T> add(WeightObj<T> weightObj) {
        double lastWeight = this.weightMap.size() == 0 ? 0.0 : this.weightMap.lastKey();
        this.weightMap.put(weightObj.getWeight() + lastWeight, weightObj.getObj());
        return this;
    }

    public Weighing<T> clear() {
        if (null != this.weightMap) {
            this.weightMap.clear();
        }
        return this;
    }

    public T next() {
        if (MapKit.isEmpty(this.weightMap)) {
            return null;
        }
        ThreadLocalRandom random = RandomKit.getRandom();
        double randomWeight = this.weightMap.lastKey() * ((Random)random).nextDouble();
        NavigableMap<Double, T> tailMap = this.weightMap.tailMap(randomWeight, false);
        return this.weightMap.get(tailMap.firstKey());
    }

    public static class WeightObj<T> {
        private final double weight;
        private T obj;

        public WeightObj(T obj, double weight) {
            this.obj = obj;
            this.weight = weight;
        }

        public T getObj() {
            return this.obj;
        }

        public void setObj(T obj) {
            this.obj = obj;
        }

        public double getWeight() {
            return this.weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (null == this.obj ? 0 : this.obj.hashCode());
            long temp = Double.doubleToLongBits(this.weight);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            WeightObj other = (WeightObj)obj;
            if (null == this.obj ? null != other.obj : !this.obj.equals(other.obj)) {
                return false;
            }
            return Double.doubleToLongBits(this.weight) == Double.doubleToLongBits(other.weight);
        }
    }
}

