/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;
import java.util.function.Function;
import org.aoju.bus.core.collection.ArrayIterator;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class TextJoiner
implements Appendable,
Serializable {
    private static final long serialVersionUID = 1L;
    private Appendable appendable;
    private CharSequence delimiter;
    private CharSequence prefix;
    private CharSequence suffix;
    private boolean wrapElement;
    private NullMode nullMode = NullMode.NULL_STRING;
    private String emptyResult = "";
    private boolean hasContent;

    public TextJoiner(CharSequence delimiter) {
        this(null, delimiter);
    }

    public TextJoiner(Appendable appendable, CharSequence delimiter) {
        this(appendable, delimiter, null, null);
    }

    public TextJoiner(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        this(null, delimiter, prefix, suffix);
    }

    public TextJoiner(Appendable appendable, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        if (null != appendable) {
            this.appendable = appendable;
            this.checkHasContent(appendable);
        }
        this.delimiter = delimiter;
        this.prefix = prefix;
        this.suffix = suffix;
    }

    public static TextJoiner of(TextJoiner joiner) {
        TextJoiner joinerNew = new TextJoiner(joiner.delimiter, joiner.prefix, joiner.suffix);
        joinerNew.wrapElement = joiner.wrapElement;
        joinerNew.nullMode = joiner.nullMode;
        joinerNew.emptyResult = joiner.emptyResult;
        return joinerNew;
    }

    public static TextJoiner of(CharSequence delimiter) {
        return new TextJoiner(delimiter);
    }

    public static TextJoiner of(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return new TextJoiner(delimiter, prefix, suffix);
    }

    public TextJoiner setDelimiter(CharSequence delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public TextJoiner setPrefix(CharSequence prefix) {
        this.prefix = prefix;
        return this;
    }

    public TextJoiner setSuffix(CharSequence suffix) {
        this.suffix = suffix;
        return this;
    }

    public TextJoiner setWrapElement(boolean wrapElement) {
        this.wrapElement = wrapElement;
        return this;
    }

    public TextJoiner setNullMode(NullMode nullMode) {
        this.nullMode = nullMode;
        return this;
    }

    public TextJoiner setEmptyResult(String emptyResult) {
        this.emptyResult = emptyResult;
        return this;
    }

    public TextJoiner append(Object obj) {
        if (null == obj) {
            this.append((CharSequence)null);
        } else if (ArrayKit.isArray(obj)) {
            this.append(new ArrayIterator(obj));
        } else if (obj instanceof Iterator) {
            this.append((Iterator)obj);
        } else if (obj instanceof Iterable) {
            this.append(((Iterable)obj).iterator());
        } else {
            this.append(String.valueOf(obj));
        }
        return this;
    }

    public <T> TextJoiner append(T[] array) {
        if (null == array) {
            return this;
        }
        return this.append(new ArrayIterator<T>(array));
    }

    public <T> TextJoiner append(Iterator<T> iterator) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                this.append(iterator.next());
            }
        }
        return this;
    }

    public <T> TextJoiner append(T[] array, Function<T, ? extends CharSequence> toStrFunc) {
        return this.append((Iterator<T>)new ArrayIterator<T>(array), toStrFunc);
    }

    public <T> TextJoiner append(Iterable<T> iterable, Function<T, ? extends CharSequence> toStrFunc) {
        return this.append(null == iterable ? null : iterable.iterator(), toStrFunc);
    }

    public <T> TextJoiner append(Iterator<T> iterator, Function<T, ? extends CharSequence> toStrFunc) {
        if (null != iterator) {
            while (iterator.hasNext()) {
                this.append(toStrFunc.apply(iterator.next()));
            }
        }
        return this;
    }

    @Override
    public TextJoiner append(CharSequence csq) {
        if (null == csq) {
            switch (this.nullMode) {
                case IGNORE: {
                    return this;
                }
                case TO_EMPTY: {
                    csq = "";
                    break;
                }
                case NULL_STRING: {
                    csq = "null";
                }
            }
        }
        try {
            Appendable appendable = this.prepare();
            if (this.wrapElement && StringKit.isNotEmpty(this.prefix)) {
                appendable.append(this.prefix);
            }
            appendable.append(csq);
            if (this.wrapElement && StringKit.isNotEmpty(this.suffix)) {
                appendable.append(this.suffix);
            }
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        return this;
    }

    @Override
    public TextJoiner append(CharSequence csq, int startInclude, int endExclude) {
        return this.append(StringKit.sub(csq, startInclude, endExclude));
    }

    @Override
    public TextJoiner append(char c) {
        return this.append(String.valueOf(c));
    }

    public String toString() {
        if (null == this.appendable) {
            return this.emptyResult;
        }
        if (!this.wrapElement && StringKit.isNotEmpty(this.suffix)) {
            try {
                this.appendable.append(this.suffix);
            }
            catch (IOException e) {
                throw new InstrumentException(e);
            }
        }
        return this.appendable.toString();
    }

    private Appendable prepare() throws IOException {
        if (this.hasContent) {
            this.appendable.append(this.delimiter);
        } else {
            if (null == this.appendable) {
                this.appendable = new StringBuilder();
            }
            if (!this.wrapElement && StringKit.isNotEmpty(this.prefix)) {
                this.appendable.append(this.prefix);
            }
            this.hasContent = true;
        }
        return this.appendable;
    }

    private void checkHasContent(Appendable appendable) {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            if (charSequence.length() > 0 && StringKit.endWith(charSequence, this.delimiter)) {
                this.hasContent = true;
            }
        } else {
            String initStr = appendable.toString();
            if (StringKit.isNotEmpty(initStr) && !StringKit.endWith((CharSequence)initStr, this.delimiter)) {
                this.hasContent = true;
            }
        }
    }

    public static enum NullMode {
        IGNORE,
        TO_EMPTY,
        NULL_STRING;

    }
}

