/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.beans.copier;

import java.lang.reflect.Type;
import java.util.Map;
import org.aoju.bus.core.beans.PropertyDesc;
import org.aoju.bus.core.beans.copier.AbstractCopier;
import org.aoju.bus.core.beans.copier.CopyOptions;
import org.aoju.bus.core.beans.copier.ValueProvider;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.core.toolkit.TypeKit;

public class ValueProviderToBeanCopier<T>
extends AbstractCopier<ValueProvider<String>, T> {
    private final Type targetType;

    public ValueProviderToBeanCopier(ValueProvider<String> source, T target, Type targetType, CopyOptions copyOptions) {
        super(source, target, copyOptions);
        this.targetType = targetType;
    }

    @Override
    public T copy() {
        Class<?> actualEditable = this.target.getClass();
        if (null != this.copyOptions.editable) {
            Assert.isTrue(this.copyOptions.editable.isInstance(this.target), "Target class [{}] not assignable to Editable class [{}]", actualEditable.getName(), this.copyOptions.editable.getName());
            actualEditable = this.copyOptions.editable;
        }
        Map<String, PropertyDesc> targetPropertyDescMap = BeanKit.getBeanDesc(actualEditable).getPropMap(this.copyOptions.ignoreCase);
        targetPropertyDescMap.forEach((tFieldName, tDesc) -> {
            if (null == tFieldName) {
                return;
            }
            if (!((ValueProvider)this.source).containsKey(tFieldName)) {
                return;
            }
            if (null == tDesc || !tDesc.isWritable(this.copyOptions.transientSupport)) {
                return;
            }
            Type fieldType = TypeKit.getActualType(this.targetType, tDesc.getFieldType());
            Object sValue = ((ValueProvider)this.source).value(tFieldName, fieldType);
            if (!this.copyOptions.testPropertyFilter(tDesc.getField(), sValue)) {
                return;
            }
            sValue = this.copyOptions.editFieldValue((String)tFieldName, sValue);
            tDesc.setValue(this.target, sValue, this.copyOptions.ignoreNullValue, this.copyOptions.ignoreError, this.copyOptions.override);
        });
        return (T)this.target;
    }
}

