/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.bloom.filter;

import org.aoju.bus.core.bloom.BloomFilter;
import org.aoju.bus.core.bloom.bitmap.BitMap;
import org.aoju.bus.core.bloom.bitmap.IntMap;
import org.aoju.bus.core.bloom.bitmap.LongMap;

public abstract class AbstractFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    protected long size = 0L;
    private BitMap bm = null;

    public AbstractFilter(long maxValue, int machineNum) {
        this.init(maxValue, machineNum);
    }

    public AbstractFilter(long maxValue) {
        this(maxValue, 32);
    }

    public void init(long maxValue, int machineNum) {
        this.size = maxValue;
        switch (machineNum) {
            case 32: {
                this.bm = new IntMap((int)(this.size / (long)machineNum));
                break;
            }
            case 64: {
                this.bm = new LongMap((int)(this.size / (long)machineNum));
                break;
            }
            default: {
                throw new RuntimeException("Error Machine number!");
            }
        }
    }

    @Override
    public boolean contains(String text) {
        return this.bm.contains(Math.abs(this.hash(text)));
    }

    @Override
    public boolean add(String text) {
        long hash = Math.abs(this.hash(text));
        if (this.bm.contains(hash)) {
            return false;
        }
        this.bm.add(hash);
        return true;
    }

    public abstract long hash(String var1);
}

