/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.BitSet;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Percent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final BitSet safeCharacters;
    private boolean encodeSpaceAsPlus = false;

    public Percent() {
        this(new BitSet(256));
    }

    public Percent(BitSet safeCharacters) {
        this.safeCharacters = safeCharacters;
    }

    public static Percent of(Percent codec) {
        return new Percent((BitSet)codec.safeCharacters.clone());
    }

    public static Percent of(CharSequence chars) {
        Percent codec = new Percent();
        int length = chars.length();
        for (int i = 0; i < length; ++i) {
            codec.addSafe(chars.charAt(i));
        }
        return codec;
    }

    public Percent addSafe(char c) {
        this.safeCharacters.set(c);
        return this;
    }

    public Percent removeSafe(char c) {
        this.safeCharacters.clear(c);
        return this;
    }

    public Percent or(Percent codec) {
        this.safeCharacters.or(codec.safeCharacters);
        return this;
    }

    public Percent orNew(Percent codec) {
        return Percent.of(this).or(codec);
    }

    public Percent setEncodeSpaceAsPlus(boolean encodeSpaceAsPlus) {
        this.encodeSpaceAsPlus = encodeSpaceAsPlus;
        return this;
    }

    public String encode(CharSequence path, Charset charset) {
        if (null == charset || StringKit.isEmpty(path)) {
            return StringKit.toString(path);
        }
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, charset);
        for (int i = 0; i < path.length(); ++i) {
            byte[] ba;
            char c = path.charAt(i);
            if (this.safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            if (this.encodeSpaceAsPlus && c == ' ') {
                rewrittenPath.append('+');
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            for (byte toEncode : ba = buf.toByteArray()) {
                rewrittenPath.append('%');
                HexKit.appendHex(rewrittenPath, toEncode, false);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }
}

