/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.StringKit;

public class PunyCode {
    public static final String PUNY_CODE_PREFIX = "xn--";
    private static final int TMIN = 1;
    private static final int TMAX = 26;
    private static final int BASE = 36;
    private static final int INITIAL_N = 128;
    private static final int INITIAL_BIAS = 72;
    private static final int DAMP = 700;
    private static final int SKEW = 38;

    public static String encode(CharSequence input) throws InstrumentException {
        return PunyCode.encode(input, false);
    }

    public static String encode(CharSequence input, boolean withPrefix) throws InstrumentException {
        int n = 128;
        int delta = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int length = input.length();
        int b = 0;
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (!PunyCode.isBasic(c)) continue;
            output.append(c);
            ++b;
        }
        if (b > 0) {
            output.append('-');
        }
        int h = b;
        while (h < length) {
            int c;
            int m = Integer.MAX_VALUE;
            for (int i = 0; i < length; ++i) {
                c = input.charAt(i);
                if (c < n || c >= m) continue;
                m = c;
            }
            if (m - n > (Integer.MAX_VALUE - delta) / (h + 1)) {
                throw new InstrumentException("OVERFLOW");
            }
            delta += (m - n) * (h + 1);
            n = m;
            for (int j = 0; j < length; ++j) {
                int t;
                c = input.charAt(j);
                if (c < n && 0 == ++delta) {
                    throw new InstrumentException("OVERFLOW");
                }
                if (c != n) continue;
                int q = delta;
                int k = 36;
                while (q >= (t = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias))) {
                    output.append((char)PunyCode.digit2codepoint(t + (q - t) % (36 - t)));
                    q = (q - t) / (36 - t);
                    k += 36;
                }
                output.append((char)PunyCode.digit2codepoint(q));
                bias = PunyCode.adapt(delta, h + 1, h == b);
                delta = 0;
                ++h;
            }
            ++delta;
            ++n;
        }
        if (withPrefix) {
            output.insert(0, PUNY_CODE_PREFIX);
        }
        return output.toString();
    }

    public static String decode(String input) throws InstrumentException {
        input = StringKit.removePrefixIgnoreCase(input, PUNY_CODE_PREFIX);
        int n = 128;
        int i = 0;
        int bias = 72;
        StringBuilder output = new StringBuilder();
        int d = input.lastIndexOf(45);
        if (d > 0) {
            for (int j = 0; j < d; ++j) {
                char c = input.charAt(j);
                if (!PunyCode.isBasic(c)) continue;
                output.append(c);
            }
            ++d;
        } else {
            d = 0;
        }
        int length = input.length();
        while (d < length) {
            int oldi = i;
            int w = 1;
            int k = 36;
            while (true) {
                char c;
                int digit;
                if (d == length) {
                    throw new InstrumentException("BAD_INPUT");
                }
                if ((digit = PunyCode.codepoint2digit(c = input.charAt(d++))) > (Integer.MAX_VALUE - i) / w) {
                    throw new InstrumentException("OVERFLOW");
                }
                i += digit * w;
                int t = k <= bias ? 1 : (k >= bias + 26 ? 26 : k - bias);
                if (digit < t) break;
                w *= 36 - t;
                k += 36;
            }
            bias = PunyCode.adapt(i - oldi, output.length() + 1, oldi == 0);
            if (i / (output.length() + 1) > Integer.MAX_VALUE - n) {
                throw new InstrumentException("OVERFLOW");
            }
            n += i / (output.length() + 1);
            output.insert(i %= output.length() + 1, (char)n);
            ++i;
        }
        return output.toString();
    }

    private static int adapt(int delta, int numpoints, boolean first) {
        delta = first ? (delta /= 700) : (delta /= 2);
        delta += delta / numpoints;
        int k = 0;
        while (delta > 455) {
            delta /= 35;
            k += 36;
        }
        return k + 36 * delta / (delta + 38);
    }

    private static boolean isBasic(char c) {
        return c < '\u0080';
    }

    private static int digit2codepoint(int d) throws InstrumentException {
        Assert.checkBetween(d, 0, 35);
        if (d < 26) {
            return d + 97;
        }
        if (d < 36) {
            return d - 26 + 48;
        }
        throw new InstrumentException("BAD_INPUT");
    }

    private static int codepoint2digit(int c) throws InstrumentException {
        if (c - 48 < 10) {
            return c - 48 + 26;
        }
        if (c - 97 < 26) {
            return c - 97;
        }
        throw new InstrumentException("BAD_INPUT");
    }
}

