/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.CropImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.image.element.ImageElement;
import org.aoju.bus.core.image.element.RectangleElement;
import org.aoju.bus.core.image.element.TextElement;
import org.aoju.bus.core.image.painter.Painter;
import org.aoju.bus.core.image.painter.PainterFactory;
import org.aoju.bus.core.image.painter.TextPainter;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Fonts;
import org.aoju.bus.core.lang.Scale;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ImageKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Images
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<AbstractElement> list = new ArrayList<AbstractElement>();
    private BufferedImage srcImage;
    private Image targetImage;
    private float quality = -1.0f;
    private int canvasWidth;
    private int canvasHeight;
    private String fileType = "jpg";
    private boolean positionBaseCentre = true;
    private Integer roundCorner;

    public Images(BufferedImage srcImage) {
        this.srcImage = srcImage;
    }

    public Images(String imageUrl, String fileType) {
        ImageElement bgImageElement = new ImageElement(imageUrl, 0, 0);
        this.list.add(bgImageElement);
        this.canvasWidth = bgImageElement.getImage().getWidth();
        this.canvasHeight = bgImageElement.getImage().getHeight();
        this.fileType = fileType;
    }

    public Images(int canvasWidth, int canvasHeight, String fileType) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.fileType = fileType;
    }

    public Images(int canvasWidth, int canvasHeight, Color bgColor, String fileType) {
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.fileType = fileType;
        RectangleElement bgElement = new RectangleElement(0, 0, canvasWidth, canvasHeight);
        bgElement.setColor(bgColor);
        this.list.add(bgElement);
    }

    public Images(BufferedImage srcImage, String fileType) {
        ImageElement bgImageElement = new ImageElement(srcImage, 0, 0);
        this.list.add(bgImageElement);
        this.canvasWidth = srcImage.getWidth();
        this.canvasHeight = srcImage.getHeight();
        this.fileType = fileType;
        this.srcImage = srcImage;
        if (null == this.fileType) {
            this.fileType = srcImage.getType() == 2 || srcImage.getType() == 3 || srcImage.getType() == 6 || srcImage.getType() == 7 ? "png" : "jpg";
        }
    }

    public Images(BufferedImage srcImage, String imageUrl, String fileType) {
        ImageElement imageElement;
        if (StringKit.isNotEmpty(imageUrl)) {
            imageElement = new ImageElement(imageUrl, 0, 0);
            try {
                this.canvasWidth = imageElement.getImage().getWidth();
                this.canvasHeight = imageElement.getImage().getHeight();
            }
            catch (Exception e) {
                throw new InstrumentException(e.getMessage());
            }
        } else {
            imageElement = new ImageElement(srcImage, 0, 0);
            this.canvasWidth = imageElement.getWidth();
            this.canvasHeight = imageElement.getHeight();
        }
        this.list.add(imageElement);
        this.fileType = fileType;
    }

    public Images(String bgImageUrl, int width, int height, Scale.Mode zoomMode, String fileType) throws Exception {
        ImageElement bgImageElement = new ImageElement(bgImageUrl, 0, 0, width, height, zoomMode);
        this.list.add(bgImageElement);
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.fileType = fileType;
    }

    public Images(BufferedImage bgImage, int width, int height, Scale.Mode zoomMode, String fileType) throws Exception {
        ImageElement bgImageElement = new ImageElement(bgImage, 0, 0, width, height, zoomMode);
        int canvasWidth = 0;
        int canvasHeight = 0;
        switch (zoomMode) {
            case ORIGIN: {
                canvasWidth = bgImage.getWidth();
                canvasHeight = bgImage.getHeight();
                break;
            }
            case WIDTH: {
                canvasWidth = width;
                canvasHeight = bgImage.getHeight() * canvasWidth / bgImage.getWidth();
                break;
            }
            case HEIGHT: {
                canvasHeight = height;
                canvasWidth = bgImage.getWidth() * canvasHeight / bgImage.getHeight();
                break;
            }
            case OPTIONAL: {
                canvasHeight = width;
                canvasWidth = height;
            }
        }
        this.list.add(bgImageElement);
        this.canvasWidth = canvasWidth;
        this.canvasHeight = canvasHeight;
        this.fileType = fileType;
    }

    public static Images from(Path imagePath) {
        return Images.from(imagePath.toFile());
    }

    public static Images from(File imageFile) {
        return new Images(ImageKit.read(imageFile));
    }

    public static Images from(Resource resource) {
        return Images.from(resource.getStream());
    }

    public static Images from(InputStream in) {
        return new Images(ImageKit.read(in));
    }

    public static Images from(ImageInputStream imageStream) {
        return new Images(ImageKit.read(imageStream));
    }

    public static Images from(URL imageUrl) {
        return new Images(ImageKit.read(imageUrl));
    }

    public static Images from(Image image) {
        return new Images(ImageKit.toBufferedImage(image));
    }

    public static Images from(BufferedImage srcImage, String imageUrl, String fileType) {
        return new Images(srcImage, imageUrl, fileType);
    }

    private static Rectangle calcRotatedSize(int width, int height, int degree) {
        if (degree >= 90) {
            if (degree / 90 % 2 == 1) {
                int temp = height;
                height = width;
                width = temp;
            }
            degree %= 90;
        }
        double r = Math.sqrt(height * height + width * width) / 2.0;
        double len = 2.0 * Math.sin(Math.toRadians(degree) / 2.0) * r;
        double angel_alpha = (Math.PI - Math.toRadians(degree)) / 2.0;
        double angel_dalta_width = Math.atan((double)height / (double)width);
        double angel_dalta_height = Math.atan((double)width / (double)height);
        int len_dalta_width = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_width));
        int len_dalta_height = (int)(len * Math.cos(Math.PI - angel_alpha - angel_dalta_height));
        int des_width = width + len_dalta_width * 2;
        int des_height = height + len_dalta_height * 2;
        return new Rectangle(des_width, des_height);
    }

    public static BufferedImage makeRoundCorner(BufferedImage srcImage, int width, int height, int radius) {
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fillRoundRect(0, 0, width, height, radius, radius);
        g.setComposite(AlphaComposite.SrcIn);
        g.drawImage(srcImage, 0, 0, width, height, null);
        g.dispose();
        return image;
    }

    public static BufferedImage makeBlur(BufferedImage srcImage, int radius) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        if (radius < 1) {
            return srcImage;
        }
        int w = srcImage.getWidth();
        int h = srcImage.getHeight();
        int[] pix = new int[w * h];
        srcImage.getRGB(0, 0, w, h, pix, 0, w);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < h; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        srcImage.setRGB(0, 0, w, h, pix, 0, w);
        return srcImage;
    }

    private BufferedImage draw(BufferedImage backgroundImg, Image image, Rectangle rectangle, float alpha) {
        Graphics2D g = backgroundImg.createGraphics();
        org.aoju.bus.core.lang.Graphics.setAlpha(g, alpha);
        this.fixRectangle(rectangle, backgroundImg.getWidth(), backgroundImg.getHeight());
        org.aoju.bus.core.lang.Graphics.drawImg((Graphics)g, image, rectangle);
        g.dispose();
        return backgroundImg;
    }

    public Images setTargetImageType(String imgType) {
        this.fileType = imgType;
        return this;
    }

    public Images setPositionBaseCentre(boolean positionBaseCentre) {
        this.positionBaseCentre = positionBaseCentre;
        return this;
    }

    public Images setQuality(double quality) {
        return this.setQuality((float)quality);
    }

    public Images setQuality(float quality) {
        this.quality = quality > 0.0f && quality < 1.0f ? quality : 1.0f;
        return this;
    }

    public Images scale(float scale) {
        if (scale < 0.0f) {
            scale = -scale;
        }
        Image srcImg = this.getValidSrcImg();
        if ("png".equals(this.fileType)) {
            double scaleDouble = MathKit.toDouble(Float.valueOf(scale));
            this.targetImage = ImageKit.filter(AffineTransform.getScaleInstance(scaleDouble, scaleDouble), ImageKit.toBufferedImage(srcImg, this.fileType));
        } else {
            int width = MathKit.mul((Number)srcImg.getWidth(null), (Number)Float.valueOf(scale)).intValue();
            int height = MathKit.mul((Number)srcImg.getHeight(null), (Number)Float.valueOf(scale)).intValue();
            this.scale(width, height);
        }
        return this;
    }

    public Images scale(int width, int height) {
        return this.scale(width, height, 4);
    }

    public Images scale(int width, int height, int scaleType) {
        Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        if (srcHeight == height && srcWidth == width) {
            this.targetImage = srcImage;
            return this;
        }
        if ("png".equals(this.fileType)) {
            double sx = MathKit.div((float)width, (float)srcWidth);
            double sy = MathKit.div((float)height, (float)srcHeight);
            this.targetImage = ImageKit.filter(AffineTransform.getScaleInstance(sx, sy), ImageKit.toBufferedImage(srcImage, this.fileType));
        } else {
            this.targetImage = srcImage.getScaledInstance(width, height, scaleType);
        }
        return this;
    }

    public Images scale(int width, int height, Color fixedColor) {
        double widthRatio;
        Image srcImage = this.getValidSrcImg();
        int srcHeight = srcImage.getHeight(null);
        int srcWidth = srcImage.getWidth(null);
        double heightRatio = MathKit.div((float)height, (float)srcHeight);
        if (MathKit.equals(heightRatio, widthRatio = MathKit.div((float)width, (float)srcWidth))) {
            this.scale(width, height);
        } else if (widthRatio < heightRatio) {
            this.scale(width, (int)((double)srcHeight * widthRatio));
        } else {
            this.scale((int)((double)srcWidth * heightRatio), height);
        }
        srcImage = this.getValidSrcImg();
        srcHeight = srcImage.getHeight(null);
        srcWidth = srcImage.getWidth(null);
        BufferedImage image = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D g = image.createGraphics();
        if (null != fixedColor) {
            g.setBackground(fixedColor);
            g.clearRect(0, 0, width, height);
        }
        g.drawImage(srcImage, (width - srcWidth) / 2, (height - srcHeight) / 2, srcWidth, srcHeight, fixedColor, null);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public Images cut(Rectangle rectangle) {
        Image srcImage = this.getValidSrcImg();
        rectangle = this.fixRectangle(rectangle, srcImage.getWidth(null), srcImage.getHeight(null));
        CropImageFilter cropFilter = new CropImageFilter(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.targetImage = ImageKit.filter(cropFilter, srcImage);
        return this;
    }

    public Images cut(int x, int y) {
        return this.cut(x, y, -1);
    }

    public Images cut(int x, int y, int radius) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        int diameter = radius > 0 ? radius * 2 : Math.min(width, height);
        BufferedImage targetImage = new BufferedImage(diameter, diameter, 2);
        Graphics2D g = targetImage.createGraphics();
        g.setClip(new Ellipse2D.Double(0.0, 0.0, diameter, diameter));
        if (this.positionBaseCentre) {
            x = x - width / 2 + diameter / 2;
            y = y - height / 2 + diameter / 2;
        }
        g.drawImage(srcImage, x, y, null);
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images round(double arc) {
        Image srcImage = this.getValidSrcImg();
        int width = srcImage.getWidth(null);
        int height = srcImage.getHeight(null);
        arc = MathKit.mul(arc, (float)Math.min(width, height));
        BufferedImage targetImage = new BufferedImage(width, height, 2);
        Graphics2D g2 = targetImage.createGraphics();
        g2.setComposite(AlphaComposite.Src);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.fill(new RoundRectangle2D.Double(0.0, 0.0, width, height, arc, arc));
        g2.setComposite(AlphaComposite.SrcAtop);
        g2.drawImage(srcImage, 0, 0, null);
        g2.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images gray() {
        this.targetImage = ImageKit.filter(ColorSpace.getInstance(1003), this.getValidSrcBufferedImg());
        return this;
    }

    public Images binary() {
        this.targetImage = ImageKit.copyImage(this.getValidSrcImg(), 12);
        return this;
    }

    public Images pressText(String pressText, Color color, Font font, int x, int y, float alpha) {
        return this.pressText(pressText, color, font, new Point(x, y), alpha);
    }

    public Images pressText(String pressText, Color color, Font font, Point point, float alpha) {
        BufferedImage targetImage = ImageKit.toBufferedImage(this.getValidSrcImg(), this.fileType);
        if (null == font) {
            font = Fonts.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        Graphics2D g = targetImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        if (this.positionBaseCentre) {
            org.aoju.bus.core.lang.Graphics.drawString((Graphics)g, pressText, font, color, new Rectangle(point.x, point.y, targetImage.getWidth(), targetImage.getHeight()));
        } else {
            org.aoju.bus.core.lang.Graphics.drawString((Graphics)g, pressText, font, color, point);
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images pressTextFull(String pressText, Color color, Font font, int lineHeight, int degree, float alpha) {
        Dimension dimension;
        BufferedImage targetImage = ImageKit.toBufferedImage(this.getValidSrcImg(), this.fileType);
        if (null == font) {
            font = Fonts.createSansSerifFont((int)((double)targetImage.getHeight() * 0.75));
        }
        int targetHeight = targetImage.getHeight();
        int targetWidth = targetImage.getWidth();
        Graphics2D g = targetImage.createGraphics();
        g.setColor(color);
        g.rotate(Math.toRadians(degree), targetWidth >> 1, targetHeight >> 1);
        g.setComposite(AlphaComposite.getInstance(10, alpha));
        try {
            dimension = Fonts.getDimension(g.getFontMetrics(font), pressText);
        }
        catch (Exception e) {
            dimension = new Dimension(targetWidth / 3, targetHeight / 3);
        }
        int intervalHeight = dimension.height * lineHeight;
        int y = -targetHeight >> 1;
        while ((double)y < (double)targetHeight * 1.5) {
            int x = -targetWidth >> 1;
            while ((double)x < (double)targetWidth * 1.5) {
                org.aoju.bus.core.lang.Graphics.drawString((Graphics)g, pressText, font, color, new Point(x, y));
                x += dimension.width;
            }
            y += intervalHeight;
        }
        g.dispose();
        this.targetImage = targetImage;
        return this;
    }

    public Images pressImage(Image pressImage, int x, int y, float alpha) {
        int pressImgWidth = pressImage.getWidth(null);
        int pressImgHeight = pressImage.getHeight(null);
        return this.pressImage(pressImage, new Rectangle(x, y, pressImgWidth, pressImgHeight), alpha);
    }

    public Images pressImage(Image pressImage, Rectangle rectangle, float alpha) {
        Image targetImage = this.getValidSrcImg();
        this.targetImage = this.draw(ImageKit.toBufferedImage(targetImage, this.fileType), pressImage, rectangle, alpha);
        return this;
    }

    public Images rotate(int degree) {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Rectangle rectangle = Images.calcRotatedSize(width, height, degree);
        BufferedImage targetImg = new BufferedImage(rectangle.width, rectangle.height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2d.translate((rectangle.width - width) / 2, (rectangle.height - height) / 2);
        graphics2d.rotate(Math.toRadians(degree), width / 2, height / 2);
        graphics2d.drawImage(image, 0, 0, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Images flip() {
        Image image = this.getValidSrcImg();
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage targetImg = new BufferedImage(width, height, this.getTypeInt());
        Graphics2D graphics2d = targetImg.createGraphics();
        graphics2d.drawImage(image, 0, 0, width, height, width, 0, 0, height, null);
        graphics2d.dispose();
        this.targetImage = targetImg;
        return this;
    }

    public Image getImg() {
        return this.getValidSrcImg();
    }

    public boolean write(OutputStream out) throws InstrumentException {
        return this.write(ImageKit.getImageOutputStream(out));
    }

    public boolean write(ImageOutputStream targetImageStream) throws InstrumentException {
        Assert.notBlank(this.fileType, "Target image type is blank !", new Object[0]);
        Assert.notNull(targetImageStream, "Target output stream is null !", new Object[0]);
        Image targetImage = null == this.targetImage ? this.srcImage : this.targetImage;
        Assert.notNull(targetImage, "Target image is null !", new Object[0]);
        return ImageKit.write(targetImage, this.fileType, targetImageStream, this.quality);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write(File targetFile) throws InstrumentException {
        String formatName = FileKit.getSuffix(targetFile);
        if (StringKit.isNotBlank(formatName)) {
            this.fileType = formatName;
        }
        if (targetFile.exists()) {
            targetFile.delete();
        }
        ImageOutputStream out = null;
        try {
            out = ImageKit.getImageOutputStream(targetFile);
            boolean bl = this.write(out);
            return bl;
        }
        finally {
            IoKit.close(out);
        }
    }

    public Images stroke(Color color, float width) {
        return this.stroke(color, new BasicStroke(width));
    }

    public Images stroke(Color color, Stroke stroke) {
        BufferedImage image = ImageKit.toBufferedImage(this.getValidSrcImg(), this.fileType);
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        Graphics2D g = image.createGraphics();
        g.setColor(ObjectKit.defaultIfNull(color, Color.BLACK));
        if (null != stroke) {
            g.setStroke(stroke);
        }
        g.drawRect(0, 0, width - 1, height - 1);
        g.dispose();
        this.targetImage = image;
        return this;
    }

    public BufferedImage merge() throws Exception {
        this.srcImage = new BufferedImage(this.canvasWidth, this.canvasHeight, 1);
        Graphics2D g = this.srcImage.createGraphics();
        if (this.fileType == "png") {
            this.srcImage = g.getDeviceConfiguration().createCompatibleImage(this.canvasWidth, this.canvasHeight, 3);
            g = this.srcImage.createGraphics();
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (AbstractElement element : this.list) {
            Painter painter = PainterFactory.newInstance(element);
            painter.draw(g, element, this.canvasWidth);
        }
        g.dispose();
        if (this.roundCorner != null) {
            this.srcImage = Images.makeRoundCorner(this.srcImage, this.canvasWidth, this.canvasHeight, this.roundCorner);
        }
        return this.srcImage;
    }

    public void out(String filePath) throws Exception {
        if (null == this.srcImage) {
            throw new Exception("\u5c1a\u672a\u6267\u884c\u56fe\u7247\u5408\u6210\uff0c\u65e0\u6cd5\u4fdd\u5b58\u6587\u4ef6");
        }
        ImageIO.write((RenderedImage)this.srcImage, this.fileType, new File(filePath));
    }

    public BufferedImage getBufferedImage() {
        return this.srcImage;
    }

    public InputStream getInputStream() throws Exception {
        if (null != this.srcImage) {
            ByteArrayInputStream byteArrayInputStream;
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)this.srcImage, this.fileType, os);
                byteArrayInputStream = new ByteArrayInputStream(os.toByteArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        os.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new Exception("\u6267\u884c\u56fe\u7247\u5408\u6210\u5931\u8d25\uff0c\u65e0\u6cd5\u8f93\u51fa\u6587\u4ef6\u6d41");
                }
            }
            os.close();
            return byteArrayInputStream;
        }
        throw new Exception("\u5c1a\u672a\u6267\u884c\u56fe\u7247\u5408\u6210\uff0c\u65e0\u6cd5\u8f93\u51fa\u6587\u4ef6\u6d41");
    }

    public int getLineHeight(TextElement textElement) {
        TextPainter textPainter = new TextPainter();
        List<TextElement> textElements = textPainter.getBreakLineElements(textElement);
        return textElement.getLineHeight() * textElements.size();
    }

    public int getFrontWidth(TextElement textElement) {
        TextPainter textPainter = new TextPainter();
        return textPainter.getFrontWidth(textElement.getText(), textElement.getFont());
    }

    public void addElement(AbstractElement element) {
        this.list.add(element);
    }

    public ImageElement addImageElement(String imgUrl, int x, int y) {
        ImageElement imageElement = new ImageElement(imgUrl, x, y);
        this.list.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(BufferedImage image, int x, int y) {
        ImageElement imageElement = new ImageElement(image, x, y);
        this.list.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(String imgUrl, int x, int y, int width, int height, Scale.Mode mode) {
        ImageElement imageElement = new ImageElement(imgUrl, x, y, width, height, mode);
        this.list.add(imageElement);
        return imageElement;
    }

    public ImageElement addImageElement(BufferedImage image, int x, int y, int width, int height, Scale.Mode mode) {
        ImageElement imageElement = new ImageElement(image, x, y, width, height, mode);
        this.list.add(imageElement);
        return imageElement;
    }

    public TextElement addTextElement(String text, Font font, int x, int y) {
        TextElement textElement = new TextElement(text, font, x, y);
        this.list.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontSize, x, y);
        this.list.add(textElement);
        return textElement;
    }

    public TextElement addTextElement(String text, String fontName, int fontSize, int x, int y) {
        TextElement textElement = new TextElement(text, fontName, fontSize, x, y);
        this.list.add(textElement);
        return textElement;
    }

    public RectangleElement addRectangleElement(int x, int y, int width, int height) {
        RectangleElement rectangleElement = new RectangleElement(x, y, width, height);
        this.list.add(rectangleElement);
        return rectangleElement;
    }

    public void setBackgroundBlur(int blur) {
        ImageElement bgElement = (ImageElement)this.list.get(0);
        bgElement.setBlur(blur);
    }

    public void setCanvasRoundCorner(Integer roundCorner) {
        this.roundCorner = roundCorner;
    }

    private int getTypeInt() {
        switch (this.fileType) {
            case "png": {
                return 2;
            }
        }
        return 1;
    }

    private Image getValidSrcImg() {
        return ObjectKit.defaultIfNull(this.targetImage, this.srcImage);
    }

    private BufferedImage getValidSrcBufferedImg() {
        return ImageKit.toBufferedImage(this.getValidSrcImg(), this.fileType);
    }

    private Rectangle fixRectangle(Rectangle rectangle, int baseWidth, int baseHeight) {
        if (this.positionBaseCentre) {
            Point pointBaseCentre = ImageKit.getPointCentre(rectangle, baseWidth, baseHeight);
            rectangle.setLocation(pointBaseCentre.x, pointBaseCentre.y);
        }
        return rectangle;
    }
}

