/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.instance;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.instance.InstanceFactory;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.function.Func0;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;

@ThreadSafe
public final class Instances {
    private static final ConcurrentHashMap<String, Object> POOL = new ConcurrentHashMap();

    private Instances() {
    }

    public static <T> T singletion(Class<T> clazz) {
        return InstanceFactory.getInstance().singleton(clazz);
    }

    public static <T> T singletion(Class<T> clazz, String groupName) {
        return InstanceFactory.getInstance().singleton(clazz, groupName);
    }

    public static <T> T threadLocal(Class<T> clazz) {
        return InstanceFactory.getInstance().threadLocal(clazz);
    }

    public static <T> T threadSafe(Class<T> clazz) {
        return InstanceFactory.getInstance().threadSafe(clazz);
    }

    public static <T> T multiple(Class<T> clazz) {
        return InstanceFactory.getInstance().multiple(clazz);
    }

    public static <T> T singletion(Class<T> clazz, Object ... params) {
        Assert.notNull(clazz, "Class must be not null !", new Object[0]);
        String key = Instances.buildKey(clazz.getName(), params);
        return (T)Instances.singletion(key, () -> ReflectKit.newInstance(clazz, params));
    }

    public static <T> T singletion(String key, Func0<T> supplier) {
        Object value = POOL.get(key);
        if (null == value) {
            POOL.putIfAbsent(key, supplier.callWithRuntimeException());
            value = POOL.get(key);
        }
        return (T)value;
    }

    public static <T> T singletion(String className, Object ... params) {
        Assert.notBlank(className, "Class name must be not blank !", new Object[0]);
        Class clazz = ClassKit.loadClass(className);
        return Instances.singletion(clazz, params);
    }

    public static void put(Object obj) {
        Assert.notNull(obj, "Bean object must be not null !", new Object[0]);
        Instances.put(obj.getClass().getName(), obj);
    }

    public static void put(String key, Object obj) {
        POOL.put(key, obj);
    }

    public static boolean exists(Class<?> clazz, Object ... params) {
        if (null != clazz) {
            String key = Instances.buildKey(clazz.getName(), params);
            return POOL.containsKey(key);
        }
        return false;
    }

    public static Set<Class<?>> getExistClass() {
        return POOL.values().stream().map(Object::getClass).collect(Collectors.toSet());
    }

    public static void remove(Class<?> clazz) {
        if (null != clazz) {
            Instances.remove(clazz.getName());
        }
    }

    public static void remove(String key) {
        POOL.remove(key);
    }

    public static void destroy() {
        POOL.clear();
    }

    public static String buildKey(String className, Object ... params) {
        if (ArrayKit.isEmpty(params)) {
            return className;
        }
        return StringKit.format((CharSequence)"{}#{}", className, ArrayKit.join(params, (CharSequence)"_"));
    }
}

