/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.aoju.bus.core.io.file.FileWriter;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ThreadKit;

public class FileAppender
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final FileWriter writer;
    private final int capacity;
    private final boolean isNewLineMode;
    private final List<String> list;
    private final Lock lock;

    public FileAppender(File destFile, int capacity, boolean isNewLineMode) {
        this(destFile, Charset.UTF_8, capacity, isNewLineMode);
    }

    public FileAppender(File destFile, java.nio.charset.Charset charset, int capacity, boolean isNewLineMode) {
        this(destFile, charset, capacity, isNewLineMode, null);
    }

    public FileAppender(File destFile, java.nio.charset.Charset charset, int capacity, boolean isNewLineMode, Lock lock) {
        this.capacity = capacity;
        this.list = new ArrayList<String>(capacity);
        this.isNewLineMode = isNewLineMode;
        this.writer = FileWriter.create(destFile, charset);
        this.lock = ObjectKit.defaultIfNull(lock, ThreadKit::getNoLock);
    }

    public FileAppender append(String line) {
        if (this.list.size() >= this.capacity) {
            this.flush();
        }
        this.lock.lock();
        try {
            this.list.add(line);
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileAppender flush() {
        this.lock.lock();
        try {
            try (PrintWriter pw = this.writer.getPrintWriter(true);){
                for (String str : this.list) {
                    pw.print(str);
                    if (!this.isNewLineMode) continue;
                    pw.println();
                }
            }
            this.list.clear();
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }
}

