/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.LineHandler;
import org.aoju.bus.core.io.file.FileMode;
import org.aoju.bus.core.io.file.LineReadWatcher;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.toolkit.FileKit;

public class Tailer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final java.nio.charset.Charset charset;
    private final LineHandler lineHandler;
    private final int initReadLine;
    private final long period;
    private final RandomAccessFile randomAccessFile;
    private final ScheduledExecutorService executorService;

    public Tailer(File file, LineHandler lineHandler) {
        this(file, lineHandler, 0);
    }

    public Tailer(File file, LineHandler lineHandler, int initReadLine) {
        this(file, Charset.UTF_8, lineHandler, initReadLine, Fields.Units.SECOND.getUnit());
    }

    public Tailer(File file, java.nio.charset.Charset charset, LineHandler lineHandler) {
        this(file, charset, lineHandler, 0, Fields.Units.SECOND.getUnit());
    }

    public Tailer(File file, java.nio.charset.Charset charset, LineHandler lineHandler, int initReadLine, long period) {
        Tailer.checkFile(file);
        this.charset = charset;
        this.lineHandler = lineHandler;
        this.period = period;
        this.initReadLine = initReadLine;
        this.randomAccessFile = FileKit.createRandomAccessFile(file, FileMode.r);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new InstrumentException("File [{}] not exist !", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new InstrumentException("Path [{}] is not a file !", file.getAbsolutePath());
        }
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean async) {
        try {
            this.readTail();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        LineReadWatcher lineReadWatcher = new LineReadWatcher(this.randomAccessFile, this.charset, this.lineHandler);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(lineReadWatcher, 0L, this.period, TimeUnit.MILLISECONDS);
        if (!async) {
            try {
                scheduledFuture.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new InstrumentException(e);
            }
        }
    }

    public void stop() {
        this.executorService.shutdown();
    }

    private void readTail() throws IOException {
        long len = this.randomAccessFile.length();
        if (this.initReadLine > 0) {
            Stack<String> stack = new Stack<String>();
            long start = this.randomAccessFile.getFilePointer();
            long nextEnd = len - 1L < 0L ? 0L : len - 1L;
            this.randomAccessFile.seek(nextEnd);
            int currentLine = 0;
            while (nextEnd > start && currentLine <= this.initReadLine) {
                String line;
                int c = this.randomAccessFile.read();
                if (c == 10 || c == 13) {
                    line = FileKit.readLine(this.randomAccessFile, this.charset);
                    if (null != line) {
                        stack.push(line);
                    }
                    ++currentLine;
                    --nextEnd;
                }
                this.randomAccessFile.seek(--nextEnd);
                if (nextEnd != 0L) continue;
                line = FileKit.readLine(this.randomAccessFile, this.charset);
                if (null == line) break;
                stack.push(line);
                break;
            }
            while (!stack.isEmpty()) {
                this.lineHandler.handle((String)stack.pop());
            }
        }
        try {
            this.randomAccessFile.seek(len);
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public static class ConsoleLineHandler
    implements LineHandler {
        @Override
        public void handle(String line) {
            Console.log(line);
        }
    }
}

