/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.resource;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class CharSequenceResource
implements Resource {
    private final CharSequence data;
    private final CharSequence name;
    private final java.nio.charset.Charset charset;

    public CharSequenceResource(CharSequence data) {
        this(data, null);
    }

    public CharSequenceResource(CharSequence data, String name) {
        this(data, name, Charset.UTF_8);
    }

    public CharSequenceResource(CharSequence data, CharSequence name, java.nio.charset.Charset charset) {
        this.data = data;
        this.name = name;
        this.charset = charset;
    }

    @Override
    public String getName() {
        return StringKit.toString(this.name);
    }

    @Override
    public URL getUrl() {
        return null;
    }

    @Override
    public InputStream getStream() {
        return new ByteArrayInputStream(this.readBytes());
    }

    @Override
    public BufferedReader getReader(java.nio.charset.Charset charset) {
        return IoKit.getReader(new StringReader(this.data.toString()));
    }

    @Override
    public String readString(java.nio.charset.Charset charset) throws InstrumentException {
        return this.data.toString();
    }

    @Override
    public byte[] readBytes() throws InstrumentException {
        return this.data.toString().getBytes(this.charset);
    }
}

