/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aoju.bus.core.exception.ValidateException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.CitizenIdKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Validator {
    public static boolean isNull(Object value) {
        return null == value;
    }

    public static boolean isNotNull(Object value) {
        return null != value;
    }

    public static <T> T validateNotNull(T value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isNull(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return value;
    }

    public static boolean isEmpty(Object value) {
        return null == value || value instanceof String && StringKit.isEmpty((String)value);
    }

    public static boolean isNotEmpty(Object value) {
        return false == Validator.isEmpty(value);
    }

    public static void validateNotEmpty(Object value, String errorMsg) throws ValidateException {
        if (Validator.isEmpty(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isTrue(boolean value) {
        return value;
    }

    public static boolean isFalse(boolean value) {
        return false == value;
    }

    public static boolean validateTrue(boolean value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isFalse(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return value;
    }

    public static boolean validateFalse(boolean value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isTrue(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return value;
    }

    public static boolean equal(Object t1, Object t2) {
        return ObjectKit.equal(t1, t2);
    }

    public static void validateEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (!Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static void validateNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static void validateNotEmptyAndEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateEqual(t1, t2, errorMsg);
    }

    public static void validateNotEmptyAndNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateNotEqual(t1, t2, errorMsg);
    }

    public static boolean isMatchRegex(Pattern pattern, CharSequence value) {
        return PatternKit.isMatch(pattern, value);
    }

    public static boolean isMatchRegex(String regex, CharSequence value) {
        return PatternKit.isMatch(regex, value);
    }

    public static void validateMatchRegex(String regex, String value, String errorMsg) throws ValidateException {
        if (!Validator.isMatchRegex(regex, (CharSequence)value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneral(String value) {
        return Validator.isMatchRegex(RegEx.GENERAL, (CharSequence)value);
    }

    public static void validateGeneral(String value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        String reg = "^\\w{" + min + "," + max + "}$";
        if (max <= 0) {
            reg = "^\\w{" + min + ",}$";
        }
        return Validator.isMatchRegex(reg, (CharSequence)value);
    }

    public static void validateGeneral(String value, int min, int max, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value, min, max)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isGeneral(String value, int min) {
        return Validator.isGeneral(value, min, 0);
    }

    public static void validateGeneral(String value, int min, String errorMsg) throws ValidateException {
        Validator.validateGeneral(value, min, 0, errorMsg);
    }

    public static boolean isLetter(String value) {
        return StringKit.isAllCharMatch(value, Character::isLetter);
    }

    public static void validateLetter(String value, String errorMsg) throws ValidateException {
        if (!Validator.isLetter(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUpperCase(String value) {
        return StringKit.isAllCharMatch(value, Character::isUpperCase);
    }

    public static void validateUpperCase(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUpperCase(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isLowerCase(String value) {
        return StringKit.isAllCharMatch(value, t -> Character.isLowerCase(t.charValue()));
    }

    public static void validateLowerCase(String value, String errorMsg) throws ValidateException {
        if (!Validator.isLowerCase(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isNumber(String value) {
        return MathKit.isNumber(value);
    }

    public static boolean hasNumber(CharSequence value) {
        return PatternKit.contains(RegEx.NUMBERS, value);
    }

    public static void validateNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.isNumber(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isWord(String value) {
        return Validator.isMatchRegex(RegEx.WORD, (CharSequence)value);
    }

    public static void validateWord(String value, String errorMsg) throws ValidateException {
        if (!Validator.isWord(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMoney(String value) {
        return Validator.isMatchRegex(RegEx.MONEY, (CharSequence)value);
    }

    public static void validateMoney(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMoney(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isZipCode(String value) {
        return Validator.isMatchRegex(RegEx.ZIP_CODE, (CharSequence)value);
    }

    public static void validateZipCode(String value, String errorMsg) throws ValidateException {
        if (!Validator.isZipCode(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isEmail(String value) {
        return Validator.isMatchRegex(RegEx.EMAIL, (CharSequence)value);
    }

    public static void validateEmail(String value, String errorMsg) throws ValidateException {
        if (!Validator.isEmail(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isPhone(String value) {
        return Validator.isMatchRegex(RegEx.PHONE, (CharSequence)value);
    }

    public static boolean isMobile(String value) {
        return Validator.isMatchRegex(RegEx.MOBILE, (CharSequence)value);
    }

    public static boolean isMobileHk(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE_HK, value);
    }

    public static boolean isMobileTw(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE_TW, value);
    }

    public static boolean isMobileMo(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE_MO, value);
    }

    public static boolean isTel400800(CharSequence value) {
        return Validator.isMatchRegex(RegEx.PHONE_400_800, value);
    }

    public static void validateMobile(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMobile(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isCitizenId(CharSequence value) {
        return CitizenIdKit.isValidCard(String.valueOf(value));
    }

    public static <T extends CharSequence> T validateCitizenIdNumber(T value, String errorMsg) throws ValidateException {
        if (!Validator.isCitizenId(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isBirthday(int year, int month, int day) {
        int thisYear = DateKit.thisYear();
        if (year < 1900 || year > thisYear) {
            return false;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        if (day < 1 || day > 31) {
            return false;
        }
        if (day == 31 && (month == 4 || month == 6 || month == 9 || month == 11)) {
            return false;
        }
        if (month == 2) {
            return day < 29 || day == 29 && DateKit.isLeapYear(year);
        }
        return true;
    }

    public static boolean isBirthday(String value) {
        Matcher matcher;
        if (Validator.isMatchRegex(RegEx.BIRTHDAY, (CharSequence)value) && (matcher = RegEx.BIRTHDAY.matcher(value)).find()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(3));
            int day = Integer.parseInt(matcher.group(5));
            return Validator.isBirthday(year, month, day);
        }
        return false;
    }

    public static void validateBirthday(String value, String errorMsg) throws ValidateException {
        if (!Validator.isBirthday(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isIpv4(String value) {
        return Validator.isMatchRegex(RegEx.IPV4, (CharSequence)value);
    }

    public static void validateIpv4(String value, String errorMsg) throws ValidateException {
        if (!Validator.isIpv4(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isIpv6(CharSequence value) {
        return Validator.isMatchRegex(RegEx.IPV6, value);
    }

    public static <T extends CharSequence> T validateIpv6(T value, String errorMsg) throws ValidateException {
        if (!Validator.isIpv6(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isMac(String value) {
        return Validator.isMatchRegex(RegEx.MAC_ADDRESS, (CharSequence)value);
    }

    public static void validateMac(String value, String errorMsg) throws ValidateException {
        if (!Validator.isMac(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isPlateNumber(String value) {
        return Validator.isMatchRegex(RegEx.PLATE_NUMBER, (CharSequence)value);
    }

    public static void validatePlateNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.isPlateNumber(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUrl(String value) {
        if (StringKit.isBlank(value)) {
            return false;
        }
        try {
            new URL(value);
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static void validateUrl(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUrl(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isEnglish(String value) {
        return Validator.isMatchRegex("^[a-zA-Z]++$", (CharSequence)value);
    }

    public static void validateEnglish(String value, String errorMsg) throws ValidateException {
        if (!Validator.isEnglish(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isChinese(CharSequence value) {
        return Validator.isMatchRegex("^[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]+$", value);
    }

    public static <T extends CharSequence> T validateChinese(T value, String errorMsg) throws ValidateException {
        if (!Validator.isChinese(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isGeneralWithChinese(String value) {
        return Validator.isMatchRegex(RegEx.GENERAL_WITH_CHINESE, (CharSequence)value);
    }

    public static void validateGeneralWithChinese(String value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneralWithChinese(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isUUID(String value) {
        return Validator.isMatchRegex(RegEx.UUID, (CharSequence)value) || Validator.isMatchRegex(RegEx.UUID_SIMPLE, (CharSequence)value);
    }

    public static void validateUUID(String value, String errorMsg) throws ValidateException {
        if (!Validator.isUUID(value)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isBetween(Number value, Number min, Number max) {
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double doubleValue = value.doubleValue();
        return doubleValue >= min.doubleValue() && doubleValue <= max.doubleValue();
    }

    public static void validateBetween(Number value, Number min, Number max, String errorMsg) throws ValidateException {
        if (!Validator.isBetween(value, min, max)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isHex(CharSequence value) {
        return Validator.isMatchRegex(RegEx.HEX, value);
    }

    public static <T extends CharSequence> T validateHex(T value, String errorMsg) throws ValidateException {
        if (!Validator.isHex(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isPassword(String value, boolean ... weak) {
        boolean result = false;
        for (boolean element : weak) {
            result ^= element;
        }
        return result ? Validator.isMatchRegex(RegEx.PASSWORD_WEAK, (CharSequence)value) : Validator.isMatchRegex(RegEx.PASSWORD_STRONG, (CharSequence)value);
    }

    public static void validatePassword(String value, String errorMsg, boolean ... weak) throws ValidateException {
        if (!Validator.isPassword(value, weak)) {
            throw new ValidateException(errorMsg);
        }
    }
}

