/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.tree;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Filter;
import org.aoju.bus.core.lang.tree.Node;
import org.aoju.bus.core.lang.tree.NodeConfig;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.TreeKit;

public class Tree<T>
extends LinkedHashMap<String, Object>
implements Node<T> {
    private static final long serialVersionUID = 1L;
    private final NodeConfig nodeConfig;
    private Tree<T> parent;

    public Tree() {
        this((NodeConfig)null);
    }

    public Tree(NodeConfig nodeConfig) {
        this.nodeConfig = ObjectKit.defaultIfNull(nodeConfig, NodeConfig.DEFAULT_CONFIG);
    }

    private static void printTree(Tree<?> tree, PrintWriter writer, int intent) {
        writer.println(StringKit.format((CharSequence)"{}{}[{}]", StringKit.repeat(" ", intent), tree.getName(), tree.getId()));
        writer.flush();
        List<Tree<?>> children = tree.getChildren();
        if (CollKit.isNotEmpty(children)) {
            for (Tree<?> child : children) {
                Tree.printTree(child, writer, intent + 2);
            }
        }
    }

    public NodeConfig getConfig() {
        return this.nodeConfig;
    }

    public Tree<T> getParent() {
        return this.parent;
    }

    public Tree<T> setParent(Tree<T> parent) {
        this.parent = parent;
        if (null != parent) {
            this.setParentId((Object)parent.getId());
        }
        return this;
    }

    public Tree<T> getNode(T id) {
        return TreeKit.getNode(this, id);
    }

    public List<CharSequence> getParentsName(T id, boolean includeCurrentNode) {
        return TreeKit.getParentsName(this.getNode(id), includeCurrentNode);
    }

    public List<CharSequence> getParentsName(boolean includeCurrentNode) {
        return TreeKit.getParentsName(this, includeCurrentNode);
    }

    @Override
    public T getId() {
        return (T)this.get(this.nodeConfig.getIdKey());
    }

    @Override
    public Tree<T> setId(T id) {
        this.put(this.nodeConfig.getIdKey(), id);
        return this;
    }

    @Override
    public T getParentId() {
        return (T)this.get(this.nodeConfig.getParentIdKey());
    }

    @Override
    public Tree<T> setParentId(T parentId) {
        this.put(this.nodeConfig.getParentIdKey(), parentId);
        return this;
    }

    @Override
    public CharSequence getName() {
        return (CharSequence)this.get(this.nodeConfig.getNameKey());
    }

    @Override
    public Tree<T> setName(CharSequence name) {
        this.put(this.nodeConfig.getNameKey(), name);
        return this;
    }

    @Override
    public Comparable<?> getWeight() {
        return (Comparable)this.get(this.nodeConfig.getWeightKey());
    }

    @Override
    public Tree<T> setWeight(Comparable<?> weight) {
        this.put(this.nodeConfig.getWeightKey(), weight);
        return this;
    }

    public List<Tree<T>> getChildren() {
        return (List)this.get(this.nodeConfig.getChildrenKey());
    }

    public Tree<T> setChildren(List<Tree<T>> children) {
        if (null == children) {
            this.remove(this.nodeConfig.getChildrenKey());
        }
        this.put(this.nodeConfig.getChildrenKey(), children);
        return this;
    }

    @SafeVarargs
    public final Tree<T> addChildren(Tree<T> ... children) {
        if (ArrayKit.isNotEmpty(children)) {
            List<Tree<T>> childrenList = this.getChildren();
            if (null == childrenList) {
                childrenList = new ArrayList<Tree<T>>();
                this.setChildren(childrenList);
            }
            for (Tree<T> child : children) {
                child.setParent(this);
                childrenList.add(child);
            }
        }
        return this;
    }

    public boolean hasChild() {
        return CollKit.isNotEmpty(this.getChildren());
    }

    public void putExtra(String key, Object value) {
        Assert.notEmpty(key, "Key must be not empty !", new Object[0]);
        this.put(key, value);
    }

    public void walk(Consumer<Tree<T>> consumer) {
        consumer.accept(this);
        List<Tree<Tree>> children = this.getChildren();
        if (CollKit.isNotEmpty(children)) {
            children.forEach((? super T tree) -> tree.walk(consumer));
        }
    }

    public Tree<T> filterNew(Filter<Tree<T>> filter) {
        return this.cloneTree().filter(filter);
    }

    public Tree<T> filter(Filter<Tree<T>> filter) {
        if (filter.accept(this)) {
            return this;
        }
        List<Tree<T>> children = this.getChildren();
        if (CollKit.isNotEmpty(children)) {
            ArrayList<Tree<T>> filteredChildren = new ArrayList<Tree<T>>(children.size());
            for (Tree<Tree<Tree>> tree : children) {
                Tree<T> filteredChild = tree.filter(filter);
                if (null == filteredChild) continue;
                filteredChildren.add(filteredChild);
            }
            if (CollKit.isNotEmpty(filteredChildren)) {
                return this.setChildren(filteredChildren);
            }
            this.setChildren(null);
        }
        return null;
    }

    public Tree<T> cloneTree() {
        Tree result = ObjectKit.clone(this);
        result.setChildren(this.cloneChildren());
        return result;
    }

    private List<Tree<T>> cloneChildren() {
        List<Tree<Tree>> children = this.getChildren();
        if (null == children) {
            return null;
        }
        ArrayList newChildren = new ArrayList(children.size());
        children.forEach((? super T t) -> newChildren.add(t.cloneTree()));
        return newChildren;
    }

    @Override
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        Tree.printTree(this, new PrintWriter(stringWriter), 0);
        return stringWriter.toString();
    }
}

