/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lock;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lock.LockHandler;

public class ObjWithLock<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ReentrantReadWriteLock lock;
    private T obj;

    public ObjWithLock(T obj) {
        this(obj, new ReentrantReadWriteLock());
    }

    public ObjWithLock(T obj, ReentrantReadWriteLock lock) {
        this.obj = obj;
        this.lock = lock;
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    public T getObj() {
        return this.obj;
    }

    public void setObj(T obj) {
        this.obj = obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(LockHandler<T> readLockHandler) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            readLockHandler.read(this.obj);
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LockHandler<T> writeLockHandler) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            writeLockHandler.write(this.obj);
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }
}

