/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.replacer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.core.text.TextBuilder;
import org.aoju.bus.core.text.replacer.TextReplacer;

public class LookupReplacer
extends TextReplacer {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> lookupMap = new HashMap<String, String>();
    private final Set<Character> prefixSet = new HashSet<Character>();
    private final int minLength;
    private final int maxLength;

    public LookupReplacer(String[] ... lookup) {
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        for (String[] pair : lookup) {
            String key = pair[0];
            this.lookupMap.put(key, pair[1]);
            this.prefixSet.add(Character.valueOf(key.charAt(0)));
            int keySize = key.length();
            if (keySize > maxLength) {
                maxLength = keySize;
            }
            if (keySize >= minLength) continue;
            minLength = keySize;
        }
        this.maxLength = maxLength;
        this.minLength = minLength;
    }

    @Override
    protected int replace(CharSequence text, int indexes, TextBuilder builder) {
        if (this.prefixSet.contains(Character.valueOf(text.charAt(indexes)))) {
            int max = this.maxLength;
            if (indexes + this.maxLength > text.length()) {
                max = text.length() - indexes;
            }
            for (int i = max; i >= this.minLength; --i) {
                CharSequence subSeq = text.subSequence(indexes, indexes + i);
                String result = this.lookupMap.get(subSeq.toString());
                if (null == result) continue;
                builder.append(result);
                return i;
            }
        }
        return 0;
    }
}

