/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.file;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.io.file.FileWrapper;
import org.aoju.bus.core.io.file.LineSeparator;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class FileWriter
extends FileWrapper {
    public FileWriter(File file, java.nio.charset.Charset charset) {
        super(file, charset);
        this.checkFile();
    }

    public FileWriter(File file, String charset) {
        this(file, Charset.charset(charset));
    }

    public FileWriter(String filePath, java.nio.charset.Charset charset) {
        this(FileKit.file(filePath), charset);
    }

    public FileWriter(String filePath, String charset) {
        this(FileKit.file(filePath), Charset.charset(charset));
    }

    public FileWriter(File file) {
        this(file, DEFAULT_CHARSET);
    }

    public FileWriter(String filePath) {
        this(filePath, DEFAULT_CHARSET);
    }

    public static FileWriter create(File file, java.nio.charset.Charset charset) {
        return new FileWriter(file, charset);
    }

    public static FileWriter create(File file) {
        return new FileWriter(file);
    }

    public File write(String content, boolean isAppend) throws InstrumentException {
        BufferedWriter writer = null;
        try {
            writer = this.getWriter(isAppend);
            writer.write(content);
            writer.flush();
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
        finally {
            IoKit.close(writer);
        }
        return this.file;
    }

    public File write(String content) throws InstrumentException {
        return this.write(content, false);
    }

    public File append(String content) throws InstrumentException {
        return this.write(content, true);
    }

    public <T> File writeLines(Iterable<T> list) throws InstrumentException {
        return this.writeLines(list, false);
    }

    public <T> File appendLines(Iterable<T> list) throws InstrumentException {
        return this.writeLines(list, true);
    }

    public <T> File writeLines(Iterable<T> list, boolean isAppend) throws InstrumentException {
        return this.writeLines(list, null, isAppend);
    }

    public <T> File writeLines(Iterable<T> list, LineSeparator lineSeparator, boolean isAppend) throws InstrumentException {
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            boolean isFirst = true;
            for (T t : list) {
                if (null == t) continue;
                if (isFirst) {
                    isFirst = false;
                    if (isAppend && FileKit.isNotEmpty(this.file)) {
                        this.printNewLine(writer, lineSeparator);
                    }
                } else {
                    this.printNewLine(writer, lineSeparator);
                }
                writer.print(t);
                writer.flush();
            }
        }
        return this.file;
    }

    public File writeMap(Map<?, ?> map, String kvSeparator, boolean isAppend) throws InstrumentException {
        return this.writeMap(map, null, kvSeparator, isAppend);
    }

    public File writeMap(Map<?, ?> map, LineSeparator lineSeparator, String kvSeparator, boolean isAppend) throws InstrumentException {
        if (null == kvSeparator) {
            kvSeparator = " = ";
        }
        try (PrintWriter writer = this.getPrintWriter(isAppend);){
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                if (null == entry) continue;
                writer.print(StringKit.format((CharSequence)"{}{}{}", entry.getKey(), kvSeparator, entry.getValue()));
                this.printNewLine(writer, lineSeparator);
                writer.flush();
            }
        }
        return this.file;
    }

    public File write(byte[] data, int off, int len) throws InstrumentException {
        return this.write(data, off, len, false);
    }

    public File append(byte[] data, int off, int len) throws InstrumentException {
        return this.write(data, off, len, true);
    }

    public File write(byte[] data, int off, int len, boolean isAppend) throws InstrumentException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileKit.touch(this.file), isAppend);
            out.write(data, off, len);
            out.flush();
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(out);
                throw throwable;
            }
        }
        IoKit.close(out);
        return this.file;
    }

    public File writeFromStream(InputStream in) throws InstrumentException {
        return this.writeFromStream(in, true);
    }

    public File writeFromStream(InputStream in, boolean isClose) throws InstrumentException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileKit.touch(this.file));
            IoKit.copy(in, out);
        }
        catch (IOException e) {
            try {
                throw new InstrumentException(e);
            }
            catch (Throwable throwable) {
                IoKit.close(out);
                if (isClose) {
                    IoKit.close(in);
                }
                throw throwable;
            }
        }
        IoKit.close(out);
        if (isClose) {
            IoKit.close(in);
        }
        return this.file;
    }

    public BufferedOutputStream getOutputStream() throws InstrumentException {
        try {
            return new BufferedOutputStream(new FileOutputStream(FileKit.touch(this.file)));
        }
        catch (IOException e) {
            throw new InstrumentException(e);
        }
    }

    public BufferedWriter getWriter(boolean isAppend) throws InstrumentException {
        try {
            return new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(FileKit.touch(this.file), isAppend), this.charset));
        }
        catch (Exception e) {
            throw new InstrumentException(e);
        }
    }

    public PrintWriter getPrintWriter(boolean isAppend) throws InstrumentException {
        return new PrintWriter(this.getWriter(isAppend));
    }

    private void checkFile() throws InstrumentException {
        Assert.notNull(this.file, "File to write content is null !", new Object[0]);
        if (this.file.exists() && !this.file.isFile()) {
            throw new InstrumentException("File [{}] is not a file !", this.file.getAbsoluteFile());
        }
    }

    private void printNewLine(PrintWriter writer, LineSeparator lineSeparator) {
        if (null == lineSeparator) {
            writer.println();
        } else {
            writer.print(lineSeparator.getValue());
        }
    }
}

