/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.key;

import java.io.Serializable;
import java.util.Date;
import org.aoju.bus.core.date.NonClock;
import org.aoju.bus.core.key.ID;
import org.aoju.bus.core.toolkit.StringKit;

public class Snowflake
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final long WORKER_ID_BITS = 5L;
    private static final long DATA_CENTER_ID_BITS = 5L;
    private static final long MAX_WORKER_ID = 31L;
    private static final long MAX_DATA_CENTER_ID = 31L;
    private static final long SEQUENCE_BITS = 12L;
    private static final long WORKER_ID_SHIFT = 12L;
    private static final long DATA_CENTER_ID_SHIFT = 17L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long SEQUENCE_MASK = 4095L;
    private final long startTime;
    private final long workerId;
    private final long dataCenterId;
    private final boolean isClock;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public Snowflake() {
        this(ID.getWorkerId(ID.getDataCenterId(31L), 31L));
    }

    public Snowflake(long workerId) {
        this(workerId, ID.getDataCenterId(31L));
    }

    public Snowflake(long workerId, long dataCenterId) {
        this(workerId, dataCenterId, false);
    }

    public Snowflake(long workerId, long dataCenterId, boolean isClock) {
        this(null, workerId, dataCenterId, isClock);
    }

    public Snowflake(Date epochDate, long workerId, long dataCenterId, boolean isClock) {
        this.startTime = null != epochDate ? epochDate.getTime() : 1288834974657L;
        if (workerId > 31L || workerId < 0L) {
            throw new IllegalArgumentException(StringKit.format((CharSequence)"worker Id can't be greater than {} or less than 0", 31L));
        }
        if (dataCenterId > 31L || dataCenterId < 0L) {
            throw new IllegalArgumentException(StringKit.format((CharSequence)"datacenter Id can't be greater than {} or less than 0", 31L));
        }
        this.workerId = workerId;
        this.dataCenterId = dataCenterId;
        this.isClock = isClock;
    }

    public long getWorkerId(long id) {
        return id >> 12 & 0x1FL;
    }

    public long getDataCenterId(long id) {
        return id >> 17 & 0x1FL;
    }

    public long getGenerateDateTime(long id) {
        return (id >> 22 & 0x1FFFFFFFFFFL) + this.startTime;
    }

    public synchronized long nextId() {
        long timestamp = this.genTime();
        if (timestamp < this.lastTimestamp) {
            if (this.lastTimestamp - timestamp < 2000L) {
                timestamp = this.lastTimestamp;
            } else {
                throw new IllegalStateException(StringKit.format((CharSequence)"Clock moved backwards. Refusing to generate id for {}ms", this.lastTimestamp - timestamp));
            }
        }
        if (timestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.startTime << 22 | this.dataCenterId << 17 | this.workerId << 12 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.genTime();
        while (timestamp <= lastTimestamp) {
            timestamp = this.genTime();
        }
        return timestamp;
    }

    private long genTime() {
        return this.isClock ? NonClock.now() : System.currentTimeMillis();
    }
}

