/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.io.File;
import java.nio.charset.UnsupportedCharsetException;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Charset {
    public static final java.nio.charset.Charset DEFAULT = java.nio.charset.Charset.defaultCharset();
    public static final String DEFAULT_CHARSET = DEFAULT.displayName();
    public static final String DEFAULT_ISO_8859_1 = "ISO-8859-1";
    public static final java.nio.charset.Charset ISO_8859_1 = java.nio.charset.Charset.forName("ISO-8859-1");
    public static final String DEFAULT_US_ASCII = "US-ASCII";
    public static final java.nio.charset.Charset US_ASCII = java.nio.charset.Charset.forName("US-ASCII");
    public static final String DEFAULT_GBK = "GBK";
    public static final java.nio.charset.Charset GBK = java.nio.charset.Charset.forName("GBK");
    public static final String DEFAULT_GB_2312 = "GB2312";
    public static final java.nio.charset.Charset GB_2312 = java.nio.charset.Charset.forName("GB2312");
    public static final String DEFAULT_GB_18030 = "GB18030";
    public static final java.nio.charset.Charset GB_18030 = java.nio.charset.Charset.forName("GB18030");
    public static final String DEFAULT_UTF_8 = "UTF-8";
    public static final java.nio.charset.Charset UTF_8 = java.nio.charset.Charset.forName("UTF-8");
    public static final String DEFAULT_UTF_16 = "UTF-16";
    public static final java.nio.charset.Charset UTF_16 = java.nio.charset.Charset.forName("UTF-16");
    public static final String DEFAULT_UTF_16_BE = "UTF-16BE";
    public static final java.nio.charset.Charset UTF_16_BE = java.nio.charset.Charset.forName("UTF-16BE");
    public static final String DEFAULT_UTF_16_LE = "UTF-16LE";
    public static final java.nio.charset.Charset UTF_16_LE = java.nio.charset.Charset.forName("UTF-16LE");
    public static final String DEFAULT_UTF_32_BE = "UTF-32BE";
    public static final java.nio.charset.Charset UTF_32_BE = java.nio.charset.Charset.forName("UTF-32BE");
    public static final String DEFAULT_UTF_32_LE = "UTF-32LE";
    public static final java.nio.charset.Charset UTF_32_LE = java.nio.charset.Charset.forName("UTF-32LE");

    public static java.nio.charset.Charset defaultCharset() {
        return java.nio.charset.Charset.defaultCharset();
    }

    public static String defaultCharsetName() {
        return Charset.defaultCharset().name();
    }

    public static java.nio.charset.Charset systemCharset() {
        return FileKit.isWindows() ? GBK : Charset.defaultCharset();
    }

    public static String systemCharsetName() {
        return Charset.systemCharset().name();
    }

    public static java.nio.charset.Charset charset(java.nio.charset.Charset charset) {
        return ObjectKit.isEmpty(charset) ? java.nio.charset.Charset.defaultCharset() : charset;
    }

    public static java.nio.charset.Charset charset(String charsetName) {
        return StringKit.isBlank(charsetName) ? java.nio.charset.Charset.defaultCharset() : java.nio.charset.Charset.forName(charsetName);
    }

    public static String convert(String source, String srcCharset, String destCharset) {
        return Charset.convert(source, java.nio.charset.Charset.forName(srcCharset), java.nio.charset.Charset.forName(destCharset));
    }

    public static String convert(String source, java.nio.charset.Charset srcCharset, java.nio.charset.Charset destCharset) {
        if (null == srcCharset) {
            srcCharset = ISO_8859_1;
        }
        if (null == destCharset) {
            destCharset = UTF_8;
        }
        if (StringKit.isBlank(source) || srcCharset.equals(destCharset)) {
            return source;
        }
        return new String(source.getBytes(srcCharset), destCharset);
    }

    public static File convert(File file, java.nio.charset.Charset srcCharset, java.nio.charset.Charset destCharset) {
        String text = FileKit.readString(file, srcCharset);
        return FileKit.writeString(text, file, destCharset);
    }

    public static java.nio.charset.Charset parse(String charsetName) {
        return Charset.parse(charsetName, java.nio.charset.Charset.defaultCharset());
    }

    public static java.nio.charset.Charset parse(String charsetName, java.nio.charset.Charset defaultCharset) {
        java.nio.charset.Charset result;
        if (StringKit.isBlank(charsetName)) {
            return defaultCharset;
        }
        try {
            result = java.nio.charset.Charset.forName(charsetName);
        }
        catch (UnsupportedCharsetException e) {
            result = defaultCharset;
        }
        return result;
    }
}

