/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.map.WeakMap;
import org.aoju.bus.core.toolkit.TypeKit;

public class ActualTypeMapper {
    private static final WeakMap<Type, Map<Type, Type>> CACHE = new WeakMap();

    public static Map<Type, Type> get(Type type) {
        return CACHE.computeIfAbsent(type, () -> ActualTypeMapper.createTypeMap(type));
    }

    public static Map<String, Type> getStringKeyMap(Type type) {
        return Convert.toMap(String.class, Type.class, ActualTypeMapper.get(type));
    }

    public static Type getActualType(Type type, TypeVariable<?> typeVariable) {
        Map<Type, Type> typeTypeMap = ActualTypeMapper.get(type);
        Type result = typeTypeMap.get(typeVariable);
        while (result instanceof TypeVariable) {
            result = typeTypeMap.get(result);
        }
        return result;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        Type[] result = new Type[typeVariables.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            result[i] = typeVariables[i] instanceof TypeVariable ? ActualTypeMapper.getActualType(type, (TypeVariable)typeVariables[i]) : typeVariables[i];
        }
        return result;
    }

    private static Map<Type, Type> createTypeMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (null != type && null != (parameterizedType = TypeKit.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters[i], value);
            }
            type = rawType;
        }
        return typeMap;
    }
}

