/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lock;

import java.io.Serializable;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.aoju.bus.core.lang.Console;
import org.aoju.bus.core.lock.LockHandler;

public class ObjWithLock<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ReentrantReadWriteLock lock;
    private T object;

    public ObjWithLock(T object) {
        this(object, new ReentrantReadWriteLock());
    }

    public ObjWithLock(T object, ReentrantReadWriteLock lock) {
        this.object = object;
        this.lock = lock;
    }

    public ReentrantReadWriteLock getLock() {
        return this.lock;
    }

    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(LockHandler<T> readLockHandler) {
        ReentrantReadWriteLock.ReadLock readLock = this.lock.readLock();
        readLock.lock();
        try {
            readLockHandler.read(this.object);
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(LockHandler<T> writeLockHandler) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
        writeLock.lock();
        try {
            writeLockHandler.write(this.object);
        }
        catch (Throwable e) {
            Console.error(e.getMessage(), e);
        }
        finally {
            writeLock.unlock();
        }
    }
}

