/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.scanner;

import org.aoju.bus.core.scanner.Synthesized;

@FunctionalInterface
public interface SynthesizedSelector {
    public static final SynthesizedSelector NEAREST_AND_OLDEST_PRIORITY = new NearestAndOldestPrioritySelector();
    public static final SynthesizedSelector NEAREST_AND_NEWEST_PRIORITY = new NearestAndNewestPrioritySelector();
    public static final SynthesizedSelector FARTHEST_AND_OLDEST_PRIORITY = new FarthestAndOldestPrioritySelector();
    public static final SynthesizedSelector FARTHEST_AND_NEWEST_PRIORITY = new FarthestAndNewestPrioritySelector();

    public <T extends Synthesized> T choose(T var1, T var2);

    public static class NearestAndOldestPrioritySelector
    implements SynthesizedSelector {
        @Override
        public <T extends Synthesized> T choose(T oldAnnotation, T newAnnotation) {
            return newAnnotation.getVerticalDistance() < oldAnnotation.getVerticalDistance() ? newAnnotation : oldAnnotation;
        }
    }

    public static class NearestAndNewestPrioritySelector
    implements SynthesizedSelector {
        @Override
        public <T extends Synthesized> T choose(T oldAnnotation, T newAnnotation) {
            return newAnnotation.getVerticalDistance() <= oldAnnotation.getVerticalDistance() ? newAnnotation : oldAnnotation;
        }
    }

    public static class FarthestAndOldestPrioritySelector
    implements SynthesizedSelector {
        @Override
        public <T extends Synthesized> T choose(T oldAnnotation, T newAnnotation) {
            return newAnnotation.getVerticalDistance() > oldAnnotation.getVerticalDistance() ? newAnnotation : oldAnnotation;
        }
    }

    public static class FarthestAndNewestPrioritySelector
    implements SynthesizedSelector {
        @Override
        public <T extends Synthesized> T choose(T oldAnnotation, T newAnnotation) {
            return newAnnotation.getVerticalDistance() >= oldAnnotation.getVerticalDistance() ? newAnnotation : oldAnnotation;
        }
    }
}

