/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.codec;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.lang.mutable.MutableInt;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.CharsKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Base64 {
    private static final byte PADDING = -2;

    public static byte[] encode(byte[] arr, boolean lineSep) {
        return lineSep ? java.util.Base64.getMimeEncoder().encode(arr) : java.util.Base64.getEncoder().encode(arr);
    }

    public static String encode(CharSequence source) {
        return Base64.encode(source, Charset.UTF_8);
    }

    public static String encodeUrlSafe(CharSequence source) {
        return Base64.encodeUrlSafe(source, Charset.UTF_8);
    }

    public static String encode(CharSequence source, String charset) {
        return Base64.encode(source, Charset.charset(charset));
    }

    public static String encodeWithoutPadding(CharSequence source, String charset) {
        return Base64.encodeWithoutPadding(StringKit.bytes(source, charset));
    }

    public static String encode(CharSequence source, java.nio.charset.Charset charset) {
        return Base64.encode(StringKit.bytes(source, charset));
    }

    public static String encodeUrlSafe(CharSequence source, java.nio.charset.Charset charset) {
        return Base64.encodeUrlSafe(StringKit.bytes(source, charset));
    }

    public static String encode(byte[] source) {
        return java.util.Base64.getEncoder().encodeToString(source);
    }

    public static String encodeWithoutPadding(byte[] source) {
        return java.util.Base64.getEncoder().withoutPadding().encodeToString(source);
    }

    public static String encodeUrlSafe(byte[] source) {
        return java.util.Base64.getUrlEncoder().withoutPadding().encodeToString(source);
    }

    public static String encode(InputStream in) {
        return Base64.encode(IoKit.readBytes(in));
    }

    public static String encodeUrlSafe(InputStream in) {
        return Base64.encodeUrlSafe(IoKit.readBytes(in));
    }

    public static String encode(File file) {
        return Base64.encode(FileKit.readBytes(file));
    }

    public static String encodeUrlSafe(File file) {
        return Base64.encodeUrlSafe(FileKit.readBytes(file));
    }

    public static String encodeString(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        return StringKit.toString(Base64.encode(arr, isMultiLine, isUrlSafe), Charset.UTF_8);
    }

    public static byte[] encode(byte[] arr, boolean isMultiLine, boolean isUrlSafe) {
        if (null == arr) {
            return null;
        }
        int len = arr.length;
        if (len == 0) {
            return Normal.EMPTY_BYTE_ARRAY;
        }
        int evenlen = len / 3 * 3;
        int cnt = (len - 1) / 3 + 1 << 2;
        int destlen = cnt + (isMultiLine ? (cnt - 1) / 76 << 1 : 0);
        byte[] dest = new byte[destlen];
        byte[] encodeTable = isUrlSafe ? Normal.ENCODE_URL_TABLE : Normal.ENCODE_64_TABLE;
        int s = 0;
        int d = 0;
        int cc = 0;
        while (s < evenlen) {
            int i = (arr[s++] & 0xFF) << 16 | (arr[s++] & 0xFF) << 8 | arr[s++] & 0xFF;
            dest[d++] = encodeTable[i >>> 18 & 0x3F];
            dest[d++] = encodeTable[i >>> 12 & 0x3F];
            dest[d++] = encodeTable[i >>> 6 & 0x3F];
            dest[d++] = encodeTable[i & 0x3F];
            if (!isMultiLine || ++cc != 19 || d >= destlen - 2) continue;
            dest[d++] = 13;
            dest[d++] = 10;
            cc = 0;
        }
        int left = len - evenlen;
        if (left > 0) {
            int i = (arr[evenlen] & 0xFF) << 10 | (left == 2 ? (arr[len - 1] & 0xFF) << 2 : 0);
            dest[destlen - 4] = encodeTable[i >> 12];
            dest[destlen - 3] = encodeTable[i >>> 6 & 0x3F];
            if (isUrlSafe) {
                int urlSafeLen = destlen - 2;
                if (2 == left) {
                    dest[destlen - 2] = encodeTable[i & 0x3F];
                    ++urlSafeLen;
                }
                byte[] urlSafeDest = new byte[urlSafeLen];
                System.arraycopy(dest, 0, urlSafeDest, 0, urlSafeLen);
                return urlSafeDest;
            }
            dest[destlen - 2] = left == 2 ? encodeTable[i & 0x3F] : 61;
            dest[destlen - 1] = 61;
        }
        return dest;
    }

    public static void encode(byte[] src, int srcPos, int srcLen, char[] dest, int destPos) {
        byte b2;
        byte b1;
        if (srcPos < 0 || srcLen < 0 || srcLen > src.length - srcPos) {
            throw new IndexOutOfBoundsException();
        }
        int destLen = srcLen * 4 / 3 + 3 & 0xFFFFFFFC;
        if (destPos < 0 || destLen > dest.length - destPos) {
            throw new IndexOutOfBoundsException();
        }
        int n = srcLen / 3;
        int r = srcLen - 3 * n;
        while (n-- > 0) {
            int n2 = destPos++;
            b1 = src[srcPos++];
            dest[n2] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
            int n3 = destPos++;
            b2 = src[srcPos++];
            dest[n3] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
            int n4 = destPos++;
            byte b3 = src[srcPos++];
            dest[n4] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b2 & 0xF) << 2 | b3 >>> 6 & 3];
            dest[destPos++] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b3 & 0x3F];
        }
        if (r > 0) {
            if (r == 1) {
                int n5 = destPos++;
                b1 = src[srcPos];
                dest[n5] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
                dest[destPos++] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4];
                dest[destPos++] = 61;
                dest[destPos++] = 61;
            } else {
                int n6 = destPos++;
                b1 = src[srcPos++];
                dest[n6] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[b1 >>> 2 & 0x3F];
                int n7 = destPos++;
                b2 = src[srcPos];
                dest[n7] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b1 & 3) << 4 | b2 >>> 4 & 0xF];
                dest[destPos++] = CharsKit.getChars(Normal.ENCODE_64_TABLE)[(b2 & 0xF) << 2];
                dest[destPos++] = 61;
            }
        }
    }

    public static String decodeStrGbk(CharSequence source) {
        return StringKit.toString(Base64.decode(source), Charset.GBK);
    }

    public static String decodeString(CharSequence source) {
        return Base64.decodeString(source, Charset.UTF_8);
    }

    public static String decodeString(CharSequence source, String charset) {
        return Base64.decodeString(source, Charset.charset(charset));
    }

    public static String decodeString(CharSequence source, java.nio.charset.Charset charset) {
        return StringKit.toString(Base64.decode(source), charset);
    }

    public static File decodeToFile(CharSequence base64, File destFile) {
        return FileKit.writeBytes(Base64.decode(base64), destFile);
    }

    public static void decodeToStream(CharSequence base64, OutputStream out, boolean isCloseOut) {
        IoKit.write(out, isCloseOut, Base64.decode(base64));
    }

    public static byte[] decode(CharSequence base64) {
        return Base64.decode(StringKit.bytes(base64, Charset.UTF_8));
    }

    public static byte[] decode(byte[] in) {
        if (ArrayKit.isEmpty(in)) {
            return in;
        }
        return Base64.decode(in, 0, in.length);
    }

    public static byte[] decode(byte[] in, int pos, int length) {
        if (ArrayKit.isEmpty(in)) {
            return in;
        }
        MutableInt offset = new MutableInt(pos);
        int maxPos = pos + length - 1;
        int octetId = 0;
        byte[] octet = new byte[length * 3 / 4];
        while (offset.intValue() <= maxPos) {
            byte sestet0 = Base64.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet1 = Base64.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet2 = Base64.getNextValidDecodeByte(in, offset, maxPos);
            byte sestet3 = Base64.getNextValidDecodeByte(in, offset, maxPos);
            if (-2 != sestet1) {
                octet[octetId++] = (byte)(sestet0 << 2 | sestet1 >>> 4);
            }
            if (-2 != sestet2) {
                octet[octetId++] = (byte)((sestet1 & 0xF) << 4 | sestet2 >>> 2);
            }
            if (-2 == sestet3) continue;
            octet[octetId++] = (byte)((sestet2 & 3) << 6 | sestet3);
        }
        if (octetId == octet.length) {
            return octet;
        }
        return (byte[])ArrayKit.copy(octet, new byte[octetId], octetId);
    }

    public static void decode(char[] ch, int off, int len, OutputStream out) {
        try {
            while ((len -= 2) >= 0) {
                int n = off++;
                byte b2 = Normal.DECODE_64_TABLE[ch[off++]];
                out.write((byte)(Normal.DECODE_64_TABLE[ch[n]] << 2 | b2 >>> 4));
                if (len-- != 0 && ch[off] != '=') {
                    byte b3 = Normal.DECODE_64_TABLE[ch[off++]];
                    out.write((byte)(b2 << 4 | b3 >>> 2));
                    if (len-- != 0 && ch[off] != '=') {
                        out.write((byte)(b3 << 6 | Normal.DECODE_64_TABLE[ch[off++]]));
                        continue;
                    }
                }
                break;
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static boolean isBase64(CharSequence base64) {
        if (base64 == null || base64.length() < 2) {
            return false;
        }
        byte[] bytes = StringKit.bytes(base64, Charset.UTF_8);
        if (bytes.length != base64.length()) {
            return false;
        }
        return Base64.isBase64(bytes);
    }

    public static boolean isBase64(byte[] base64Bytes) {
        if (base64Bytes == null || base64Bytes.length < 3) {
            return false;
        }
        boolean hasPadding = false;
        for (byte base64Byte : base64Bytes) {
            if (hasPadding) {
                if (61 == base64Byte) continue;
                return false;
            }
            if (61 == base64Byte) {
                hasPadding = true;
                continue;
            }
            if (Base64.isBase64Code(base64Byte) || Base64.isWhiteSpace(base64Byte)) continue;
            return false;
        }
        return true;
    }

    public static boolean isBase64Code(byte octet) {
        return octet == 61 || octet >= 0 && octet < Normal.DECODE_64_TABLE.length && Normal.DECODE_64_TABLE[octet] != -1;
    }

    private static byte getNextValidDecodeByte(byte[] in, MutableInt pos, int maxPos) {
        while (pos.intValue() <= maxPos) {
            byte decodeByte;
            byte base64Byte = in[pos.intValue()];
            pos.increment();
            if (base64Byte <= -1 || (decodeByte = Normal.DECODE_64_TABLE[base64Byte]) <= -1) continue;
            return decodeByte;
        }
        return -2;
    }

    private static boolean isWhiteSpace(byte byteToCheck) {
        switch (byteToCheck) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }
}

