/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.collection;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aoju.bus.core.collection.TransitionIterator;
import org.aoju.bus.core.lang.Assert;

public class TransitionCollection<F, T>
extends AbstractCollection<T> {
    private final Collection<F> fromCollection;
    private final Function<? super F, ? extends T> function;

    public TransitionCollection(Collection<F> fromCollection, Function<? super F, ? extends T> function) {
        this.fromCollection = Assert.notNull(fromCollection);
        this.function = Assert.notNull(function);
    }

    @Override
    public Iterator<T> iterator() {
        return new TransitionIterator<F, T>(this.fromCollection.iterator(), this.function);
    }

    @Override
    public void clear() {
        this.fromCollection.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.fromCollection.isEmpty();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        Assert.notNull(action);
        this.fromCollection.forEach(f -> action.accept((T)this.function.apply(f)));
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        Assert.notNull(filter);
        return this.fromCollection.removeIf((? super E element) -> filter.test((T)this.function.apply(element)));
    }

    @Override
    public java.util.Spliterator<T> spliterator() {
        return new Spliterator<F, T>(this.fromCollection.spliterator(), this.function);
    }

    @Override
    public int size() {
        return this.fromCollection.size();
    }

    public static class Spliterator<F, T>
    implements java.util.Spliterator<T> {
        private final java.util.Spliterator<F> fromSpliterator;
        private final Function<? super F, ? extends T> function;

        public Spliterator(java.util.Spliterator<F> fromSpliterator, Function<? super F, ? extends T> function) {
            this.fromSpliterator = fromSpliterator;
            this.function = function;
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            return this.fromSpliterator.tryAdvance(fromElement -> action.accept((T)this.function.apply(fromElement)));
        }

        @Override
        public void forEachRemaining(Consumer<? super T> action) {
            this.fromSpliterator.forEachRemaining(fromElement -> action.accept((T)this.function.apply(fromElement)));
        }

        @Override
        public java.util.Spliterator<T> trySplit() {
            java.util.Spliterator<F> fromSplit = this.fromSpliterator.trySplit();
            return fromSplit != null ? new Spliterator<F, T>(fromSplit, this.function) : null;
        }

        @Override
        public long estimateSize() {
            return this.fromSpliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.fromSpliterator.characteristics() & 0xFFFFFEFA;
        }
    }
}

